/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.websocket.FrameTranscoder$;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.package$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0005i<aAE\n\t\u0002UIbAB\u000e\u0014\u0011\u0003)B\u0004C\u0003$\u0003\u0011\u0005QE\u0002\u0003'\u0003\t9\u0003\u0002\u0003\u001b\u0004\u0005\u000b\u0007I\u0011A\u001b\t\u0011y\u001a!\u0011!Q\u0001\nYBQaI\u0002\u0005\u0002}BQaQ\u0001\u0005\n\u0011CQaV\u0001\u0005\naCQ!X\u0001\u0005\nyCQ\u0001Y\u0001\u0005\n\u0005DQaY\u0001\u0005\n\u00114AaG\n\u0001M\"Aq\r\u0004BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0019\t\u0005\t\u0015!\u0003j\u0011\u0015\u0019C\u0002\"\u0001n\u0011\u0015\u0001H\u0002\"\u0001r\u0011\u00159H\u0002\"\u0001y\u0003=1%/Y7f)J\fgn]2pI\u0016\u0014(B\u0001\u000b\u0016\u0003%9XMY:pG.,GO\u0003\u0002\u0017/\u00051\u0001\u000e\u001e;qiMT\u0011\u0001G\u0001\u0004_J<\u0007C\u0001\u000e\u0002\u001b\u0005\u0019\"a\u0004$sC6,GK]1og\u000e|G-\u001a:\u0014\u0005\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005I\"A\u0004+sC:\u001c8m\u001c3f\u000bJ\u0014xN]\n\u0003\u0007!\u0002\"!K\u0019\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017%\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u00021?\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u0005%)\u0005pY3qi&|gN\u0003\u00021?\u00059Q.Z:tC\u001e,W#\u0001\u001c\u0011\u0005]ZdB\u0001\u001d:!\tYs$\u0003\u0002;?\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQt$\u0001\u0005nKN\u001c\u0018mZ3!)\t\u0001%\t\u0005\u0002B\u00075\t\u0011\u0001C\u00035\r\u0001\u0007a'\u0001\u0007eK\u000e|G-\u001a\"j]\u0006\u0014\u0018\u0010F\u0002F\u0017V\u00032A\b$I\u0013\t9uDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001f\u0013&\u0011!j\b\u0002\u0005\u0005f$X\rC\u0003M\u000f\u0001\u0007Q*\u0001\u0002j]B\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004]&|'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013!BQ=uK\n+hMZ3s\u0011\u00151v\u00011\u0001F\u0003\u0011i\u0017m]6\u0002\u00191,gn\u001a;i\u001f\u001a47/\u001a;\u0015\u0005ec\u0006C\u0001\u0010[\u0013\tYvDA\u0002J]RDQ\u0001\u0014\u0005A\u00025\u000bqaZ3u\u001b\u0006\u001c8\u000e\u0006\u0002F?\")A*\u0003a\u0001\u001b\u0006Q!m\u001c3z\u0019\u0016tw\r\u001e5\u0015\u0005e\u0013\u0007\"\u0002'\u000b\u0001\u0004i\u0015\u0001D4fi6\u001bx\rT3oORDGCA-f\u0011\u0015a5\u00021\u0001N'\taQ$\u0001\u0005jg\u000ec\u0017.\u001a8u+\u0005I\u0007C\u0001\u0010k\u0013\tYwDA\u0004C_>dW-\u00198\u0002\u0013%\u001c8\t\\5f]R\u0004CC\u00018p!\tQB\u0002C\u0003h\u001f\u0001\u0007\u0011.A\u0007ge\u0006lW\rV8Ck\u001a4WM\u001d\u000b\u0003eN\u00042A\b$N\u0011\u0015a\u0005\u00031\u0001u!\tQR/\u0003\u0002w'\tqq+\u001a2T_\u000e\\W\r\u001e$sC6,\u0017!\u00042vM\u001a,'\u000fV8Ge\u0006lW\r\u0006\u0002us\")A*\u0005a\u0001\u001b\u0002")
public class FrameTranscoder {
    private final boolean isClient;

    public boolean isClient() {
        return this.isClient;
    }

    public ByteBuffer[] frameToBuffer(WebSocketFrame in) {
        int size = 2;
        if (this.isClient()) {
            size += 4;
        }
        if (in.length() >= 126) {
            size = in.length() <= 65535 ? (size += 2) : (size += 8);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.isClient() ? size + in.length() : size);
        int opcode = in.opcode();
        if (in.length() > 125 && (opcode == package$.MODULE$.PING() || opcode == package$.MODULE$.PONG() || opcode == package$.MODULE$.CLOSE())) {
            throw new TranscodeError(new StringBuilder(36).append("Invalid PING frame: frame too long: ").append(in.length()).toString());
        }
        int b1 = in.last() ? opcode | package$.MODULE$.FINISHED() : opcode;
        buff.put((byte)b1);
        int b2 = 0;
        if (this.isClient()) {
            b2 = package$.MODULE$.MASK();
        }
        b2 = in.length() < 126 ? (b2 |= in.length()) : (in.length() <= 65535 ? (b2 |= 0x7E) : (b2 |= 0x7F));
        buff.put((byte)b2);
        if (in.length() > 125 && in.length() <= 65535) {
            buff.put((byte)(in.length() >>> 8 & 0xFF)).put((byte)(in.length() & 0xFF));
        } else if (in.length() > 65535) {
            buff.putLong(in.length());
        }
        if (this.isClient() && in.length() > 0) {
            int mask = (int)(Math.random() * (double)Integer.MAX_VALUE);
            byte[] maskBits = new byte[]{(byte)(mask >>> 24 & 0xFF), (byte)(mask >>> 16 & 0xFF), (byte)(mask >>> 8 & 0xFF), (byte)(mask >>> 0 & 0xFF)};
            buff.put(maskBits);
            ByteVector data = in.data();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), in.length()).foreach((Function1 & Serializable)i -> buff.put((byte)(data.apply((long)BoxesRunTime.unboxToInt((Object)i)) ^ maskBits[BoxesRunTime.unboxToInt((Object)i) & 3])));
            buff.flip();
            return (ByteBuffer[])((Object[])new ByteBuffer[]{buff});
        }
        buff.flip();
        return (ByteBuffer[])((Object[])new ByteBuffer[]{buff, in.data().toByteBuffer()});
    }

    public WebSocketFrame bufferToFrame(ByteBuffer in) {
        byte[] byArray;
        boolean masked;
        if (in.remaining() < 2 || FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMsgLength(in) < 0) {
            return null;
        }
        int opcode = in.get(0) & package$.MODULE$.OP_CODE();
        boolean finished = (in.get(0) & package$.MODULE$.FINISHED()) != 0;
        boolean bl = masked = (in.get(1) & package$.MODULE$.MASK()) != 0;
        if (masked && this.isClient()) {
            throw new TranscodeError("Client received a masked message");
        }
        int bodyOffset = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$lengthOffset(in);
        if (masked) {
            bodyOffset += 4;
            byArray = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMask(in);
        } else {
            byArray = null;
        }
        byte[] m = byArray;
        int oldLim = in.limit();
        int bodylen = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$bodyLength(in);
        in.position(bodyOffset);
        in.limit(in.position() + bodylen);
        ByteBuffer slice = in.slice();
        in.position(in.limit());
        in.limit(oldLim);
        return package$.MODULE$.makeFrame(opcode, ByteVector$.MODULE$.view(FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$decodeBinary(slice, m)), finished);
    }

    public FrameTranscoder(boolean isClient) {
        this.isClient = isClient;
    }

    public static final class TranscodeError
    extends Exception {
        private final String message;

        public String message() {
            return this.message;
        }

        public TranscodeError(String message) {
            this.message = message;
            super(message);
        }
    }
}

