/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;

public class ConverterPrimitiveTypes
extends AbstractCsvConverter {
    protected final ConvertUtilsBean converter;
    protected final LocaleConvertUtilsBean localeConverter;

    public ConverterPrimitiveTypes(Class<?> type, String locale, Locale errorLocale) {
        super(type, locale, errorLocale);
        if (this.locale == null) {
            this.converter = new ConvertUtilsBean();
            this.converter.register(true, false, 0);
            this.localeConverter = null;
        } else {
            this.localeConverter = new LocaleConvertUtilsBean();
            this.localeConverter.setDefaultLocale(this.locale);
            this.converter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertToRead(String value) throws CsvDataTypeMismatchException {
        Object o;
        block10: {
            o = null;
            if (StringUtils.isNotBlank(value) || value != null && this.type.equals(String.class)) {
                try {
                    if (this.converter != null) {
                        ConvertUtilsBean convertUtilsBean = this.converter;
                        synchronized (convertUtilsBean) {
                            o = this.converter.convert(value, this.type);
                            break block10;
                        }
                    }
                    LocaleConvertUtilsBean localeConvertUtilsBean = this.localeConverter;
                    synchronized (localeConvertUtilsBean) {
                        o = this.localeConverter.convert(value, this.type);
                    }
                }
                catch (ConversionException e) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, this.type, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("conversion.impossible"), value, this.type.getCanonicalName()));
                    csve.initCause(e);
                    throw csve;
                }
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result2;
        block10: {
            result2 = null;
            if (value != null) {
                try {
                    if (this.converter != null) {
                        ConvertUtilsBean convertUtilsBean = this.converter;
                        synchronized (convertUtilsBean) {
                            result2 = this.converter.convert(value);
                            break block10;
                        }
                    }
                    LocaleConvertUtilsBean localeConvertUtilsBean = this.localeConverter;
                    synchronized (localeConvertUtilsBean) {
                        result2 = this.localeConverter.convert(value);
                    }
                }
                catch (ConversionException e) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("field.not.primitive"));
                    csve.initCause(e);
                    throw csve;
                }
            }
        }
        return result2;
    }
}

