/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractFieldMap;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.FieldMapByPositionEntry;
import com.opencsv.bean.PositionToBeanField;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.iterators.LazyIteratorChain;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;

public class FieldMapByPosition<T>
extends AbstractFieldMap<String, Integer, PositionToBeanField<T>, T>
implements Iterable<FieldMapByPositionEntry<T>> {
    private int maxIndex = Integer.MAX_VALUE;
    private Comparator<Integer> writeOrder = null;

    public FieldMapByPosition(Locale errorLocale) {
        super(errorLocale);
    }

    @Override
    public String[] generateHeader(T bean) throws CsvRequiredFieldEmptyException {
        LinkedList<Field> missingRequiredHeaders = new LinkedList<Field>();
        TreeMap<Integer, String> headerMap = new TreeMap<Integer, String>(this.writeOrder);
        for (Map.Entry entry : this.simpleMap.entrySet()) {
            headerMap.put((Integer)entry.getKey(), ((BeanField)entry.getValue()).getField().getName());
        }
        for (ComplexFieldMapEntry r : this.complexMapList) {
            MultiValuedMap m = (MultiValuedMap)r.getBeanField().getFieldValue(bean);
            boolean oneEntryMatched = false;
            if (m != null && !m.isEmpty()) {
                for (Map.Entry entry : m.entries()) {
                    Integer key = (Integer)entry.getKey();
                    if (!r.contains(key)) continue;
                    headerMap.put((Integer)entry.getKey(), r.getBeanField().getField().getName());
                    oneEntryMatched = true;
                }
            }
            if (m != null && !m.isEmpty() && oneEntryMatched || !r.getBeanField().isRequired()) continue;
            missingRequiredHeaders.add(r.getBeanField().getField());
        }
        TreeSet headerSet = new TreeSet(headerMap.keySet());
        int arraySize = headerSet.isEmpty() ? 0 : (Integer)headerSet.last() + 1;
        Object[] headers = new String[arraySize];
        int previousIndex = headerSet.isEmpty() ? 0 : (Integer)headerSet.first();
        for (Integer i : headerSet) {
            for (int j = previousIndex + 1; j < i; ++j) {
                headerMap.put(j, null);
            }
            previousIndex = i;
        }
        previousIndex = 0;
        for (String value : headerMap.values()) {
            headers[previousIndex++] = value;
        }
        if (!missingRequiredHeaders.isEmpty()) {
            TextStringBuilder sb = new TextStringBuilder();
            for (Field f : missingRequiredHeaders) {
                sb.appendSeparator(' ');
                sb.append(f.getName());
            }
            String errorMessage = String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.required.field.absent"), sb.toString(), StringUtils.join(headers, ' '));
            throw new CsvRequiredFieldEmptyException(bean.getClass(), missingRequiredHeaders, errorMessage);
        }
        return headers;
    }

    @Override
    public void putComplex(String rangeDefinition, BeanField<T> field2) {
        this.complexMapList.add(new PositionToBeanField<T>(rangeDefinition, this.maxIndex, field2, this.errorLocale));
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
        for (PositionToBeanField p : this.complexMapList) {
            p.attenuateRanges(maxIndex);
        }
    }

    @Override
    public Iterator<FieldMapByPositionEntry<T>> iterator() {
        return new LazyIteratorChain<FieldMapByPositionEntry<T>>(){

            @Override
            protected Iterator<FieldMapByPositionEntry<T>> nextIterator(int count) {
                if (count <= FieldMapByPosition.this.complexMapList.size()) {
                    return ((PositionToBeanField)FieldMapByPosition.this.complexMapList.get(count - 1)).iterator();
                }
                if (count == FieldMapByPosition.this.complexMapList.size() + 1) {
                    return new TransformIterator(FieldMapByPosition.this.simpleMap.entrySet().iterator(), new Transformer<Map.Entry<Integer, BeanField<T>>, FieldMapByPositionEntry<T>>(){

                        @Override
                        public FieldMapByPositionEntry<T> transform(Map.Entry<Integer, BeanField<T>> input) {
                            return new FieldMapByPositionEntry(input.getKey(), input.getValue());
                        }
                    });
                }
                return null;
            }
        };
    }

    public void setColumnOrderOnWrite(Comparator<Integer> writeOrder) {
        this.writeOrder = writeOrder;
    }
}

