/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.ContextShift;
import cats.effect.Sync;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.internal.FreeC;
import fs2.io.file.FileHandle;
import fs2.io.file.FileHandle$;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

public final class pulls$ {
    public static pulls$ MODULE$;

    static {
        new pulls$();
    }

    public <F> FreeC<?, BoxedUnit> readAllFromFileHandle(int chunkSize, FileHandle<F> h) {
        return this._readAllFromFileHandle0(chunkSize, 0L, h);
    }

    public <F> FreeC<?, BoxedUnit> readRangeFromFileHandle(int chunkSize, long start, long end, FileHandle<F> h) {
        return this._readRangeFromFileHandle0(chunkSize, start, end, h);
    }

    private <F> FreeC<?, BoxedUnit> _readRangeFromFileHandle0(int chunkSize, long offset, long end, FileHandle<F> h) {
        FreeC<?, BoxedUnit> freeC;
        long bytesLeft = end - offset;
        if (bytesLeft <= 0L) {
            freeC = Pull$.MODULE$.done();
        } else {
            int actualChunkSize = bytesLeft > Integer.MAX_VALUE ? chunkSize : package$.MODULE$.min(chunkSize, (int)bytesLeft);
            freeC = Pull$.MODULE$.flatMap$extension(Pull$.MODULE$.eval(h.read(actualChunkSize, offset)), (Function1<Option, Object> & Serializable & scala.Serializable)x0$1 -> new Pull(pulls$.$anonfun$_readRangeFromFileHandle0$1(chunkSize, offset, end, h, x0$1)));
        }
        return freeC;
    }

    private <F> FreeC<?, BoxedUnit> _readAllFromFileHandle0(int chunkSize, long offset, FileHandle<F> h) {
        return Pull$.MODULE$.flatMap$extension(Pull$.MODULE$.eval(h.read(chunkSize, offset)), (Function1<Option, Object> & Serializable & scala.Serializable)x0$1 -> new Pull(pulls$.$anonfun$_readAllFromFileHandle0$1(chunkSize, offset, h, x0$1)));
    }

    public <F> FreeC<?, BoxedUnit> writeAllToFileHandle(FreeC<?, BoxedUnit> in, FileHandle<F> out) {
        return this.writeAllToFileHandleAtOffset(in, out, 0L);
    }

    public <F> FreeC<?, BoxedUnit> writeAllToFileHandleAtOffset(FreeC<?, BoxedUnit> in, FileHandle<F> out, long offset) {
        return Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in))), (Function1<Option, Object> & Serializable & scala.Serializable)x0$1 -> new Pull(pulls$.$anonfun$writeAllToFileHandleAtOffset$1(out, offset, x0$1)));
    }

    private <F> FreeC<?, BoxedUnit> writeChunkToFileHandle(Chunk<Object> buf, FileHandle<F> out, long offset) {
        return Pull$.MODULE$.flatMap$extension(Pull$.MODULE$.eval(out.write(buf, offset)), (Function1<Object, Object> & Serializable & scala.Serializable)written -> new Pull(pulls$.$anonfun$writeChunkToFileHandle$1(buf, out, offset, BoxesRunTime.unboxToInt(written))));
    }

    public <F> FreeC<?, Pull.Cancellable<F, FileHandle<F>>> fromPath(Path path, ExecutionContext blockingExecutionContext, Seq<OpenOption> flags, Sync<F> F, ContextShift<F> cs) {
        return this.fromFileChannel(F.delay((Function0<FileChannel> & Serializable & scala.Serializable)() -> FileChannel.open(path, (OpenOption[])flags.toArray(ClassTag$.MODULE$.apply(OpenOption.class)))), blockingExecutionContext, F, cs);
    }

    public <F> FreeC<?, Pull.Cancellable<F, FileHandle<F>>> fromFileChannel(F channel, ExecutionContext blockingExecutionContext, Sync<F> F, ContextShift<F> cs) {
        return Pull$.MODULE$.map$extension(Pull$.MODULE$.acquireCancellable(channel, (Function1<FileChannel, Object> & Serializable & scala.Serializable)ch -> F.delay((JFunction0$mcV$sp & scala.Serializable)() -> ch.close()), RaiseThrowable$.MODULE$.fromApplicativeError(F)), (Function1<Pull.Cancellable, Pull.Cancellable> & Serializable & scala.Serializable)x$1 -> x$1.map((Function1<FileChannel, FileHandle> & Serializable & scala.Serializable)x$2 -> FileHandle$.MODULE$.fromFileChannel((FileChannel)x$2, blockingExecutionContext, F, cs)));
    }

    public static final /* synthetic */ FreeC $anonfun$_readRangeFromFileHandle0$1(int chunkSize$1, long offset$1, long end$1, FileHandle h$1, Option x0$1) {
        FreeC<?, BoxedUnit> freeC;
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Chunk o = (Chunk)some.value();
            freeC = Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(o), (Function0<Object> & Serializable & scala.Serializable)() -> new Pull(pulls$.MODULE$._readRangeFromFileHandle0(chunkSize$1, offset$1 + (long)o.size(), end$1, h$1)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.done();
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_readAllFromFileHandle0$1(int chunkSize$2, long offset$2, FileHandle h$2, Option x0$1) {
        FreeC<?, BoxedUnit> freeC;
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Chunk o = (Chunk)some.value();
            freeC = Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(o), (Function0<Object> & Serializable & scala.Serializable)() -> new Pull(pulls$.MODULE$._readAllFromFileHandle0(chunkSize$2, offset$2 + (long)o.size(), h$2)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.done();
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$writeAllToFileHandleAtOffset$1(FileHandle out$1, long offset$3, Option x0$1) {
        Some some;
        Tuple2 tuple2;
        FreeC<?, BoxedUnit> freeC;
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.done();
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk hd = (Chunk)tuple2._1();
            FreeC<?, BoxedUnit> tl = ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = Pull$.MODULE$.$greater$greater$extension(MODULE$.writeChunkToFileHandle(hd, out$1, offset$3), (Function0<Object> & Serializable & scala.Serializable)() -> new Pull(pulls$.MODULE$.writeAllToFileHandleAtOffset(tl, out$1, offset$3 + (long)hd.size())));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$writeChunkToFileHandle$1(Chunk buf$1, FileHandle out$2, long offset$4, int written) {
        return written >= buf$1.size() ? Pull$.MODULE$.pure(BoxedUnit.UNIT) : MODULE$.writeChunkToFileHandle(buf$1.drop(written), out$2, offset$4 + (long)written);
    }

    private pulls$() {
        MODULE$ = this;
    }
}

