/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.api.ontology;

import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.implicits$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import net.shrine.api.ontology.CODE_CATEGORY;
import net.shrine.api.ontology.CODE_SET;
import net.shrine.api.ontology.CaseInsensitiveSort$;
import net.shrine.api.ontology.CodeCategoryTerm;
import net.shrine.api.ontology.CodeCategoryTerm$;
import net.shrine.api.ontology.ConceptInfo;
import net.shrine.api.ontology.ConceptInfo$;
import net.shrine.api.ontology.ConceptType;
import net.shrine.api.ontology.FilterData;
import net.shrine.api.ontology.FilterType;
import net.shrine.api.ontology.FilterableType;
import net.shrine.api.ontology.HtmlHighlighter$;
import net.shrine.api.ontology.LabDetail;
import net.shrine.api.ontology.LuceneSearcher;
import net.shrine.api.ontology.NO_FILTER;
import net.shrine.api.ontology.OntologyPath;
import net.shrine.api.ontology.OntologyTerm;
import net.shrine.api.ontology.SearchQuery;
import net.shrine.api.ontology.SearchResults;
import net.shrine.api.ontology.SearchResultsMetadata;
import net.shrine.api.ontology.Trie;
import net.shrine.api.ontology.TrieNode;
import net.shrine.api.ontology.VisualAttributes;
import net.shrine.api.ontology.VisualAttributes$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.source.ConfigSource$;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.http4s.EntityDecoder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import shapeless.$colon$colon;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.lazily$;
import shapeless.ops.hlist$ZipWithKeys$;

public final class LuceneSearcher$ {
    public static LuceneSearcher$ MODULE$;
    private final String indexFileLocation;
    private final File indexDir;
    private final FSDirectory directory;
    private final IndexSearcher searcher;
    private volatile byte bitmap$init$0;

    static {
        new LuceneSearcher$();
    }

    private String indexFileLocation() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/services/ontology/src/main/scala/net/shrine/api/ontology/LuceneSearcher.scala: 23");
        }
        return this.indexFileLocation;
    }

    private File indexDir() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/services/ontology/src/main/scala/net/shrine/api/ontology/LuceneSearcher.scala: 24");
        }
        return this.indexDir;
    }

    private FSDirectory directory() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/services/ontology/src/main/scala/net/shrine/api/ontology/LuceneSearcher.scala: 25");
        }
        return this.directory;
    }

    public IndexSearcher searcher() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/services/ontology/src/main/scala/net/shrine/api/ontology/LuceneSearcher.scala: 27");
        }
        return this.searcher;
    }

    private CodeCategoryTerm createCodeCategoryTerm(String displayName, List<OntologyTerm> children) {
        String x$1 = displayName;
        List<OntologyTerm> x$2 = children;
        ConceptType x$3 = CodeCategoryTerm$.MODULE$.apply$default$2();
        boolean x$4 = CodeCategoryTerm$.MODULE$.apply$default$3();
        return new CodeCategoryTerm(x$1, x$3, x$4, x$2);
    }

    public IO<List<CodeCategoryTerm>> getRootTerms() {
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1<TopFieldDocs, List> & Serializable & scala.Serializable)foundDocs -> {
            GenMap docsToCodeCategories = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).groupBy((Function1<ScoreDoc, String> & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"));
            SortedMap sortedDocsToCategories = (SortedMap)SortedMap$.MODULE$.apply((Seq)docsToCodeCategories.toSeq().sortBy((Function1<Tuple2, String> & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Ordering$String$.MODULE$), Ordering$String$.MODULE$);
            Iterable codeCategoryTerms = sortedDocsToCategories.map((Function1<Tuple2, CodeCategoryTerm> & Serializable & scala.Serializable)x0$1 -> {
                String string2;
                ScoreDoc[] scoreDocs;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        String codeCategory = (String)tuple2._1();
                        scoreDocs = (ScoreDoc[])tuple2._2();
                        if (codeCategory == null) break block2;
                        string2 = codeCategory;
                        if (scoreDocs != null) break block3;
                    }
                    throw new MatchError(tuple2);
                }
                ScoreDoc[] scoreDocArray = scoreDocs;
                List<OntologyTerm> ontologyTermsList = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scoreDocArray)).toList().map((Function1<ScoreDoc, OntologyTerm> & Serializable & scala.Serializable)sd -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)sd, MODULE$.extractOntologyTermFromScoreDoc$default$2()), List$.MODULE$.canBuildFrom());
                CodeCategoryTerm codeCategoryTerm = MODULE$.createCodeCategoryTerm(string2, ontologyTermsList);
                return codeCategoryTerm;
            }, Iterable$.MODULE$.canBuildFrom());
            return codeCategoryTerms.toList();
        });
    }

    public IO<Map<FilterType, List<String>>> getFilterOptions() {
        scala.collection.immutable.$colon$colon<Nothing$> defaultOption = new scala.collection.immutable.$colon$colon<Nothing$>((Nothing$)((Object)"All Concepts"), Nil$.MODULE$);
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1<TopFieldDocs, Map> & Serializable & scala.Serializable)foundDocs -> {
            String[] allCodeCategories = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).map((Function1<ScoreDoc, String> & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
            String[] allCodeSets = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).map((Function1<ScoreDoc, String> & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeSet"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(LuceneSearcher$.$anonfun$getFilterOptions$4(x$2))))).distinct();
            return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new NO_FILTER()), defaultOption), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new CODE_CATEGORY()), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allCodeCategories)).toList()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new CODE_SET()), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allCodeSets)).toList())}));
        });
    }

    public IO<List<ScoreDoc>> getRawSearchResults(Query query) {
        ContextShift<IO> fileSystemContextShift = IO$.MODULE$.contextShift(ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return fileSystemContextShift.evalOn(ExecutionContexts$.MODULE$.fileSystemExecutionContext(), IO$.MODULE$.apply((Function0<List> & Serializable & scala.Serializable)() -> {
            int maxHits = Integer.MAX_VALUE;
            TopFieldDocs foundDocs = MODULE$.searcher().search(query, maxHits, CaseInsensitiveSort$.MODULE$.apply("displayName"));
            return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).toList();
        }));
    }

    public IO<List<OntologyTerm>> getChildren(OntologyPath ontologyPath) {
        String parentPath = (String)new StringOps(Predef$.MODULE$.augmentString(ontologyPath.path())).dropRight(1);
        TermQuery childrenQuery = new TermQuery(new Term("parentPath", parentPath));
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults(childrenQuery);
        return scoreDocsIO.map((Function1<List, List> & Serializable & scala.Serializable)scoreDocs -> {
            void var1_1;
            List searchHits = scoreDocs.map((Function1<ScoreDoc, OntologyTerm> & Serializable & scala.Serializable)sd -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)sd, MODULE$.extractOntologyTermFromScoreDoc$default$2()), List$.MODULE$.canBuildFrom());
            return var1_1;
        });
    }

    public IO<Option<ConceptInfo>> getConceptInfo(OntologyPath ontologyPath) {
        TermQuery pathQuery = new TermQuery(new Term("path", ontologyPath.path()));
        TermQuery childrenQuery = new TermQuery(new Term("parentPath", (String)new StringOps(Predef$.MODULE$.augmentString(ontologyPath.path())).dropRight(1)));
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add(pathQuery, BooleanClause.Occur.SHOULD).add(childrenQuery, BooleanClause.Occur.SHOULD).build();
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults(booleanQuery);
        return scoreDocsIO.map((Function1<List, Option> & Serializable & scala.Serializable)scoreDocs -> {
            void var3_3;
            List childConcepts = ((List)scoreDocs.filter((Function1<ScoreDoc, Object> & Serializable & scala.Serializable)sd -> BoxesRunTime.boxToBoolean(LuceneSearcher$.$anonfun$getConceptInfo$2(ontologyPath, sd)))).map((Function1<ScoreDoc, ConceptInfo> & Serializable & scala.Serializable)x$3 -> ConceptInfo$.MODULE$.apply((ScoreDoc)x$3, ConceptInfo$.MODULE$.apply$default$2(), ConceptInfo$.MODULE$.apply$default$3()), List$.MODULE$.canBuildFrom());
            Option conceptInfoTerm = scoreDocs.find((Function1<ScoreDoc, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(LuceneSearcher$.$anonfun$getConceptInfo$4(ontologyPath, p))).map((Function1<ScoreDoc, ConceptInfo> & Serializable & scala.Serializable)scoreDoc -> {
                ConceptInfo conceptInfo;
                String[] visPath;
                block3: {
                    Tuple2<ConceptInfo, String[]> tuple2;
                    block2: {
                        String nPath = MODULE$.searcher().doc(scoreDoc.doc).get("nPath");
                        String visAttrPath = MODULE$.searcher().doc(scoreDoc.doc).get("visPath");
                        String[] pathElements = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])nPath.split("\\\\"))).filterNot((Function1<String, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(LuceneSearcher$.$anonfun$getConceptInfo$6(x$4))))).reverse();
                        String[] visPathElements = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])visAttrPath.split("\\\\"))).filterNot((Function1<String, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(LuceneSearcher$.$anonfun$getConceptInfo$7(x$5))))).reverse();
                        ConceptInfo selectedConceptInfo = ConceptInfo$.MODULE$.apply((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])pathElements)).head(), VisualAttributes$.MODULE$.apply((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])visPathElements)).head()), Option$.MODULE$.apply(childConcepts), true);
                        tuple2 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])pathElements)).drop(1))).foldLeft(new Tuple2<ConceptInfo, String[]>(selectedConceptInfo, visPathElements), (Function2<Tuple2, String, Tuple2> & Serializable & scala.Serializable)(items, pathElem) -> {
                            String[] visPaths = (String[])items._2();
                            ConceptInfo conceptInfo = ConceptInfo$.MODULE$.apply((String)pathElem, VisualAttributes$.MODULE$.apply((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])visPaths)).head()), Option$.MODULE$.apply(new scala.collection.immutable.$colon$colon<Nothing$>((Nothing$)((Object)((ConceptInfo)items._1())), Nil$.MODULE$)), false);
                            return new Tuple2<ConceptInfo, Object>(conceptInfo, new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])visPaths)).drop(1));
                        });
                        if (tuple2 == null) break block2;
                        ConceptInfo conceptInfo2 = tuple2._1();
                        visPath = tuple2._2();
                        if (conceptInfo2 == null) break block2;
                        conceptInfo = conceptInfo2;
                        if (visPath != null) break block3;
                    }
                    throw new MatchError(tuple2);
                }
                String[] stringArray = visPath;
                Tuple2<ConceptInfo, String[]> tuple2 = new Tuple2<ConceptInfo, String[]>(conceptInfo, stringArray);
                Tuple2<ConceptInfo, String[]> tuple22 = tuple2;
                ConceptInfo conceptInfo3 = tuple22._1();
                String[] visPath2 = tuple22._2();
                return conceptInfo3;
            });
            return var3_3;
        });
    }

    public OntologyTerm extractOntologyTermFromScoreDoc(ScoreDoc sd, Option<List<ScoreDoc>> childrenScoreDocs) {
        String path = this.searcher().doc(sd.doc).get("path");
        String displayName = this.searcher().doc(sd.doc).get("displayName");
        Option<IndexableField> labFieldOption = Option$.MODULE$.apply(this.searcher().doc(sd.doc).getField("labDetail"));
        boolean isLab = BoxesRunTime.unboxToBoolean(labFieldOption.fold((JFunction0$mcZ$sp & scala.Serializable)() -> false, (Function1<IndexableField, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(LuceneSearcher$.$anonfun$extractOntologyTermFromScoreDoc$2(x$7))));
        String visualAttributes = this.searcher().doc(sd.doc).get("visualAttributes");
        String conceptCategory = this.searcher().doc(sd.doc).get("conceptCategory");
        return this.extractOntologyTerm(path, displayName, visualAttributes, conceptCategory, isLab, childrenScoreDocs, this.extractOntologyTerm$default$7());
    }

    public OntologyTerm extractOntologyTerm(String path, String displayName, String visualAttr, String conceptCategory, boolean isLab, Option<List<ScoreDoc>> childrenScoreDocs, Option<String> highlightedName) {
        VisualAttributes<ConceptType> visualAttributes = VisualAttributes$.MODULE$.apply(visualAttr);
        List childrenOntologyTerms = (List)childrenScoreDocs.fold((Function0<List> & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Function1<List, List> & Serializable & scala.Serializable)csd -> csd.map((Function1<ScoreDoc, OntologyTerm> & Serializable & scala.Serializable)doc -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)doc, MODULE$.extractOntologyTermFromScoreDoc$default$2()), List$.MODULE$.canBuildFrom()));
        String x$1 = displayName;
        Option<String> x$2 = highlightedName;
        String x$3 = path;
        String x$4 = conceptCategory;
        ConceptType x$5 = visualAttributes.conceptType();
        boolean x$6 = visualAttributes.isActive();
        Option<List<OntologyTerm>> x$7 = Option$.MODULE$.apply(childrenOntologyTerms);
        boolean x$8 = isLab;
        OntologyTerm ontTerm = new OntologyTerm(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        return ontTerm;
    }

    public Option<List<ScoreDoc>> extractOntologyTermFromScoreDoc$default$2() {
        return None$.MODULE$;
    }

    public Option<List<ScoreDoc>> extractOntologyTerm$default$6() {
        return None$.MODULE$;
    }

    public Option<String> extractOntologyTerm$default$7() {
        return None$.MODULE$;
    }

    public IO<SearchResults> searchIO(SearchQuery searchQuery) {
        String sortTerm = "nPath";
        ContextShift<IO> fileSystemContextShift = IO$.MODULE$.contextShift(ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return fileSystemContextShift.evalOn(ExecutionContexts$.MODULE$.fileSystemExecutionContext(), IO$.MODULE$.apply((Function0<Tuple2> & Serializable & scala.Serializable)() -> {
            QueryParser parser = new QueryParser("displayName", new StandardAnalyzer());
            parser.setDefaultOperator(QueryParser.Operator.AND);
            Query defaultQuery = parser.parse(new StringBuilder(1).append(QueryParserBase.escape(searchQuery.searchString())).append("*").toString());
            Query filteredQuery = LuceneSearcher$.makeFilteredQuery$1(defaultQuery, searchQuery.filterData());
            int maxResults = ConfigSource$.MODULE$.config().getInt("shrine.lucene.maxSearchResults");
            Sort sort = CaseInsensitiveSort$.MODULE$.apply(sortTerm);
            Option<SearchResultsMetadata> previousSearchMetadataOption = searchQuery.previousSearchMetadata();
            TopFieldDocs foundDocs = (TopFieldDocs)previousSearchMetadataOption.fold((Function0<TopFieldDocs> & Serializable & scala.Serializable)() -> MODULE$.searcher().search(filteredQuery, maxResults, sort), (Function1<SearchResultsMetadata, TopFieldDocs> & Serializable & scala.Serializable)searchMetadata -> {
                BytesRef field2 = new BytesRef(searchMetadata.sortFieldValue());
                Object[] fields = new Object[]{field2};
                FieldDoc lastScoreDoc = new FieldDoc(searchMetadata.lastDocId(), Float.NaN, fields);
                return MODULE$.searcher().searchAfter((ScoreDoc)lastScoreDoc, filteredQuery, maxResults, sort, false);
            });
            Highlighter highlighter = HtmlHighlighter$.MODULE$.createHighlighter(filteredQuery);
            return new Tuple2<TopFieldDocs, Highlighter>(foundDocs, highlighter);
        }).flatMap((Function1<Tuple2, IO> & Serializable & scala.Serializable)params -> {
            TopFieldDocs topFieldDocs;
            Highlighter highlighter;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = params;
                    if (tuple2 == null) break block2;
                    TopFieldDocs allDocs = (TopFieldDocs)tuple2._1();
                    highlighter = (Highlighter)tuple2._2();
                    if (allDocs == null) break block2;
                    topFieldDocs = allDocs;
                    if (highlighter != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            Highlighter highlighter2 = highlighter;
            Tuple2<TopFieldDocs, Highlighter> tuple2 = new Tuple2<TopFieldDocs, Highlighter>(topFieldDocs, highlighter2);
            Tuple2<TopFieldDocs, Highlighter> tuple22 = tuple2;
            TopFieldDocs allDocs = tuple22._1();
            Highlighter highlighter3 = tuple22._2();
            ScoreDoc[] scoreDocs = allDocs.scoreDocs;
            TotalHits totalHits = allDocs.totalHits;
            GenMap docsToCodeCategories = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scoreDocs)).groupBy((Function1<ScoreDoc, String> & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"));
            SortedMap sortedDocsToCategories = (SortedMap)SortedMap$.MODULE$.apply((Seq)docsToCodeCategories.toSeq().sortBy((Function1<Tuple2, String> & Serializable & scala.Serializable)x$9 -> (String)x$9._1(), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForString())), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForString()));
            Iterable codeCategoryTerms = sortedDocsToCategories.map((Function1<Tuple2, IO> & Serializable & scala.Serializable)x0$1 -> {
                String string2;
                ScoreDoc[] scoreDocs;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        String codeCategory = (String)tuple2._1();
                        scoreDocs = (ScoreDoc[])tuple2._2();
                        if (codeCategory == null) break block2;
                        string2 = codeCategory;
                        if (scoreDocs != null) break block3;
                    }
                    throw new MatchError(tuple2);
                }
                ScoreDoc[] scoreDocArray = scoreDocs;
                Trie trie = new Trie(highlighter3);
                BoxedUnit[] fd = (BoxedUnit[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scoreDocArray)).map((Function1<ScoreDoc, Object> & Serializable & scala.Serializable)sd -> {
                    trie.insert(sd);
                    return BoxedUnit.UNIT;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                IO ontTermsIO = IO$.MODULE$.apply((Function0<List> & Serializable & scala.Serializable)() -> MODULE$.buildOntologyTerms(trie.root(), MODULE$.buildOntologyTerms$default$2()));
                IO iO = ontTermsIO.flatMap((Function1<List, IO> & Serializable & scala.Serializable)ontTermsList -> IO$.MODULE$.apply((Function0<CodeCategoryTerm> & Serializable & scala.Serializable)() -> MODULE$.createCodeCategoryTerm(string2, (List<OntologyTerm>)ontTermsList)));
                return iO;
            }, Iterable$.MODULE$.canBuildFrom());
            IO codeCategoryIO = implicits$.MODULE$.toTraverseOps(codeCategoryTerms.toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), IO$.MODULE$.ioEffect());
            return codeCategoryIO.flatMap((Function1<List, IO> & Serializable & scala.Serializable)terms -> {
                Option<Object> lastScoreDocOption = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scoreDocs)).lastOption();
                Option searchResultsMetadataOption = lastScoreDocOption.map((Function1<ScoreDoc, SearchResultsMetadata> & Serializable & scala.Serializable)lastScoreDoc -> new SearchResultsMetadata(lastScoreDoc.doc, MODULE$.searcher().doc(lastScoreDoc.doc).get(sortTerm)));
                return IO$.MODULE$.apply((Function0<SearchResults> & Serializable & scala.Serializable)() -> new SearchResults(totalHits$1.value, searchResultsMetadataOption, (List<CodeCategoryTerm>)terms));
            });
        }));
    }

    public List<OntologyTerm> buildOntologyTerms(TrieNode node, String path) {
        Iterable ontTermResults = node.children().map((Function1<Tuple2, OntologyTerm> & Serializable & scala.Serializable)childItem -> {
            String childKey = (String)childItem._1();
            TrieNode child = (TrieNode)node.children().apply(childKey);
            String currentPath = new StringBuilder(1).append(path).append(childKey).append("\\").toString();
            Option<OntologyTerm> ontTermOption = child.ontTerm();
            List<OntologyTerm> childOntTerms = MODULE$.buildOntologyTerms(child, String.valueOf(currentPath));
            return ontTermOption.get().updateChildren(new Some<List<OntologyTerm>>(childOntTerms));
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        return ontTermResults.toList();
    }

    public String buildOntologyTerms$default$2() {
        return "";
    }

    public IO<Option<LabDetail>> getLabDetailsIO(OntologyPath ontologyPath) {
        ContextShift<IO> fileSystemContextShift = IO$.MODULE$.contextShift(ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return fileSystemContextShift.evalOn(ExecutionContexts$.MODULE$.fileSystemExecutionContext(), IO$.MODULE$.apply((Function0<Option> & Serializable & scala.Serializable)() -> {
            void var3_3;
            TermQuery nPathQuery = new TermQuery(new Term("path", ontologyPath.path()));
            TopDocs foundDocs = MODULE$.searcher().search((Query)nPathQuery, 1);
            Option res = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).headOption().flatMap((Function1<ScoreDoc, Option> & Serializable & scala.Serializable)scoreDoc -> MODULE$.extractLabDetail((ScoreDoc)scoreDoc));
            return var3_3;
        }));
    }

    private Option<LabDetail> extractLabDetail(ScoreDoc scoreDoc) {
        Option<IndexableField> labFieldOption = Option$.MODULE$.apply(this.searcher().doc(scoreDoc.doc).getField("labDetail"));
        public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1
        implements scala.Serializable {
            private ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> inst$macro$10;
            private DerivedDecoder<LabDetail> inst$macro$1;
            private volatile byte bitmap$0;

            private ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> inst$macro$10$lzycompute() {
                Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$10 = new ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>>(null){
                            private final Decoder<Option<Set<String>>> circeGenericDecoderForflagValues;
                            private final Decoder<Option<Seq<String>>> circeGenericDecoderForunits;
                            private final Decoder<Option<List<String>>> circeGenericDecoderForenumValues;
                            private volatile byte bitmap$init$0;

                            public final Either<DecodingFailure, $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> apply(HCursor c) {
                                return ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForflagValues.tryDecode(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForunits.tryDecode(c.downField("units")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForenumValues.tryDecode(c.downField("enumValues")), ReprDecoder$.MODULE$.hnilResult(), Decoder$.MODULE$.resultInstance()), Decoder$.MODULE$.resultInstance()), Decoder$.MODULE$.resultInstance());
                            }

                            public final Validated<NonEmptyList<DecodingFailure>, $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> decodeAccumulating(HCursor c) {
                                return ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForflagValues.tryDecodeAccumulating(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("units")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForenumValues.tryDecodeAccumulating(c.downField("enumValues")), ReprDecoder$.MODULE$.hnilResultAccumulating(), Decoder$.MODULE$.accumulatingResultInstance()), Decoder$.MODULE$.accumulatingResultInstance()), Decoder$.MODULE$.accumulatingResultInstance());
                            }
                            {
                                this.circeGenericDecoderForflagValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                this.circeGenericDecoderForunits = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                                this.circeGenericDecoderForenumValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$10;
            }

            public ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> inst$macro$10() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$10$lzycompute() : this.inst$macro$10;
            }

            private DerivedDecoder<LabDetail> inst$macro$1$lzycompute() {
                Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1
                        implements Generic<LabDetail> {
                            public $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> to(LabDetail p) {
                                LabDetail labDetail = p;
                                if (labDetail == null) {
                                    throw new MatchError(labDetail);
                                }
                                Option<Set<String>> pat$macro$6 = labDetail.flagValues();
                                Option<Seq<String>> pat$macro$7 = labDetail.units();
                                Option<List<String>> pat$macro$8 = labDetail.enumValues();
                                $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> $colon$colon = new $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>(pat$macro$6, new $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil$>>(pat$macro$7, new $colon$colon<Option<List<String>>, HNil$>(pat$macro$8, HNil$.MODULE$)));
                                return $colon$colon;
                            }

                            public LabDetail from($colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> p) {
                                Option<List<String>> pat$macro$8;
                                Option<Seq<String>> pat$macro$7;
                                Option<Set<String>> pat$macro$6;
                                block3: {
                                    $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> $colon$colon;
                                    block2: {
                                        $colon$colon = p;
                                        if ($colon$colon == null) break block2;
                                        pat$macro$6 = $colon$colon.head();
                                        $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>> $colon$colon2 = $colon$colon.tail();
                                        if ($colon$colon2 == null) break block2;
                                        pat$macro$7 = $colon$colon2.head();
                                        $colon$colon<Option<List<String>>, HNil> $colon$colon3 = $colon$colon2.tail();
                                        if ($colon$colon3 == null) break block2;
                                        pat$macro$8 = $colon$colon3.head();
                                        HNil hNil = $colon$colon3.tail();
                                        if (HNil$.MODULE$.equals(hNil)) break block3;
                                    }
                                    throw new MatchError($colon$colon);
                                }
                                LabDetail labDetail = new LabDetail(pat$macro$6, pat$macro$7, pat$macro$8);
                                return labDetail;
                            }

                            public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1(Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 $outer) {
                            }
                        }
                        this.inst$macro$1 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct(new DefaultSymbolicLabelling<LabDetail>(null){

                            public $colon$colon<Symbol, $colon$colon<Symbol, $colon$colon<Symbol, HNil>>> apply() {
                                return new $colon$colon<CallSite, $colon$colon<CallSite, $colon$colon<CallSite, HNil$>>>(SymbolLiteral.bootstrap("apply", "flagValues"), new $colon$colon<CallSite, $colon$colon<CallSite, HNil$>>(SymbolLiteral.bootstrap("apply", "units"), new $colon$colon<CallSite, HNil$>(SymbolLiteral.bootstrap("apply", "enumValues"), HNil$.MODULE$)));
                            }
                        }, new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1(null), hlist$ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist$ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist$ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist$ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness(SymbolLiteral.bootstrap("apply", "enumValues"))), Witness$.MODULE$.mkWitness(SymbolLiteral.bootstrap("apply", "units"))), Witness$.MODULE$.mkWitness(SymbolLiteral.bootstrap("apply", "flagValues"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0<ReprDecoder> & Serializable & scala.Serializable)() -> this.inst$macro$10()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$1;
            }

            public DerivedDecoder<LabDetail> inst$macro$1() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$1$lzycompute() : this.inst$macro$1;
            }

            public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(net.shrine.api.ontology.LuceneSearcher$anon$importedDecoder$macro$11$1 )}, serializedLambda);
            }
        }
        DerivedDecoder<LabDetail> inst$macro$12 = new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1().inst$macro$1();
        EntityDecoder labDetailDecoder = org.http4s.circe.package$.MODULE$.jsonOf(IO$.MODULE$.ioEffect(), Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply((Function0<DerivedDecoder> & Serializable & scala.Serializable)() -> inst$macro$12))));
        Option<LabDetail> ontTerm = labFieldOption.flatMap((Function1<IndexableField, Option> & Serializable & scala.Serializable)labField -> {
            Option option;
            DerivedDecoder<LabDetail> inst$macro$24;
            String labDetailJson = labField.stringValue();
            public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1
            implements scala.Serializable {
                private ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> inst$macro$22;
                private DerivedDecoder<LabDetail> inst$macro$13;
                private volatile byte bitmap$0;

                private ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> inst$macro$22$lzycompute() {
                    Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 1) == 0) {
                            this.inst$macro$22 = new ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>>(null){
                                private final Decoder<Option<Set<String>>> circeGenericDecoderForflagValues;
                                private final Decoder<Option<Seq<String>>> circeGenericDecoderForunits;
                                private final Decoder<Option<List<String>>> circeGenericDecoderForenumValues;
                                private volatile byte bitmap$init$0;

                                public final Either<DecodingFailure, $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> apply(HCursor c) {
                                    return ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForflagValues.tryDecode(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForunits.tryDecode(c.downField("units")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForenumValues.tryDecode(c.downField("enumValues")), ReprDecoder$.MODULE$.hnilResult(), Decoder$.MODULE$.resultInstance()), Decoder$.MODULE$.resultInstance()), Decoder$.MODULE$.resultInstance());
                                }

                                public final Validated<NonEmptyList<DecodingFailure>, $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> decodeAccumulating(HCursor c) {
                                    return ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForflagValues.tryDecodeAccumulating(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("units")), ReprDecoder$.MODULE$.consResults(this.circeGenericDecoderForenumValues.tryDecodeAccumulating(c.downField("enumValues")), ReprDecoder$.MODULE$.hnilResultAccumulating(), Decoder$.MODULE$.accumulatingResultInstance()), Decoder$.MODULE$.accumulatingResultInstance()), Decoder$.MODULE$.accumulatingResultInstance());
                                }
                                {
                                    this.circeGenericDecoderForflagValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                    this.circeGenericDecoderForunits = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                                    this.circeGenericDecoderForenumValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
                                }
                            };
                            this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                        }
                    }
                    return this.inst$macro$22;
                }

                public ReprDecoder<$colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>> inst$macro$22() {
                    return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$22$lzycompute() : this.inst$macro$22;
                }

                private DerivedDecoder<LabDetail> inst$macro$13$lzycompute() {
                    Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 2) == 0) {
                            public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1
                            implements Generic<LabDetail> {
                                public $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> to(LabDetail p) {
                                    LabDetail labDetail = p;
                                    if (labDetail == null) {
                                        throw new MatchError(labDetail);
                                    }
                                    Option<Set<String>> pat$macro$18 = labDetail.flagValues();
                                    Option<Seq<String>> pat$macro$19 = labDetail.units();
                                    Option<List<String>> pat$macro$20 = labDetail.enumValues();
                                    $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> $colon$colon = new $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>>(pat$macro$18, new $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil$>>(pat$macro$19, new $colon$colon<Option<List<String>>, HNil$>(pat$macro$20, HNil$.MODULE$)));
                                    return $colon$colon;
                                }

                                public LabDetail from($colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> p) {
                                    Option<List<String>> pat$macro$20;
                                    Option<Seq<String>> pat$macro$19;
                                    Option<Set<String>> pat$macro$18;
                                    block3: {
                                        $colon$colon<Option<Set<String>>, $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>>> $colon$colon;
                                        block2: {
                                            $colon$colon = p;
                                            if ($colon$colon == null) break block2;
                                            pat$macro$18 = $colon$colon.head();
                                            $colon$colon<Option<Seq<String>>, $colon$colon<Option<List<String>>, HNil>> $colon$colon2 = $colon$colon.tail();
                                            if ($colon$colon2 == null) break block2;
                                            pat$macro$19 = $colon$colon2.head();
                                            $colon$colon<Option<List<String>>, HNil> $colon$colon3 = $colon$colon2.tail();
                                            if ($colon$colon3 == null) break block2;
                                            pat$macro$20 = $colon$colon3.head();
                                            HNil hNil = $colon$colon3.tail();
                                            if (HNil$.MODULE$.equals(hNil)) break block3;
                                        }
                                        throw new MatchError($colon$colon);
                                    }
                                    LabDetail labDetail = new LabDetail(pat$macro$18, pat$macro$19, pat$macro$20);
                                    return labDetail;
                                }

                                public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1(Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 $outer) {
                                }
                            }
                            this.inst$macro$13 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct(new DefaultSymbolicLabelling<LabDetail>(null){

                                public $colon$colon<Symbol, $colon$colon<Symbol, $colon$colon<Symbol, HNil>>> apply() {
                                    return new $colon$colon<CallSite, $colon$colon<CallSite, $colon$colon<CallSite, HNil$>>>(SymbolLiteral.bootstrap("apply", "flagValues"), new $colon$colon<CallSite, $colon$colon<CallSite, HNil$>>(SymbolLiteral.bootstrap("apply", "units"), new $colon$colon<CallSite, HNil$>(SymbolLiteral.bootstrap("apply", "enumValues"), HNil$.MODULE$)));
                                }
                            }, new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1(null), hlist$ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist$ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist$ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist$ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness(SymbolLiteral.bootstrap("apply", "enumValues"))), Witness$.MODULE$.mkWitness(SymbolLiteral.bootstrap("apply", "units"))), Witness$.MODULE$.mkWitness(SymbolLiteral.bootstrap("apply", "flagValues"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0<ReprDecoder> & Serializable & scala.Serializable)() -> this.inst$macro$22()));
                            this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                        }
                    }
                    return this.inst$macro$13;
                }

                public DerivedDecoder<LabDetail> inst$macro$13() {
                    return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$13$lzycompute() : this.inst$macro$13;
                }

                public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1() {
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$13$1(net.shrine.api.ontology.LuceneSearcher$anon$importedDecoder$macro$23$1 )}, serializedLambda);
                }
            }
            Either either2 = package$.MODULE$.decode(labDetailJson, Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply(() -> LuceneSearcher$.$anonfun$extractLabDetail$3(inst$macro$24 = new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1().inst$macro$13())))));
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                LabDetail labDetail = (LabDetail)right.value();
                option = Option$.MODULE$.apply(labDetail);
            } else if (either2 instanceof Left) {
                option = None$.MODULE$;
            } else {
                throw new MatchError(either2);
            }
            return option;
        });
        return ontTerm;
    }

    private IO<TopFieldDocs> getRootFieldDocs() {
        ContextShift<IO> fileSystemContextShift = IO$.MODULE$.contextShift(ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return fileSystemContextShift.evalOn(ExecutionContexts$.MODULE$.fileSystemExecutionContext(), IO$.MODULE$.apply((Function0<TopFieldDocs> & Serializable & scala.Serializable)() -> {
            int maxHits = Integer.MAX_VALUE;
            QueryParser qp = new QueryParser("isRoot", new StandardAnalyzer());
            Query rootQuery = qp.parse("true");
            return MODULE$.searcher().search(rootQuery, maxHits, CaseInsensitiveSort$.MODULE$.apply("displayName"));
        }));
    }

    public static final /* synthetic */ boolean $anonfun$getFilterOptions$4(String x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$2(OntologyPath ontologyPath$1, ScoreDoc sd) {
        String string2 = MODULE$.searcher().doc(sd.doc).get("path");
        String string3 = ontologyPath$1.path();
        return string2 == null ? string3 != null : !string2.equals(string3);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$4(OntologyPath ontologyPath$1, ScoreDoc p) {
        String string2 = MODULE$.searcher().doc(p.doc).get("path");
        String string3 = ontologyPath$1.path();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$6(String x$4) {
        String string2 = x$4;
        String string3 = "";
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$7(String x$5) {
        String string2 = x$5;
        String string3 = "";
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractOntologyTermFromScoreDoc$2(IndexableField x$7) {
        return true;
    }

    private static final Query makeFilteredQuery$1(Query baseQuery, FilterData filter2) {
        Query query;
        FilterType filterType = filter2.filterType();
        if (filterType instanceof FilterableType) {
            FilterableType filterableType = (FilterableType)filterType;
            TermQuery filterQuery = new TermQuery(new Term(filterableType.value(), filter2.filterValue()));
            query = new BooleanQuery.Builder().add(baseQuery, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.MUST).build();
        } else if (filterType instanceof NO_FILTER) {
            query = baseQuery;
        } else {
            throw new MatchError(filterType);
        }
        return query;
    }

    public static final /* synthetic */ DerivedDecoder $anonfun$extractLabDetail$3(DerivedDecoder inst$macro$24$1) {
        return inst$macro$24$1;
    }

    private LuceneSearcher$() {
        MODULE$ = this;
        this.indexFileLocation = ConfigSource$.MODULE$.config().getString("shrine.lucene.directory");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.indexDir = new File(this.indexFileLocation());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.directory = FSDirectory.open(this.indexDir().toPath());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.searcher = new IndexSearcher(DirectoryReader.open(this.directory()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

