/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import ch.qos.logback.classic.Logger;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.CryptoErrors$;
import net.shrine.crypto.DownStreamCertCollection;
import net.shrine.crypto.HubCertCollection;
import net.shrine.crypto.ImproperlyConfiguredKeyStoreProblem;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreDescriptorParser$;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.crypto.KeyStoreType;
import net.shrine.crypto.PeerCertCollection;
import net.shrine.crypto.RemoteSiteDescriptor;
import net.shrine.log.Loggable;
import net.shrine.source.ConfigSource$;
import net.shrine.util.NonEmptySeq;
import net.shrine.util.PeerToPeerModel$;
import net.shrine.util.SingleHubModel;
import net.shrine.util.TrustModel;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BouncyKeyStoreCollection$
implements Loggable {
    public static BouncyKeyStoreCollection$ MODULE$;
    private BouncyKeyStoreCollection fromConfig;
    private final BouncyCastleProvider provider;
    private Option<KeyStoreDescriptor> descriptor;
    private Option<KeyStore> keyStore;
    private final String SHA256;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$0;
    private volatile byte bitmap$init$0;

    static {
        new BouncyKeyStoreCollection$();
    }

    @Override
    public Logger logger() {
        return Loggable.logger$(this);
    }

    @Override
    public final boolean debugEnabled() {
        return Loggable.debugEnabled$(this);
    }

    @Override
    public final boolean infoEnabled() {
        return Loggable.infoEnabled$(this);
    }

    @Override
    public void debug(Function0<String> s2) {
        Loggable.debug$(this, s2);
    }

    @Override
    public final void debug(Function0<String> s2, Throwable e) {
        Loggable.debug$(this, s2, e);
    }

    @Override
    public void info(Function0<String> s2) {
        Loggable.info$(this, s2);
    }

    @Override
    public final void info(Function0<String> s2, Throwable e) {
        Loggable.info$(this, s2, e);
    }

    @Override
    public void warn(Function0<String> s2) {
        Loggable.warn$(this, s2);
    }

    @Override
    public final void warn(Function0<String> s2, Throwable e) {
        Loggable.warn$(this, s2, e);
    }

    @Override
    public void error(Function0<String> s2) {
        Loggable.error$(this, s2);
    }

    @Override
    public final void error(Function0<String> s2, Throwable e) {
        Loggable.error$(this, s2, e);
    }

    @Override
    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$(this, taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        BouncyKeyStoreCollection$ bouncyKeyStoreCollection$ = this;
        synchronized (bouncyKeyStoreCollection$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    @Override
    public Logger net$shrine$log$Loggable$$internalLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    public BouncyCastleProvider provider() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/commons/crypto/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 49");
        }
        return this.provider;
    }

    public Option<KeyStoreDescriptor> descriptor() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/commons/crypto/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 51");
        }
        return this.descriptor;
    }

    public void descriptor_$eq(Option<KeyStoreDescriptor> x$1) {
        this.descriptor = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public Option<KeyStore> keyStore() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/commons/crypto/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 52");
        }
        return this.keyStore;
    }

    public void keyStore_$eq(Option<KeyStore> x$1) {
        this.keyStore = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public String SHA256() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT0-JOB1/commons/crypto/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 53");
        }
        return this.SHA256;
    }

    private BouncyKeyStoreCollection fromConfig$lzycompute() {
        BouncyKeyStoreCollection$ bouncyKeyStoreCollection$ = this;
        synchronized (bouncyKeyStoreCollection$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Config shrineConfig = ConfigSource$.MODULE$.config().getConfig("shrine");
                KeyStoreDescriptor keyStoreDescriptor = KeyStoreDescriptorParser$.MODULE$.apply(shrineConfig.getConfig("keystore"), net.shrine.config.package$.MODULE$.ConfigExtensions(shrineConfig).getConfigOrEmpty("hub"), net.shrine.config.package$.MODULE$.ConfigExtensions(shrineConfig).getConfigOrEmpty("queryEntryPoint"));
                this.fromConfig = this.fromFileRecoverWithClassPath(keyStoreDescriptor);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fromConfig;
    }

    public BouncyKeyStoreCollection fromConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.fromConfig$lzycompute() : this.fromConfig;
    }

    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createCertCollection(KeyStore keyStore, KeyStoreDescriptor descriptor) {
        Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> either2;
        this.descriptor_$eq(new Some<KeyStoreDescriptor>(descriptor));
        this.keyStore_$eq(new Some<KeyStore>(keyStore));
        Iterator values2 = JavaConverters$.MODULE$.enumerationAsScalaIterator(keyStore.aliases()).map((Function1<String, Tuple3> & Serializable & scala.Serializable)alias -> new Tuple3<String, Certificate, Option<PrivateKey>>((String)alias, keyStore.getCertificate((String)alias), Option$.MODULE$.apply((PrivateKey)keyStore.getKey((String)alias, descriptor.password().toCharArray()))));
        Set<KeyStoreEntry> entries = values2.map((Function1<Tuple3, KeyStoreEntry> & Serializable & scala.Serializable)value -> new KeyStoreEntry((X509Certificate)value._2(), new NonEmptySeq<Nothing$>((Nothing$)value._1(), Nil$.MODULE$), (Option)value._3())).toSet();
        Serializable serializable = entries.exists((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isExpired(x$1.isExpired$default$1()))) ? CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.ExpiredCertificates((Iterable)entries.filter((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isExpired(x$2.isExpired$default$1()))))) : BoxedUnit.UNIT;
        TrustModel trustModel = descriptor.trustModel();
        if (PeerToPeerModel$.MODULE$.equals(trustModel)) {
            either2 = this.createPeerCertCollection(entries, descriptor);
        } else if (trustModel instanceof SingleHubModel) {
            SingleHubModel singleHubModel = (SingleHubModel)trustModel;
            boolean isHub = singleHubModel.isCa();
            either2 = this.createCentralCertCollection(entries, descriptor, isHub);
        } else {
            throw new MatchError(trustModel);
        }
        return either2;
    }

    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createCentralCertCollection(Set<KeyStoreEntry> entries, KeyStoreDescriptor descriptor, boolean isHub) {
        Seq<RemoteSiteDescriptor> rsds = descriptor.remoteSiteDescriptors();
        Option hubEntryOption = entries.find((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createCentralCertCollection$1(descriptor, e)));
        return (Either)hubEntryOption.fold((Function0<Left> & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError("You must specify at least one ca cert alias corresponding to a PrivateKey entry for the Hub in a non PeerToPeer network")), (Function1<KeyStoreEntry, Either> & Serializable & scala.Serializable)hub -> {
            Option signingEntry = entries.find((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createCentralCertCollection$4(hub, e)));
            return (Either)signingEntry.fold((Function0<Left> & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError("There is no private entry signed by a public entry in the keystore corresponding to the Hub.")), (Function1<KeyStoreEntry, Either> & Serializable & scala.Serializable)signing -> {
                Right right;
                if (isHub) {
                    right = package$.MODULE$.Right().apply(new HubCertCollection((KeyStoreEntry)signing, (KeyStoreEntry)hub));
                } else {
                    RemoteSiteDescriptor rsd = (RemoteSiteDescriptor)rsds.head();
                    right = package$.MODULE$.Right().apply(new DownStreamCertCollection((KeyStoreEntry)signing, (KeyStoreEntry)hub));
                }
                return right;
            });
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createPeerCertCollection(Set<KeyStoreEntry> entries, KeyStoreDescriptor descriptor) {
        block5: {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            block4: {
                                configKeyStoreAliases = descriptor.remoteSiteDescriptors().map((Function1<RemoteSiteDescriptor, Option> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$1(net.shrine.crypto.RemoteSiteDescriptor ), (Lnet/shrine/crypto/RemoteSiteDescriptor;)Lscala/Option;)(), Seq$.MODULE$.canBuildFrom());
                                v0 = configKeyStoreAliases.toSet().flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$2(scala.Option ), (Lscala/Option;)Lscala/collection/Iterable;)());
                                var5_4 = entries.map((Function1<KeyStoreEntry, String> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$3(net.shrine.crypto.KeyStoreEntry ), (Lnet/shrine/crypto/KeyStoreEntry;)Ljava/lang/String;)(), Set$.MODULE$.canBuildFrom());
                                if (!(v0 == null ? var5_4 != null : v0.equals(var5_4) == false)) break block4;
                                v1 /* !! */  = package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.IncorrectAliasMapping((Iterable)configKeyStoreAliases.flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$4(scala.Option ), (Lscala/Option;)Lscala/collection/Iterable;)()), entries)));
                                break block5;
                            }
                            var6_5 = new Tuple2<Option<String>, Repr>(descriptor.privateKeyAlias(), entries.filter((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$5$adapted(net.shrine.crypto.KeyStoreEntry ), (Lnet/shrine/crypto/KeyStoreEntry;)Ljava/lang/Object;)()));
                            if (var6_5 == null || !(empty = (Set)var6_5._2()).isEmpty()) break block6;
                            var3_7 /* !! */  = package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError("Could not find a key in the KeyStore with a PrivateKey. Without one, SHRINE cannot sign messages."));
                            break block7;
                        }
                        if (var6_5 == null) break block8;
                        var8_8 = var6_5._1();
                        keys = (Set)var6_5._2();
                        if (!None$.MODULE$.equals(var8_8) || keys.size() != 1) break block8;
                        this.warn((Function0<String> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$createPeerCertCollection$6(scala.collection.immutable.Set ), ()Ljava/lang/String;)((Set)keys));
                        var3_7 /* !! */  = package$.MODULE$.Right().apply(new PeerCertCollection((KeyStoreEntry)keys.head(), (Set)entries.$minus$minus(keys)));
                        break block7;
                    }
                    if (var6_5 == null || !None$.MODULE$.equals(var10_10 = var6_5._1())) break block9;
                    var3_7 /* !! */  = package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.TooManyPrivateKeys(entries)));
                    break block7;
                }
                if (var6_5 == null) ** GOTO lbl-1000
                var11_11 = var6_5._1();
                keys = (Set)var6_5._2();
                if (var11_11 instanceof Some && keys.exists((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$7$adapted(java.lang.String net.shrine.crypto.KeyStoreEntry ), (Lnet/shrine/crypto/KeyStoreEntry;)Ljava/lang/Object;)((String)(alias = (String)(var13_13 = (Some)var11_11).value())))) {
                    privateKeyEntry = (KeyStoreEntry)keys.find((Function1<KeyStoreEntry, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createPeerCertCollection$8$adapted(java.lang.String net.shrine.crypto.KeyStoreEntry ), (Lnet/shrine/crypto/KeyStoreEntry;)Ljava/lang/Object;)((String)alias)).get();
                    var3_7 /* !! */  = package$.MODULE$.Right().apply(new PeerCertCollection(privateKeyEntry, (Set)entries.$minus(privateKeyEntry)));
                } else if (var6_5 != null && (var16_16 = var6_5._1()) instanceof Some) {
                    var17_17 = (Some)var16_16;
                    alias = (String)var17_17.value();
                    var3_7 /* !! */  = package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.CouldNotFindAlias(alias)));
                } else {
                    throw new MatchError(var6_5);
                }
            }
            v1 /* !! */  = var3_7 /* !! */ ;
        }
        return v1 /* !! */ ;
    }

    public BouncyKeyStoreCollection fromFileRecoverWithClassPath(KeyStoreDescriptor descriptor) {
        KeyStore keyStore = new File(descriptor.file()).exists() ? this.fromStreamHelper(descriptor, (Function1<String, InputStream>)(Function1<String, FileInputStream> & Serializable & scala.Serializable)x$8 -> new FileInputStream((String)x$8)) : this.fromStreamHelper(descriptor, (Function1<String, InputStream> & Serializable & scala.Serializable)x$9 -> MODULE$.getClass().getClassLoader().getResourceAsStream((String)x$9));
        this.keyStore_$eq(new Some<KeyStore>(keyStore));
        this.descriptor_$eq(new Some<KeyStoreDescriptor>(descriptor));
        return (BouncyKeyStoreCollection)this.createCertCollection(keyStore, descriptor).fold((Function1<ImproperlyConfiguredKeyStoreProblem, Nothing$> & Serializable & scala.Serializable)problem -> {
            throw problem.throwable().get();
        }, (Function1<BouncyKeyStoreCollection, BouncyKeyStoreCollection> & Serializable & scala.Serializable)x2 -> Predef$.MODULE$.identity(x2));
    }

    public KeyStore fromStreamHelper(KeyStoreDescriptor descriptor, Function1<String, InputStream> streamFrom) {
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Loading keystore using descriptor: ").append(BouncyKeyStoreCollection$.toString$1(descriptor)).toString());
        InputStream stream = streamFrom.apply(descriptor.file());
        Predef$.MODULE$.require(stream != null, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(28).append("null stream for descriptor ").append(BouncyKeyStoreCollection$.toString$1(descriptor)).append("\u00ac").toString());
        KeyStore keystore = KeyStore.getInstance(descriptor.keyStoreType().name());
        try {
            keystore.load(stream, descriptor.password().toCharArray());
        }
        catch (IOException x2) {
            throw new IOException(new StringBuilder(29).append("Unable to load keystore from ").append(descriptor).toString(), x2);
        }
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Keystore aliases: ").append(((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keystore.aliases()).asScala()).mkString(",")).toString());
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Keystore ").append(BouncyKeyStoreCollection$.toString$1(descriptor)).append(" loaded successfully").toString());
        return keystore;
    }

    public static final /* synthetic */ boolean $anonfun$createCentralCertCollection$1(KeyStoreDescriptor descriptor$2, KeyStoreEntry e) {
        return e.privateKey().isEmpty() && ((TraversableOnce)e.aliases().intersect(descriptor$2.caCertAliases())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$createCentralCertCollection$4(KeyStoreEntry hub$1, KeyStoreEntry e) {
        return e.privateKey().isDefined() && e.wasSignedBy(hub$1);
    }

    public static final /* synthetic */ Option $anonfun$createPeerCertCollection$1(RemoteSiteDescriptor x$3) {
        return x$3.keyStoreAlias();
    }

    public static final /* synthetic */ Iterable $anonfun$createPeerCertCollection$2(Option xo) {
        return Option$.MODULE$.option2Iterable(xo);
    }

    public static final /* synthetic */ String $anonfun$createPeerCertCollection$3(KeyStoreEntry x$4) {
        return x$4.aliases().first();
    }

    public static final /* synthetic */ Iterable $anonfun$createPeerCertCollection$4(Option xo) {
        return Option$.MODULE$.option2Iterable(xo);
    }

    public static final /* synthetic */ boolean $anonfun$createPeerCertCollection$5(KeyStoreEntry x$5) {
        return x$5.privateKey().isDefined();
    }

    public static final /* synthetic */ String $anonfun$createPeerCertCollection$6(Set keys$1) {
        return new StringBuilder(69).append("No private key specified, using the only entry with a private key: `").append((Object)((KeyStoreEntry)keys$1.head()).aliases().first()).append("`").toString();
    }

    public static final /* synthetic */ boolean $anonfun$createPeerCertCollection$7(String alias$1, KeyStoreEntry x$6) {
        return x$6.aliases().contains(alias$1);
    }

    public static final /* synthetic */ boolean $anonfun$createPeerCertCollection$8(String alias$1, KeyStoreEntry x$7) {
        return x$7.aliases().contains(alias$1);
    }

    private static final String toString$1(KeyStoreDescriptor descriptor) {
        String x$1 = "********";
        String x$2 = descriptor.copy$default$1();
        Option<String> x$3 = descriptor.copy$default$3();
        Seq<String> x$4 = descriptor.copy$default$4();
        TrustModel x$5 = descriptor.copy$default$5();
        Seq<RemoteSiteDescriptor> x$6 = descriptor.copy$default$6();
        KeyStoreType x$7 = descriptor.copy$default$7();
        return descriptor.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7).toString();
    }

    private BouncyKeyStoreCollection$() {
        MODULE$ = this;
        Loggable.$init$(this);
        this.provider = new BouncyCastleProvider();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        Security.addProvider(this.provider());
        this.descriptor = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.keyStore = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.SHA256 = "SHA256withRSA";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public static final /* synthetic */ Object $anonfun$createPeerCertCollection$5$adapted(KeyStoreEntry x$5) {
        return BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createPeerCertCollection$5(x$5));
    }

    public static final /* synthetic */ Object $anonfun$createPeerCertCollection$7$adapted(String alias$1, KeyStoreEntry x$6) {
        return BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createPeerCertCollection$7(alias$1, x$6));
    }

    public static final /* synthetic */ Object $anonfun$createPeerCertCollection$8$adapted(String alias$1, KeyStoreEntry x$7) {
        return BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createPeerCertCollection$8(alias$1, x$7));
    }
}

