/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.http4s.catsio;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import java.io.Serializable;
import net.shrine.log.Log$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

public final class RetryIO$ {
    public static RetryIO$ MODULE$;

    static {
        new RetryIO$();
    }

    public <A> IO<A> delayedExponentialBackoff(IO<A> task, FiniteDuration firstDelay, int maxRetries, Function1<Throwable, Object> retryIfTaskThrows, Timer<IO> timer) {
        return this.retry(task, firstDelay, new Some<Object>(BoxesRunTime.boxToInteger(maxRetries)), (Function1<Object, FiniteDuration> & Serializable & scala.Serializable)x$1 -> firstDelay.$times((int)Math.pow(2.0, BoxesRunTime.unboxToInt(x$1))), retryIfTaskThrows, timer);
    }

    public <A> IO<A> keepTrying(IO<A> task, FiniteDuration delay, Function1<Throwable, Object> retryIfTaskThrows, Timer<IO> timer) {
        return this.retry(task, new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds(), None$.MODULE$, (Function1<Object, FiniteDuration> & Serializable & scala.Serializable)x$2 -> delay, retryIfTaskThrows, timer);
    }

    public <A> IO<A> keepTryingBounded(IO<A> task, FiniteDuration delay, int maxRetries, Function1<Throwable, Object> retryIfTaskThrows, Timer<IO> timer) {
        IO<A> x$1 = task;
        FiniteDuration x$2 = this.retry$default$2(x$1);
        Some<Object> x$32 = new Some<Object>(BoxesRunTime.boxToInteger(maxRetries));
        Function1<Object, FiniteDuration> & Serializable & scala.Serializable x$4 = (Function1<Object, FiniteDuration> & Serializable & scala.Serializable)x$3 -> delay;
        Function1<Throwable, Object> x$5 = retryIfTaskThrows;
        Timer<IO> x$6 = timer;
        return this.retry(x$1, x$2, x$32, x$4, x$5, x$6);
    }

    public <A> IO<A> retry(IO<A> task, FiniteDuration delay, Option<Object> maxRetries, Function1<Object, FiniteDuration> backoff, Function1<Throwable, Object> retryIfTaskThrows, Timer<IO> timer) {
        IntRef tried = IntRef.create(0);
        return RetryIO$.build$1(delay, timer, maxRetries, tried, task, retryIfTaskThrows, backoff);
    }

    public <A> FiniteDuration retry$default$2(IO<A> task) {
        return new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds();
    }

    public <A> Option<Object> retry$default$3(IO<A> task, FiniteDuration delay) {
        return None$.MODULE$;
    }

    public <A> Function1<Object, FiniteDuration> retry$default$4(IO<A> task, FiniteDuration delay, Option<Object> maxRetries) {
        return (Function1<Object, FiniteDuration> & Serializable & scala.Serializable)x$4 -> delay;
    }

    public <A> Function1<Throwable, Object> retry$default$5(IO<A> task, FiniteDuration delay, Option<Object> maxRetries, Function1<Object, FiniteDuration> backoff) {
        return (Function1<Throwable, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(RetryIO$.$anonfun$retry$default$5$1(x$5));
    }

    private static final void increment$1(IntRef tried$1) {
        ++tried$1.elem;
    }

    public static final /* synthetic */ String $anonfun$retry$8(int x$9) {
        return ((Object)BoxesRunTime.boxToInteger(x$9)).toString();
    }

    private static final IO build$1(FiniteDuration nextDelay, Timer timer$1, Option maxRetries$1, IntRef tried$1, IO task$1, Function1 retryIfTaskThrows$1, Function1 backoff$1) {
        return IO$.MODULE$.cancelBoundary().flatMap((Function1<BoxedUnit, IO> & Serializable & scala.Serializable)x$6 -> IO$.MODULE$.sleep(nextDelay, timer$1)).flatMap((Function1<BoxedUnit, IO> & Serializable & scala.Serializable)x$7 -> {
            IO iO;
            if (BoxesRunTime.unboxToBoolean(maxRetries$1.fold((JFunction0$mcZ$sp & scala.Serializable)() -> true, (JFunction1$mcZI$sp & scala.Serializable)x$8 -> tried$1.elem < x$8))) {
                iO = task$1.handleErrorWith((Function1<Throwable, IO> & Serializable & scala.Serializable)x0$1 -> {
                    IO iO;
                    Throwable throwable = x0$1;
                    if (BoxesRunTime.unboxToBoolean(retryIfTaskThrows$1.apply(throwable))) {
                        Log$.MODULE$.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Caught ").append(throwable.getClass().getSimpleName()).append(". Will make ").append(tried$1.elem + 1).append(" of ").append(maxRetries$1.fold((Function0<String> & Serializable & scala.Serializable)() -> "unlimited", (Function1<Object, String> & Serializable & scala.Serializable)x$9 -> RetryIO$.$anonfun$retry$8(BoxesRunTime.unboxToInt(x$9)))).append(" attempts of ").append(task$1).append(" after ").append(nextDelay).toString(), throwable);
                        iO = RetryIO$.continue$1(backoff$1, tried$1, timer$1, maxRetries$1, task$1, retryIfTaskThrows$1);
                    } else {
                        Log$.MODULE$.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Caught ").append(throwable.getClass().getSimpleName()).append(". Will not attempt ").append(task$1).append(" again.").toString(), throwable);
                        iO = IO$.MODULE$.raiseError(throwable);
                    }
                    return iO;
                });
            } else {
                Log$.MODULE$.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Last attempt of ").append(task$1).toString());
                iO = task$1.handleErrorWith((Function1<Throwable, IO> & Serializable & scala.Serializable)x2 -> {
                    Log$.MODULE$.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Caught during last attempt of ").append(task$1).toString(), (Throwable)x2);
                    return IO$.MODULE$.raiseError((Throwable)x2);
                });
            }
            return iO;
        });
    }

    private static final IO continue$1(Function1 backoff$1, IntRef tried$1, Timer timer$1, Option maxRetries$1, IO task$1, Function1 retryIfTaskThrows$1) {
        RetryIO$.increment$1(tried$1);
        return RetryIO$.build$1((FiniteDuration)backoff$1.apply(BoxesRunTime.boxToInteger(tried$1.elem)), timer$1, maxRetries$1, tried$1, task$1, retryIfTaskThrows$1, backoff$1);
    }

    public static final /* synthetic */ boolean $anonfun$retry$default$5$1(Throwable x$5) {
        return false;
    }

    private RetryIO$() {
        MODULE$ = this;
    }
}

