/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

public class Rectangle2D {
    protected final byte[] bbox = new byte[16];
    private final byte[] west;
    protected final int minX;
    protected final int maxX;
    protected final int minY;
    protected final int maxY;

    protected Rectangle2D(double minLat, double maxLat, double minLon, double maxLon) {
        int minXenc = GeoEncodingUtils.encodeLongitudeCeil(minLon);
        int maxXenc = GeoEncodingUtils.encodeLongitude(maxLon);
        int minYenc = GeoEncodingUtils.encodeLatitudeCeil(minLat);
        int maxYenc = GeoEncodingUtils.encodeLatitude(maxLat);
        if (minYenc > maxYenc) {
            minYenc = maxYenc;
        }
        this.minY = minYenc;
        this.maxY = maxYenc;
        if (minLon > maxLon) {
            this.west = new byte[16];
            this.minX = minXenc;
            this.maxX = maxXenc;
            Rectangle2D.encode(GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY, this.west);
            Rectangle2D.encode(this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY, this.bbox);
        } else {
            if (minXenc > maxXenc) {
                minXenc = maxXenc;
            }
            this.west = null;
            this.minX = minXenc;
            this.maxX = maxXenc;
            Rectangle2D.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
        }
    }

    protected Rectangle2D(int minX, int maxX, int minY, int maxY) {
        this.west = null;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        Rectangle2D.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
    }

    public static Rectangle2D create(Rectangle rectangle) {
        return new Rectangle2D(rectangle.minLat, rectangle.maxLat, rectangle.minLon, rectangle.maxLon);
    }

    public boolean crossesDateline() {
        return this.minX > this.maxX;
    }

    public boolean queryContainsPoint(int x2, int y) {
        if (this.crossesDateline()) {
            return Rectangle2D.bboxContainsPoint(x2, y, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || Rectangle2D.bboxContainsPoint(x2, y, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return Rectangle2D.bboxContainsPoint(x2, y, this.minX, this.maxX, this.minY, this.maxY);
    }

    public PointValues.Relation relateRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        PointValues.Relation eastRelation = Rectangle2D.compareBBoxToRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return Rectangle2D.compareBBoxToRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return eastRelation;
    }

    public boolean intersectsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
        if (this.queryContainsPoint(aX, aY) || this.queryContainsPoint(bX, bY) || this.queryContainsPoint(cX, cY)) {
            return true;
        }
        int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
        int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        if (this.crossesDateline() ? Rectangle2D.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) && Rectangle2D.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY) : tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return false;
        }
        if (Tessellator.pointInTriangle(this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.minX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        return this.queryIntersects(aX, aY, bX, bY, cX, cY);
    }

    public boolean containsTriangle(int ax, int ay, int bx, int by, int cx, int cy) {
        if (this.crossesDateline()) {
            return Rectangle2D.bboxContainsTriangle(ax, ay, bx, by, cx, cy, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || Rectangle2D.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return Rectangle2D.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, this.maxX, this.minY, this.maxY);
    }

    private static PointValues.Relation compareBBoxToRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 12, 16) > 0 || Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 4, 8) < 0 || Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 8, 12) > 0 || Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 0, 4) < 0) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0 && Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static void encode(int minX, int maxX, int minY, int maxY, byte[] b) {
        if (b == null) {
            b = new byte[16];
        }
        NumericUtils.intToSortableBytes(minY, b, 0);
        NumericUtils.intToSortableBytes(minX, b, 4);
        NumericUtils.intToSortableBytes(maxY, b, 8);
        NumericUtils.intToSortableBytes(maxX, b, 12);
    }

    private boolean queryIntersects(int ax, int ay, int bx, int by, int cx, int cy) {
        return this.edgeIntersectsQuery(ax, ay, bx, by) || this.edgeIntersectsQuery(bx, by, cx, cy) || this.edgeIntersectsQuery(cx, cy, ax, ay);
    }

    private boolean edgeIntersectsQuery(int ax, int ay, int bx, int by) {
        if (this.crossesDateline()) {
            return Rectangle2D.edgeIntersectsBox(ax, ay, bx, by, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || Rectangle2D.edgeIntersectsBox(ax, ay, bx, by, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return Rectangle2D.edgeIntersectsBox(ax, ay, bx, by, this.minX, this.maxX, this.minY, this.maxY);
    }

    private static boolean bboxContainsPoint(int x2, int y, int minX, int maxX, int minY, int maxY) {
        return !(x2 < minX || x2 > maxX || y < minY || y > maxY);
    }

    private static boolean bboxContainsTriangle(int ax, int ay, int bx, int by, int cx, int cy, int minX, int maxX, int minY, int maxY) {
        return Rectangle2D.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) && Rectangle2D.bboxContainsPoint(bx, by, minX, maxX, minY, maxY) && Rectangle2D.bboxContainsPoint(cx, cy, minX, maxX, minY, maxY);
    }

    private static boolean edgeIntersectsBox(int ax, int ay, int bx, int by, int minX, int maxX, int minY, int maxY) {
        if (ax == bx && ay == by) {
            return Rectangle.containsPoint(ay, ax, minY, maxY, minX, maxX);
        }
        if (Rectangle2D.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) || Rectangle2D.bboxContainsPoint(bx, by, minX, maxX, minY, maxY)) {
            return true;
        }
        if (Rectangle2D.boxesAreDisjoint(Math.min(ax, bx), Math.max(ax, bx), Math.min(ay, by), Math.max(ay, by), minX, maxX, minY, maxY)) {
            return false;
        }
        if (GeoUtils.orient(ax, ay, bx, by, minX, maxY) * GeoUtils.orient(ax, ay, bx, by, maxX, maxY) <= 0 && GeoUtils.orient(minX, maxY, maxX, maxY, ax, ay) * GeoUtils.orient(minX, maxY, maxX, maxY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, maxX, maxY) * GeoUtils.orient(ax, ay, bx, by, maxX, minY) <= 0 && GeoUtils.orient(maxX, maxY, maxX, minY, ax, ay) * GeoUtils.orient(maxX, maxY, maxX, minY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, maxX, minY) * GeoUtils.orient(ax, ay, bx, by, minX, minY) <= 0 && GeoUtils.orient(maxX, minY, minX, minY, ax, ay) * GeoUtils.orient(maxX, minY, minX, minY, bx, by) <= 0) {
            return true;
        }
        return GeoUtils.orient(ax, ay, bx, by, minX, minY) * GeoUtils.orient(ax, ay, bx, by, minX, maxY) <= 0 && GeoUtils.orient(minX, minY, minX, maxY, ax, ay) * GeoUtils.orient(minX, minY, minX, maxY, bx, by) <= 0;
    }

    private static boolean boxesAreDisjoint(int aMinX, int aMaxX, int aMinY, int aMaxY, int bMinX, int bMaxX, int bMinY, int bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D that = (Rectangle2D)o;
        return this.minX == that.minX && this.maxX == that.maxX && this.minY == that.minY && this.maxY == that.maxY && Arrays.equals(this.bbox, that.bbox) && Arrays.equals(this.west, that.west);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.minX, this.maxX, this.minY, this.maxY);
        result2 = 31 * result2 + Arrays.hashCode(this.bbox);
        result2 = 31 * result2 + Arrays.hashCode(this.west);
        return result2;
    }
}

