/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.MergedIterator;

public final class MultiFields
extends Fields {
    private final Fields[] subs;
    private final ReaderSlice[] subSlices;
    private final Map<String, Terms> terms = new ConcurrentHashMap<String, Terms>();

    public MultiFields(Fields[] subs, ReaderSlice[] subSlices) {
        this.subs = subs;
        this.subSlices = subSlices;
    }

    @Override
    public Iterator<String> iterator() {
        Iterator[] subIterators = new Iterator[this.subs.length];
        for (int i = 0; i < this.subs.length; ++i) {
            subIterators[i] = this.subs[i].iterator();
        }
        return new MergedIterator<String>(subIterators);
    }

    @Override
    public Terms terms(String field2) throws IOException {
        Terms result2 = this.terms.get(field2);
        if (result2 != null) {
            return result2;
        }
        ArrayList<Terms> subs2 = new ArrayList<Terms>();
        ArrayList<ReaderSlice> slices2 = new ArrayList<ReaderSlice>();
        for (int i = 0; i < this.subs.length; ++i) {
            Terms terms = this.subs[i].terms(field2);
            if (terms == null) continue;
            subs2.add(terms);
            slices2.add(this.subSlices[i]);
        }
        if (subs2.size() == 0) {
            result2 = null;
        } else {
            result2 = new MultiTerms(subs2.toArray(Terms.EMPTY_ARRAY), slices2.toArray(ReaderSlice.EMPTY_ARRAY));
            this.terms.put(field2, result2);
        }
        return result2;
    }

    @Override
    public int size() {
        return -1;
    }
}

