/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.RamUsageEstimator;

public class DocValuesTermsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(DocValuesTermsQuery.class);
    private final String field;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    public DocValuesTermsQuery(String field2, Collection<BytesRef> terms) {
        this.field = Objects.requireNonNull(field2);
        Objects.requireNonNull(terms, "Collection of terms must not be null");
        Comparable[] sortedTerms = terms.toArray(new BytesRef[terms.size()]);
        ArrayUtil.timSort((Comparable[])sortedTerms);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        Comparable previous = null;
        for (Comparable term : sortedTerms) {
            if (!((BytesRef)term).equals(previous)) {
                builder.add(field2, (BytesRef)term);
            }
            previous = term;
        }
        this.termData = builder.finish();
        this.termDataHashCode = this.termData.hashCode();
    }

    public DocValuesTermsQuery(String field2, BytesRef ... terms) {
        this(field2, Arrays.asList(terms));
    }

    public DocValuesTermsQuery(String field2, final String ... terms) {
        this(field2, (Collection<BytesRef>)new AbstractList<BytesRef>(){

            @Override
            public BytesRef get(int index) {
                return new BytesRef(terms[index]);
            }

            @Override
            public int size() {
                return terms.length;
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DocValuesTermsQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DocValuesTermsQuery other) {
        return this.termDataHashCode == other.termDataHashCode && this.termData.equals(other.termData);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.termDataHashCode;
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(new Term(iterator.field(), term).toString());
            term = iterator.next();
        }
        return builder.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.termData);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedSetDocValues values2 = DocValues.getSortedSet(context.reader(), DocValuesTermsQuery.this.field);
                final LongBitSet bits = new LongBitSet(values2.getValueCount());
                boolean matchesAtLeastOneTerm = false;
                PrefixCodedTerms.TermIterator iterator = DocValuesTermsQuery.this.termData.iterator();
                BytesRef term = iterator.next();
                while (term != null) {
                    long ord = values2.lookupTerm(term);
                    if (ord >= 0L) {
                        matchesAtLeastOneTerm = true;
                        bits.set(ord);
                    }
                    term = iterator.next();
                }
                if (!matchesAtLeastOneTerm) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, new TwoPhaseIterator(values2){

                    @Override
                    public boolean matches() throws IOException {
                        long ord = values2.nextOrd();
                        while (ord != -1L) {
                            if (bits.get(ord)) {
                                return true;
                            }
                            ord = values2.nextOrd();
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 3.0f;
                    }
                });
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, DocValuesTermsQuery.this.field);
            }
        };
    }
}

