/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenGroup;
import org.apache.lucene.util.PriorityQueue;

public class Highlighter {
    public static final int DEFAULT_MAX_CHARS_TO_ANALYZE = 51200;
    private Formatter formatter;
    private Encoder encoder;
    private Scorer fragmentScorer;
    private int maxDocCharsToAnalyze = 51200;
    private Fragmenter textFragmenter = new SimpleFragmenter();

    public Highlighter(Scorer fragmentScorer) {
        this(new SimpleHTMLFormatter(), fragmentScorer);
    }

    public Highlighter(Formatter formatter, Scorer fragmentScorer) {
        this(formatter, new DefaultEncoder(), fragmentScorer);
    }

    public Highlighter(Formatter formatter, Encoder encoder, Scorer fragmentScorer) {
        Highlighter.ensureArgumentNotNull(formatter, "'formatter' must not be null");
        Highlighter.ensureArgumentNotNull(encoder, "'encoder' must not be null");
        Highlighter.ensureArgumentNotNull(fragmentScorer, "'fragmentScorer' must not be null");
        this.formatter = formatter;
        this.encoder = encoder;
        this.fragmentScorer = fragmentScorer;
    }

    public final String getBestFragment(Analyzer analyzer, String fieldName, String text2) throws IOException, InvalidTokenOffsetsException {
        TokenStream tokenStream = analyzer.tokenStream(fieldName, text2);
        return this.getBestFragment(tokenStream, text2);
    }

    public final String getBestFragment(TokenStream tokenStream, String text2) throws IOException, InvalidTokenOffsetsException {
        String[] results = this.getBestFragments(tokenStream, text2, 1);
        if (results.length > 0) {
            return results[0];
        }
        return null;
    }

    public final String[] getBestFragments(Analyzer analyzer, String fieldName, String text2, int maxNumFragments) throws IOException, InvalidTokenOffsetsException {
        TokenStream tokenStream = analyzer.tokenStream(fieldName, text2);
        return this.getBestFragments(tokenStream, text2, maxNumFragments);
    }

    public final String[] getBestFragments(TokenStream tokenStream, String text2, int maxNumFragments) throws IOException, InvalidTokenOffsetsException {
        maxNumFragments = Math.max(1, maxNumFragments);
        TextFragment[] frag = this.getBestTextFragments(tokenStream, text2, true, maxNumFragments);
        ArrayList<String> fragTexts = new ArrayList<String>();
        for (int i = 0; i < frag.length; ++i) {
            if (frag[i] == null || !(frag[i].getScore() > 0.0f)) continue;
            fragTexts.add(frag[i].toString());
        }
        return fragTexts.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextFragment[] getBestTextFragments(TokenStream tokenStream, String text2, boolean mergeContiguousFragments, int maxNumFragments) throws IOException, InvalidTokenOffsetsException {
        TokenStream newStream;
        ArrayList<TextFragment> docFrags = new ArrayList<TextFragment>();
        StringBuilder newText = new StringBuilder();
        CharTermAttribute termAtt = tokenStream.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = tokenStream.addAttribute(OffsetAttribute.class);
        TextFragment currentFrag2 = new TextFragment(newText, newText.length(), docFrags.size());
        if (this.fragmentScorer instanceof QueryScorer) {
            ((QueryScorer)this.fragmentScorer).setMaxDocCharsToAnalyze(this.maxDocCharsToAnalyze);
        }
        if ((newStream = this.fragmentScorer.init(tokenStream)) != null) {
            tokenStream = newStream;
        }
        this.fragmentScorer.startFragment(currentFrag2);
        docFrags.add(currentFrag2);
        FragmentQueue fragQueue = new FragmentQueue(maxNumFragments);
        try {
            String tokenText;
            int endOffset;
            int startOffset;
            int lastEndOffset = 0;
            this.textFragmenter.start(text2, tokenStream);
            TokenGroup tokenGroup = new TokenGroup(tokenStream);
            tokenStream.reset();
            boolean next = tokenStream.incrementToken();
            while (next && offsetAtt.startOffset() < this.maxDocCharsToAnalyze) {
                if (offsetAtt.endOffset() > text2.length() || offsetAtt.startOffset() > text2.length()) {
                    throw new InvalidTokenOffsetsException("Token " + termAtt.toString() + " exceeds length of provided text sized " + text2.length());
                }
                if (tokenGroup.getNumTokens() > 0 && tokenGroup.isDistinct()) {
                    startOffset = tokenGroup.getStartOffset();
                    endOffset = tokenGroup.getEndOffset();
                    tokenText = text2.substring(startOffset, endOffset);
                    String markedUpText = this.formatter.highlightTerm(this.encoder.encodeText(tokenText), tokenGroup);
                    if (startOffset > lastEndOffset) {
                        newText.append(this.encoder.encodeText(text2.substring(lastEndOffset, startOffset)));
                    }
                    newText.append(markedUpText);
                    lastEndOffset = Math.max(endOffset, lastEndOffset);
                    tokenGroup.clear();
                    if (this.textFragmenter.isNewFragment()) {
                        currentFrag2.setScore(this.fragmentScorer.getFragmentScore());
                        currentFrag2.textEndPos = newText.length();
                        currentFrag2 = new TextFragment(newText, newText.length(), docFrags.size());
                        this.fragmentScorer.startFragment(currentFrag2);
                        docFrags.add(currentFrag2);
                    }
                }
                tokenGroup.addToken(this.fragmentScorer.getTokenScore());
                next = tokenStream.incrementToken();
            }
            currentFrag2.setScore(this.fragmentScorer.getFragmentScore());
            if (tokenGroup.getNumTokens() > 0) {
                startOffset = tokenGroup.getStartOffset();
                endOffset = tokenGroup.getEndOffset();
                tokenText = text2.substring(startOffset, endOffset);
                String markedUpText = this.formatter.highlightTerm(this.encoder.encodeText(tokenText), tokenGroup);
                if (startOffset > lastEndOffset) {
                    newText.append(this.encoder.encodeText(text2.substring(lastEndOffset, startOffset)));
                }
                newText.append(markedUpText);
                lastEndOffset = Math.max(lastEndOffset, endOffset);
            }
            if (lastEndOffset < text2.length() && text2.length() <= this.maxDocCharsToAnalyze) {
                newText.append(this.encoder.encodeText(text2.substring(lastEndOffset)));
            }
            currentFrag2.textEndPos = newText.length();
            for (TextFragment currentFrag2 : docFrags) {
                fragQueue.insertWithOverflow(currentFrag2);
            }
            TextFragment[] frag = new TextFragment[fragQueue.size()];
            for (int i = frag.length - 1; i >= 0; --i) {
                frag[i] = (TextFragment)fragQueue.pop();
            }
            if (mergeContiguousFragments) {
                this.mergeContiguousFragments(frag);
                ArrayList<TextFragment> fragTexts = new ArrayList<TextFragment>();
                for (int i = 0; i < frag.length; ++i) {
                    if (frag[i] == null || !(frag[i].getScore() > 0.0f)) continue;
                    fragTexts.add(frag[i]);
                }
                frag = fragTexts.toArray(new TextFragment[0]);
            }
            TextFragment[] textFragmentArray = frag;
            return textFragmentArray;
        }
        finally {
            if (tokenStream != null) {
                try {
                    tokenStream.end();
                    tokenStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void mergeContiguousFragments(TextFragment[] frag) {
        if (frag.length > 1) {
            boolean mergingStillBeingDone;
            do {
                mergingStillBeingDone = false;
                block1: for (int i = 0; i < frag.length; ++i) {
                    if (frag[i] == null) continue;
                    for (int x2 = 0; x2 < frag.length; ++x2) {
                        int worstScoringFragNum;
                        int bestScoringFragNum;
                        if (frag[x2] == null) continue;
                        if (frag[i] == null) continue block1;
                        TextFragment frag1 = null;
                        TextFragment frag2 = null;
                        int frag1Num = 0;
                        int frag2Num = 0;
                        if (frag[i].follows(frag[x2])) {
                            frag1 = frag[x2];
                            frag1Num = x2;
                            frag2 = frag[i];
                            frag2Num = i;
                        } else if (frag[x2].follows(frag[i])) {
                            frag1 = frag[i];
                            frag1Num = i;
                            frag2 = frag[x2];
                            frag2Num = x2;
                        }
                        if (frag1 == null) continue;
                        if (frag1.getScore() > frag2.getScore()) {
                            bestScoringFragNum = frag1Num;
                            worstScoringFragNum = frag2Num;
                        } else {
                            bestScoringFragNum = frag2Num;
                            worstScoringFragNum = frag1Num;
                        }
                        frag1.merge(frag2);
                        frag[worstScoringFragNum] = null;
                        mergingStillBeingDone = true;
                        frag[bestScoringFragNum] = frag1;
                    }
                }
            } while (mergingStillBeingDone);
        }
    }

    public final String getBestFragments(TokenStream tokenStream, String text2, int maxNumFragments, String separator) throws IOException, InvalidTokenOffsetsException {
        String[] sections = this.getBestFragments(tokenStream, text2, maxNumFragments);
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < sections.length; ++i) {
            if (i > 0) {
                result2.append(separator);
            }
            result2.append(sections[i]);
        }
        return result2.toString();
    }

    public int getMaxDocCharsToAnalyze() {
        return this.maxDocCharsToAnalyze;
    }

    public void setMaxDocCharsToAnalyze(int maxDocCharsToAnalyze) {
        this.maxDocCharsToAnalyze = maxDocCharsToAnalyze;
    }

    public Fragmenter getTextFragmenter() {
        return this.textFragmenter;
    }

    public void setTextFragmenter(Fragmenter fragmenter) {
        this.textFragmenter = Objects.requireNonNull(fragmenter);
    }

    public Scorer getFragmentScorer() {
        return this.fragmentScorer;
    }

    public void setFragmentScorer(Scorer scorer) {
        this.fragmentScorer = Objects.requireNonNull(scorer);
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = Objects.requireNonNull(encoder);
    }

    private static void ensureArgumentNotNull(Object argument, String message) {
        if (argument == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static class FragmentQueue
    extends PriorityQueue<TextFragment> {
        FragmentQueue(int size) {
            super(size);
        }

        @Override
        public final boolean lessThan(TextFragment fragA, TextFragment fragB) {
            if (fragA.getScore() == fragB.getScore()) {
                return fragA.fragNum > fragB.fragNum;
            }
            return fragA.getScore() < fragB.getScore();
        }
    }
}

