/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.highlight.LimitTokenOffsetFilter;
import org.apache.lucene.search.highlight.TokenStreamFromTermVector;

public class TokenSources {
    private TokenSources() {
    }

    public static TokenStream getTokenStream(String field2, Fields tvFields, String text2, Analyzer analyzer, int maxStartOffset) throws IOException {
        TokenStream tokenStream = TokenSources.getTermVectorTokenStreamOrNull(field2, tvFields, maxStartOffset);
        if (tokenStream != null) {
            return tokenStream;
        }
        tokenStream = analyzer.tokenStream(field2, text2);
        if (maxStartOffset >= 0 && maxStartOffset < text2.length() - 1) {
            tokenStream = new LimitTokenOffsetFilter(tokenStream, maxStartOffset);
        }
        return tokenStream;
    }

    public static TokenStream getTermVectorTokenStreamOrNull(String field2, Fields tvFields, int maxStartOffset) throws IOException {
        if (tvFields == null) {
            return null;
        }
        Terms tvTerms = tvFields.terms(field2);
        if (tvTerms == null || !tvTerms.hasOffsets()) {
            return null;
        }
        return new TokenStreamFromTermVector(tvTerms, maxStartOffset);
    }

    @Deprecated
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field2, Document document, Analyzer analyzer) throws IOException {
        Terms vector;
        TokenStream ts = null;
        Fields vectors = reader.getTermVectors(docId);
        if (vectors != null && (vector = vectors.terms(field2)) != null) {
            ts = TokenSources.getTokenStream(vector);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(document, field2, analyzer);
        }
        return ts;
    }

    @Deprecated
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field2, Analyzer analyzer) throws IOException {
        Terms vector;
        TokenStream ts = null;
        Fields vectors = reader.getTermVectors(docId);
        if (vectors != null && (vector = vectors.terms(field2)) != null) {
            ts = TokenSources.getTokenStream(vector);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(reader, docId, field2, analyzer);
        }
        return ts;
    }

    @Deprecated
    public static TokenStream getTokenStream(Terms vector, boolean tokenPositionsGuaranteedContiguous) throws IOException {
        return TokenSources.getTokenStream(vector);
    }

    @Deprecated
    public static TokenStream getTokenStream(Terms tpv) throws IOException {
        if (!tpv.hasOffsets()) {
            throw new IllegalArgumentException("Highlighting requires offsets from the TokenStream.");
        }
        return new TokenStreamFromTermVector(tpv, -1);
    }

    @Deprecated
    public static TokenStream getTokenStreamWithOffsets(IndexReader reader, int docId, String field2) throws IOException {
        Fields vectors = reader.getTermVectors(docId);
        if (vectors == null) {
            return null;
        }
        Terms vector = vectors.terms(field2);
        if (vector == null) {
            return null;
        }
        if (!vector.hasOffsets()) {
            return null;
        }
        return TokenSources.getTokenStream(vector);
    }

    @Deprecated
    public static TokenStream getTokenStream(IndexReader reader, int docId, String field2, Analyzer analyzer) throws IOException {
        Document doc = reader.document(docId);
        return TokenSources.getTokenStream(doc, field2, analyzer);
    }

    @Deprecated
    public static TokenStream getTokenStream(Document doc, String field2, Analyzer analyzer) {
        String contents = doc.get(field2);
        if (contents == null) {
            throw new IllegalArgumentException("Field " + field2 + " in document is not stored and cannot be analyzed");
        }
        return TokenSources.getTokenStream(field2, contents, analyzer);
    }

    @Deprecated
    public static TokenStream getTokenStream(String field2, String contents, Analyzer analyzer) {
        return analyzer.tokenStream(field2, contents);
    }
}

