/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.suggest.document.CompletionWeight;
import org.apache.lucene.search.suggest.document.NRTSuggester;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.automaton.Automaton;

public class CompletionScorer
extends BulkScorer {
    private final NRTSuggester suggester;
    private final Bits filterDocs;
    protected final CompletionWeight weight;
    final LeafReader reader;
    final boolean filtered;
    final Automaton automaton;

    protected CompletionScorer(CompletionWeight weight, NRTSuggester suggester, LeafReader reader, Bits filterDocs, boolean filtered, Automaton automaton) throws IOException {
        this.weight = weight;
        this.suggester = suggester;
        this.reader = reader;
        this.automaton = automaton;
        this.filtered = filtered;
        this.filterDocs = filterDocs;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        if (!(collector instanceof TopSuggestDocsCollector)) {
            throw new IllegalArgumentException("collector is not of type TopSuggestDocsCollector");
        }
        this.suggester.lookup(this, acceptDocs, (TopSuggestDocsCollector)collector);
        return max2;
    }

    @Override
    public long cost() {
        return 0L;
    }

    public final boolean accept(int docID, Bits liveDocs) {
        return !(this.filterDocs != null && !this.filterDocs.get(docID) || liveDocs != null && !liveDocs.get(docID));
    }

    public float score(float weight, float boost) {
        if (boost == 0.0f) {
            return weight;
        }
        if (weight == 0.0f) {
            return boost;
        }
        return weight * boost;
    }
}

