/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

final class MultiTermHighlighting {
    private MultiTermHighlighting() {
    }

    static CharacterRunAutomaton[] extractAutomata(Query query, Predicate<String> fieldMatcher, boolean lookInSpan) {
        AutomataCollector collector = new AutomataCollector(lookInSpan, fieldMatcher);
        query.visit(collector);
        return collector.runAutomata.toArray(new CharacterRunAutomaton[0]);
    }

    public static boolean canExtractAutomataFromLeafQuery(Query query) {
        return query instanceof AutomatonQuery || query instanceof FuzzyQuery;
    }

    private static CharacterRunAutomaton binaryToCharRunAutomaton(final Automaton binaryAutomaton, final String description) {
        return new CharacterRunAutomaton(Automata.makeEmpty()){
            ByteRunAutomaton byteRunAutomaton;
            {
                super(x0);
                this.byteRunAutomaton = new ByteRunAutomaton(binaryAutomaton, true, 10000);
            }

            @Override
            public String toString() {
                return description;
            }

            @Override
            public boolean run(char[] chars, int offset, int length) {
                int state = 0;
                int maxIdx = offset + length;
                for (int i = offset; i < maxIdx; ++i) {
                    char code = chars[i];
                    if (code < '\u0080') {
                        if ((state = this.byteRunAutomaton.step(state, code)) != -1) continue;
                        return false;
                    }
                    if (code < '\u0800') {
                        int b = 0xC0 | code >> 6;
                        if ((state = this.byteRunAutomaton.step(state, b)) == -1) {
                            return false;
                        }
                        b = 0x80 | code & 0x3F;
                        if ((state = this.byteRunAutomaton.step(state, b)) != -1) continue;
                        return false;
                    }
                    byte[] utf8Bytes = new byte[4 * (maxIdx - i)];
                    int utf8Len = UnicodeUtil.UTF16toUTF8(chars, i, maxIdx - i, utf8Bytes);
                    for (int utfIdx = 0; utfIdx < utf8Len; ++utfIdx) {
                        if ((state = this.byteRunAutomaton.step(state, utf8Bytes[utfIdx] & 0xFF)) != -1) continue;
                        return false;
                    }
                    break;
                }
                return this.byteRunAutomaton.isAccept(state);
            }
        };
    }

    private static class AutomataCollector
    extends QueryVisitor {
        List<CharacterRunAutomaton> runAutomata = new ArrayList<CharacterRunAutomaton>();
        final boolean lookInSpan;
        final Predicate<String> fieldMatcher;

        private AutomataCollector(boolean lookInSpan, Predicate<String> fieldMatcher) {
            this.lookInSpan = lookInSpan;
            this.fieldMatcher = fieldMatcher;
        }

        @Override
        public boolean acceptField(String field2) {
            return this.fieldMatcher.test(field2);
        }

        @Override
        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (!this.lookInSpan && parent instanceof SpanQuery) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            return super.getSubVisitor(occur, parent);
        }

        @Override
        public void visitLeaf(final Query query) {
            if (query instanceof AutomatonQuery) {
                AutomatonQuery aq = (AutomatonQuery)query;
                if (!aq.isAutomatonBinary()) {
                    this.runAutomata.add(new CharacterRunAutomaton(aq.getAutomaton()){

                        @Override
                        public String toString() {
                            return query.toString();
                        }
                    });
                } else {
                    this.runAutomata.add(MultiTermHighlighting.binaryToCharRunAutomaton(aq.getAutomaton(), query.toString()));
                }
            } else if (query instanceof FuzzyQuery) {
                FuzzyQuery fq = (FuzzyQuery)query;
                if (fq.getMaxEdits() == 0 || fq.getPrefixLength() >= fq.getTerm().text().length()) {
                    this.consumeTerms(query, fq.getTerm());
                } else {
                    this.runAutomata.add(new CharacterRunAutomaton(fq.toAutomaton()){

                        @Override
                        public String toString() {
                            return query.toString();
                        }
                    });
                }
            }
        }
    }
}

