/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Alternative;
import cats.Monad;
import cats.arrow.FunctionK;
import cats.data.Chain;
import cats.data.Kleisli;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.instances.package$option$;
import cats.syntax.GuardOps$;
import cats.syntax.package$alternative$;
import cats.syntax.package$flatMap$;
import cats.syntax.package$functor$;
import io.chrisdavenport.vault.Key;
import io.chrisdavenport.vault.Key$;
import io.chrisdavenport.vault.Vault;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.server.middleware.HttpMethodOverrider;
import org.http4s.server.middleware.HttpMethodOverrider$HttpMethodOverriderConfig$;
import org.http4s.util.CaseInsensitiveString;
import org.http4s.util.CaseInsensitiveString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HttpMethodOverrider$ {
    public static HttpMethodOverrider$ MODULE$;
    private final Key<Method> overriddenMethodAttrKey;

    static {
        new HttpMethodOverrider$();
    }

    public <F, G> HttpMethodOverrider.HttpMethodOverriderConfig<F, G> defaultConfig() {
        return HttpMethodOverrider$HttpMethodOverriderConfig$.MODULE$.apply(new HttpMethodOverrider.HeaderOverrideStrategy(CaseInsensitiveString$.MODULE$.apply("X-HTTP-Method-Override")), (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Method[]{(Method)((Object)Method$.MODULE$.POST())})));
    }

    public Key<Method> overriddenMethodAttrKey() {
        return this.overriddenMethodAttrKey;
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, HttpMethodOverrider.HttpMethodOverriderConfig<F, G> config, Monad<F> F, Sync<G> S) {
        Function1<String, Either> & Serializable & scala.Serializable parseMethod = (Function1<String, Either> & Serializable & scala.Serializable)m -> Method$.MODULE$.fromString(m.toUpperCase());
        Function1<Request, Object> & Serializable & scala.Serializable processRequestWithOriginalMethod = (Function1<Request, Object> & Serializable & scala.Serializable)req -> http.apply((Request)req);
        return new Kleisli((Function1<Request, Object> & Serializable & scala.Serializable)req -> package$functor$.MODULE$.toFunctorOps(GuardOps$.MODULE$.guard$extension(package$alternative$.MODULE$.catsSyntaxAlternativeGuard(config.overridableMethods().contains(req.method())), (Alternative)((Object)package$option$.MODULE$.catsStdInstancesForOption())), package$option$.MODULE$.catsStdInstancesForOption()).as(this.processRequest$1((Request)req, F, parseMethod, processRequestWithOriginalMethod, config, S, http)).getOrElse((Function0<Object> & Serializable & scala.Serializable)() -> processRequestWithOriginalMethod.apply(req)));
    }

    private final Object processRequestWithMethod$1(Request req, Either parseResult, Monad F$1, Kleisli http$1, HttpMethodOverrider.HttpMethodOverriderConfig config$1) {
        Object f;
        Either either2 = parseResult;
        if (either2 instanceof Left) {
            f = F$1.pure(new Response(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Method om = (Method)right.value();
            f = package$functor$.MODULE$.toFunctorOps(http$1.apply(this.updateRequestWithMethod$1(req, om)), F$1).map((Function1<Response, Response> & Serializable & scala.Serializable)resp -> HttpMethodOverrider$.updateVaryHeader$1(resp, config$1));
        } else {
            throw new MatchError(either2);
        }
        return f;
    }

    private static final Response updateVaryHeader$1(Response resp, HttpMethodOverrider.HttpMethodOverriderConfig config$1) {
        Response response;
        CaseInsensitiveString varyHeaderName = CaseInsensitiveString$.MODULE$.apply("Vary");
        HttpMethodOverrider.OverrideStrategy overrideStrategy = config$1.overrideStrategy();
        if (overrideStrategy instanceof HttpMethodOverrider.HeaderOverrideStrategy) {
            HttpMethodOverrider.HeaderOverrideStrategy headerOverrideStrategy = (HttpMethodOverrider.HeaderOverrideStrategy)overrideStrategy;
            CaseInsensitiveString headerName = headerOverrideStrategy.headerName();
            Header.Raw updatedVaryHeader = (Header.Raw)Headers$.MODULE$.get$extension2(resp.headers(), varyHeaderName).map((Function1<Header, Header.Raw> & Serializable & scala.Serializable)h -> Header$.MODULE$.apply(h.name().value(), new StringBuilder(2).append(h.value()).append(", ").append(headerName.value()).toString())).getOrElse((Function0<Header.Raw> & Serializable & scala.Serializable)() -> Header$.MODULE$.apply(varyHeaderName.value(), headerName.value()));
            response = (Response)resp.withHeaders(Headers$.MODULE$.put$extension(resp.headers(), Predef$.MODULE$.wrapRefArray((Object[])new Header[]{updatedVaryHeader})));
        } else {
            response = resp;
        }
        return response;
    }

    private final Request updateRequestWithMethod$1(Request req, Method om) {
        Vault attrs = req.attributes().insert(this.overriddenMethodAttrKey(), req.method());
        return ((Request)req.withAttributes(attrs)).withMethod(om);
    }

    private static final Object getUnsafeOverrideMethod$1(Request req, HttpMethodOverrider.HttpMethodOverriderConfig config$1, Monad F$1, Sync S$1) {
        Object f;
        HttpMethodOverrider.OverrideStrategy overrideStrategy = config$1.overrideStrategy();
        if (overrideStrategy instanceof HttpMethodOverrider.HeaderOverrideStrategy) {
            HttpMethodOverrider.HeaderOverrideStrategy headerOverrideStrategy = (HttpMethodOverrider.HeaderOverrideStrategy)overrideStrategy;
            CaseInsensitiveString headerName = headerOverrideStrategy.headerName();
            f = F$1.pure(Headers$.MODULE$.get$extension2(req.headers(), headerName).map((Function1<Header, String> & Serializable & scala.Serializable)x$1 -> x$1.value()));
        } else if (overrideStrategy instanceof HttpMethodOverrider.QueryOverrideStrategy) {
            HttpMethodOverrider.QueryOverrideStrategy queryOverrideStrategy = (HttpMethodOverrider.QueryOverrideStrategy)overrideStrategy;
            String parameter = queryOverrideStrategy.paramName();
            f = F$1.pure(req.params().get(parameter));
        } else if (overrideStrategy instanceof HttpMethodOverrider.FormOverrideStrategy) {
            HttpMethodOverrider.FormOverrideStrategy formOverrideStrategy = (HttpMethodOverrider.FormOverrideStrategy)overrideStrategy;
            String field2 = formOverrideStrategy.fieldName();
            FunctionK f2 = formOverrideStrategy.naturalTransformation();
            f = package$functor$.MODULE$.toFunctorOps(f2.apply(package$functor$.MODULE$.toFunctorOps(UrlForm$.MODULE$.entityDecoder(S$1, UrlForm$.MODULE$.entityDecoder$default$2()).decode(req, true).value(), S$1).map((Function1<Either, Option> & Serializable & scala.Serializable)x$2 -> x$2.toOption().map((Function1<Object, Map> & Serializable & scala.Serializable)x$3 -> ((UrlForm)x$3).values()))), F$1).map((Function1<Option, Option> & Serializable & scala.Serializable)formFields -> formFields.flatMap((Function1<Map, Option> & Serializable & scala.Serializable)x$4 -> x$4.get(field2).flatMap((Function1<Chain, Option> & Serializable & scala.Serializable)x$5 -> x$5.uncons().map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$6 -> (String)x$6._1()))));
        } else {
            throw new MatchError(overrideStrategy);
        }
        return f;
    }

    private final Object processRequest$1(Request req, Monad F$1, Function1 parseMethod$1, Function1 processRequestWithOriginalMethod$1, HttpMethodOverrider.HttpMethodOverriderConfig config$1, Sync S$1, Kleisli http$1) {
        return package$flatMap$.MODULE$.toFlatMapOps(HttpMethodOverrider$.getUnsafeOverrideMethod$1(req, config$1, F$1, S$1), F$1).flatMap((Function1<Option, Object> & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Some some;
            String m;
            Option option = x0$1;
            if (option instanceof Some && (m = (String)(some = (Some)option).value()) != null) {
                String string2 = m;
                object = parseMethod$1.andThen((Function1<Either, Object> & Serializable & scala.Serializable)x$7 -> this.processRequestWithMethod$1(req, (Either)x$7, F$1, http$1, config$1)).apply(string2);
            } else if (None$.MODULE$.equals(option)) {
                object = processRequestWithOriginalMethod$1.apply(req);
            } else {
                throw new MatchError(option);
            }
            return object;
        });
    }

    private HttpMethodOverrider$() {
        MODULE$ = this;
        this.overriddenMethodAttrKey = (Key)Key$.MODULE$.newKey(IO$.MODULE$.ioEffect()).unsafeRunSync();
    }
}

