/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;

public class ListVirtualMFADevicesPublisher
implements SdkPublisher<ListVirtualMfaDevicesResponse> {
    private final IamAsyncClient client;
    private final ListVirtualMfaDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualMFADevicesPublisher(IamAsyncClient client, ListVirtualMfaDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualMFADevicesPublisher(IamAsyncClient client, ListVirtualMfaDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualMfaDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualMfaDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualMFADevice> virtualMFADevices() {
        Function<ListVirtualMfaDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualMFADevices() != null) {
                return response.virtualMFADevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualMfaDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVirtualMfaDevicesResponseFetcher
    implements AsyncPageFetcher<ListVirtualMfaDevicesResponse> {
        private ListVirtualMfaDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMfaDevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListVirtualMfaDevicesResponse> nextPage(ListVirtualMfaDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMFADevicesPublisher.this.client.listVirtualMFADevices(ListVirtualMFADevicesPublisher.this.firstRequest);
            }
            return ListVirtualMFADevicesPublisher.this.client.listVirtualMFADevices((ListVirtualMfaDevicesRequest)((Object)ListVirtualMFADevicesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

