/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.messagequeuemiddleware;

import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.log.Log$;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware$MessageScheduler$;
import net.shrine.messagequeuemiddleware.MessageDoesNotExistAndCannotBeCompletedException;
import net.shrine.messagequeuemiddleware.QueueDoesNotExistException;
import net.shrine.messagequeueservice.DeliveryAttemptId;
import net.shrine.messagequeueservice.DeliveryAttemptId$;
import net.shrine.messagequeueservice.Message;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.protocol.version.MomQueueName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LocalMessageQueueMiddleware$
implements MessageQueueService {
    public static final LocalMessageQueueMiddleware$ MODULE$ = new LocalMessageQueueMiddleware$();
    private static final String configPath;
    private static final TrieMap<DeliveryAttemptId, Tuple2<LocalMessageQueueMiddleware.DeliveryAttempt, Option<ScheduledFuture<?>>>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap;
    private static final TrieMap<Object, ScheduledFuture<?>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks;
    private static final Map<MomQueueName, BlockingDeque<LocalMessageQueueMiddleware.InternalMessage>> blockingQueuePool;
    private static final ContextShift<IO> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$logActionContextShift;
    private static volatile int bitmap$init$0;

    static {
        MessageQueueService.$init$(MODULE$);
        configPath = "shrine.hub.messagequeue.blockingq";
        bitmap$init$0 |= 1;
        net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap = TrieMap$.MODULE$.empty();
        bitmap$init$0 |= 2;
        net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks = TrieMap$.MODULE$.empty();
        bitmap$init$0 |= 4;
        blockingQueuePool = TrieMap$.MODULE$.empty();
        bitmap$init$0 |= 8;
        net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$logActionContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.longActionExecutionContext());
        bitmap$init$0 |= 0x10;
    }

    @Override
    public IO<BoxedUnit> deleteQueueIfExistsIO(String queueName) {
        return MessageQueueService.deleteQueueIfExistsIO$(this, queueName);
    }

    public String configPath() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 30");
        }
        return configPath;
    }

    private Config config() {
        return ConfigSource$.MODULE$.config().getConfig(this.configPath());
    }

    public long net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageTimeToLiveInMillis() {
        return ((Duration)package$.MODULE$.ConfigExtensions(this.config()).get("messageTimeToLive", (Function1 & Serializable)x$1 -> Duration$.MODULE$.apply(x$1))).toMillis();
    }

    private long messageRedeliveryDelay() {
        return ((Duration)package$.MODULE$.ConfigExtensions(this.config()).get("messageRedeliveryDelay", (Function1 & Serializable)x$2 -> Duration$.MODULE$.apply(x$2))).toMillis();
    }

    public int net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageMaxDeliveryAttempts() {
        return this.config().getInt("messageMaxDeliveryAttempts");
    }

    public TrieMap<DeliveryAttemptId, Tuple2<LocalMessageQueueMiddleware.DeliveryAttempt, Option<ScheduledFuture<?>>>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 41");
        }
        return net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap;
    }

    public TrieMap<Object, ScheduledFuture<?>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 44");
        }
        return net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks;
    }

    public List<Runnable> stop() {
        return LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.shutDown();
    }

    public Map<MomQueueName, BlockingDeque<LocalMessageQueueMiddleware.InternalMessage>> blockingQueuePool() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 55");
        }
        return blockingQueuePool;
    }

    public IO<LocalMessageQueueMiddleware.LocalQueue> createQueueIfAbsentIO(String queueName) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            LocalMessageQueueMiddleware.LocalQueue proposedQueue = new LocalMessageQueueMiddleware.LocalQueue(queueName);
            MODULE$.blockingQueuePool().getOrElseUpdate((Object)new MomQueueName(proposedQueue.name()), (Function0 & Serializable)() -> new LinkedBlockingDeque());
            Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(22).append("created proposedQueue ").append(new MomQueueName(queueName)).toString());
            return proposedQueue;
        });
    }

    @Override
    public IO<BoxedUnit> addReceiverPermissionToQueueIO(String queueName, String receiverId) {
        return IO$.MODULE$.unit();
    }

    @Override
    public IO<BoxedUnit> addSenderPermissionToQueueIO(String queueName, String senderId) {
        return IO$.MODULE$.unit();
    }

    @Override
    public IO<BoxedUnit> removePermissionFromQueueIO(String queueName, String receiverId) {
        return IO$.MODULE$.unit();
    }

    public IO<LocalMessageQueueMiddleware.LocalQueue> getQueueIO(String queueName) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            LocalMessageQueueMiddleware.LocalQueue proposedQueue = new LocalMessageQueueMiddleware.LocalQueue(queueName);
            IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(46).append("getQueueIO from ").append(new MomQueueName(queueName)).append(" - blockingQueuePool contains ").append(MODULE$.blockingQueuePool().keys()).toString()));
            MODULE$.blockingQueuePool().getOrElse((Object)new MomQueueName(proposedQueue.name()), (Function0 & Serializable)() -> {
                throw new QueueDoesNotExistException(new LocalMessageQueueMiddleware.LocalQueue(queueName));
            });
            return proposedQueue;
        });
    }

    @Override
    public IO<BoxedUnit> deleteQueueIO(String queueName) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.blockingQueuePool().remove((Object)new MomQueueName(queueName)).getOrElse((Function0 & Serializable)() -> {
            throw new QueueDoesNotExistException(new LocalMessageQueueMiddleware.LocalQueue(queueName));
        }));
    }

    public IO<Seq<LocalMessageQueueMiddleware.LocalQueue>> queuesIO() {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> ((IterableOnceOps)MODULE$.blockingQueuePool().keys().map((Function1 & Serializable)name -> LocalMessageQueueMiddleware$.$anonfun$queuesIO$2(((MomQueueName)name).underlying()))).toSeq());
    }

    public ContextShift<IO> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$logActionContextShift() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 93");
        }
        return net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$logActionContextShift;
    }

    public Message toMessage(LocalMessageQueueMiddleware.LocalQueue from, LocalMessageQueueMiddleware.InternalMessage internalMessage) {
        long deliveryAttemptID = DeliveryAttemptId$.MODULE$.create();
        LocalMessageQueueMiddleware.DeliveryAttempt deliveryAttempt = new LocalMessageQueueMiddleware.DeliveryAttempt(internalMessage, internalMessage.createdTime(), from);
        LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.scheduleMessageRedelivery(deliveryAttemptID, deliveryAttempt, this.messageRedeliveryDelay(), this.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageMaxDeliveryAttempts());
        LocalMessageQueueMiddleware.LocalMessage localMessage = new LocalMessageQueueMiddleware.LocalMessage(deliveryAttemptID, this.messageRedeliveryDelay(), internalMessage.remainingAttempts(), internalMessage.contents());
        Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(25).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(deliveryAttempt.toString()), 70)).append(" scheduled to expire for ").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(localMessage.toString()), 70)).toString());
        return localMessage;
    }

    public IO<BoxedUnit> completeMessage(long deliveryAttemptId) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option deliveryAttemptAndFutureTaskOpt = MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().get((Object)new DeliveryAttemptId(deliveryAttemptId));
            deliveryAttemptAndFutureTaskOpt.fold((Function0 & Serializable)() -> {
                throw new MessageDoesNotExistAndCannotBeCompletedException(deliveryAttemptId);
            }, (Function1 & Serializable)deliveryAttemptAndFutureTask -> {
                LocalMessageQueueMiddleware$.$anonfun$completeMessage$3(deliveryAttemptAndFutureTask);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ LocalMessageQueueMiddleware.LocalQueue $anonfun$queuesIO$2(String name) {
        return new LocalMessageQueueMiddleware.LocalQueue(name);
    }

    public static final /* synthetic */ boolean $anonfun$completeMessage$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 != null) {
            long id = ((DeliveryAttemptId)tuple2._1()).underlying();
            Tuple2 eachDAandTask = (Tuple2)tuple2._2();
            if (new DeliveryAttemptId(id) instanceof DeliveryAttemptId && eachDAandTask instanceof Tuple2) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$completeMessage$5(LocalMessageQueueMiddleware.InternalMessage internalToBeSentMessage$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            long id = ((DeliveryAttemptId)tuple2._1()).underlying();
            Tuple2 eachDAandTask = (Tuple2)tuple2._2();
            if (new DeliveryAttemptId(id) instanceof DeliveryAttemptId) {
                long l = id;
                if (eachDAandTask instanceof Tuple2) {
                    Tuple2 tuple22 = eachDAandTask;
                    if (((LocalMessageQueueMiddleware.DeliveryAttempt)tuple22._1()).message().id() == internalToBeSentMessage$1.id()) {
                        MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().remove((Object)new DeliveryAttemptId(l));
                        LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.cancelScheduledMessageRedelivery((Option)tuple22._2());
                        MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks().remove((Object)BoxesRunTime.boxToLong((long)internalToBeSentMessage$1.id())).foreach((Function1 & Serializable)futureTask -> {
                            LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.cancelExpiredMessageCleanup(futureTask);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$completeMessage$3(Tuple2 deliveryAttemptAndFutureTask) {
        LocalMessageQueueMiddleware.DeliveryAttempt deliveryAttempt = (LocalMessageQueueMiddleware.DeliveryAttempt)deliveryAttemptAndFutureTask._1();
        LocalMessageQueueMiddleware.InternalMessage internalToBeSentMessage = deliveryAttempt.message();
        LocalMessageQueueMiddleware.LocalQueue queue = internalToBeSentMessage.toQueue();
        MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LocalMessageQueueMiddleware$.$anonfun$completeMessage$4(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            LocalMessageQueueMiddleware$.$anonfun$completeMessage$5(internalToBeSentMessage, x$3);
            return BoxedUnit.UNIT;
        });
        BlockingDeque blockingQueue = (BlockingDeque)MODULE$.blockingQueuePool().getOrElse((Object)new MomQueueName(queue.name()), (Function0 & Serializable)() -> {
            throw new QueueDoesNotExistException(queue);
        });
        blockingQueue.remove(internalToBeSentMessage);
        Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(23).append("Message from ").append(((LocalMessageQueueMiddleware.DeliveryAttempt)deliveryAttemptAndFutureTask._1()).fromQueue()).append(" completed").toString());
    }

    private LocalMessageQueueMiddleware$() {
    }
}

