/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.qep.metrics;

import java.io.Console;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.SealedObject;
import net.shrine.config.ConfigSource$;
import net.shrine.crypto.SealerRevealer$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.UserName;
import net.shrine.qep.metrics.QueryCsv$;
import net.shrine.qep.metrics.ResearcherCsv$;
import net.shrine.qep.metrics.ResearcherMetrics;
import net.shrine.qep.metrics.ResearcherMetrics$CommandLine$;
import net.shrine.qep.metrics.ResultCsv$;
import net.shrine.util.Versions$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class ResearcherMetrics$ {
    public static final ResearcherMetrics$ MODULE$ = new ResearcherMetrics$();
    private static final String net$shrine$qep$metrics$ResearcherMetrics$$QUERIES_COMMAND = "queries";
    private static final String RESULTS_COMMAND;
    private static final String RESEARCHERS_COMMAND;
    private static final File net$shrine$qep$metrics$ResearcherMetrics$$DEFAULT_OUT_FILE;
    private static final OParser<BoxedUnit, ResearcherMetrics.CommandLine> parser;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        RESULTS_COMMAND = "results";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        RESEARCHERS_COMMAND = "researchers";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        net$shrine$qep$metrics$ResearcherMetrics$$DEFAULT_OUT_FILE = new File("");
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        OParserBuilder builder = OParser$.MODULE$.builder();
        parser = OParser$.MODULE$.sequence(builder.programName("researcherMetrics"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Gather metrics of SHRINE from the local QEP database"})), builder.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Versions$.MODULE$.version()})), builder.help('h', "help"), builder.version('v', "version"), builder.cmd(MODULE$.net$shrine$qep$metrics$ResearcherMetrics$$QUERIES_COMMAND()).action((Function2 & Serializable)(x$1, c) -> c.copy(MODULE$.net$shrine$qep$metrics$ResearcherMetrics$$QUERIES_COMMAND(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5())).text("Create a csv file of queries"), builder.cmd(MODULE$.RESULTS_COMMAND()).action((Function2 & Serializable)(x$2, c) -> c.copy(MODULE$.RESULTS_COMMAND(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5())).text("Create a csv file of results"), builder.cmd(MODULE$.RESEARCHERS_COMMAND()).action((Function2 & Serializable)(x$3, c) -> c.copy(MODULE$.RESEARCHERS_COMMAND(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5())).text("Create a csv file of researchers"), builder.opt('o', "out", Read$.MODULE$.fileRead()).optional().valueName("<file>").action((Function2 & Serializable)(out, c) -> {
            File x$1 = out;
            String x$2 = c.copy$default$1();
            Option<UserName> x$3 = c.copy$default$3();
            Calendar x$4 = c.copy$default$4();
            Calendar x$5 = c.copy$default$5();
            return c.copy(x$2, x$1, x$3, x$4, x$5);
        }).text("csv files are written to this file. Defaults to command.datestamp.csv"), builder.opt('u', "username", Read$.MODULE$.stringRead()).optional().valueName("<researcher user name>").action((Function2 & Serializable)(username, c) -> {
            Option x$6 = Option$.MODULE$.apply((Object)new UserName(username));
            String x$7 = c.copy$default$1();
            File x$8 = c.copy$default$2();
            Calendar x$9 = c.copy$default$4();
            Calendar x$10 = c.copy$default$5();
            return c.copy(x$7, x$8, (Option<UserName>)x$6, x$9, x$10);
        }).text("filter for just this researcher"), builder.opt('s', "startDate", Read$.MODULE$.yyyymmdddRead()).withFallback((Function0 & Serializable)() -> {
            Calendar cal = Calendar.getInstance();
            cal.setTime(Date.from(Instant.EPOCH));
            return cal;
        }).valueName("<date>").action((Function2 & Serializable)(startDate, c) -> {
            Calendar x$11 = startDate;
            String x$12 = c.copy$default$1();
            File x$13 = c.copy$default$2();
            Option<UserName> x$14 = c.copy$default$3();
            Calendar x$15 = c.copy$default$5();
            return c.copy(x$12, x$13, x$14, x$11, x$15);
        }).text("first date (included) like 2000-12-01. Defaults to the start of the epoch - 1970"), builder.opt('e', "endDate", Read$.MODULE$.yyyymmdddRead()).withFallback((Function0 & Serializable)() -> {
            Calendar cal = Calendar.getInstance();
            cal.setTime(Date.from(Instant.now()));
            return cal;
        }).valueName("<date>").action((Function2 & Serializable)(endDate, c) -> {
            Calendar x$16 = endDate;
            String x$17 = c.copy$default$1();
            File x$18 = c.copy$default$2();
            Option<UserName> x$19 = c.copy$default$3();
            Calendar x$20 = c.copy$default$4();
            return c.copy(x$17, x$18, x$19, x$20, x$16);
        }).text("last date (excluded) like 2000-12-01. Defaults to now")}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public String net$shrine$qep$metrics$ResearcherMetrics$$QUERIES_COMMAND() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ResearcherMetrics.scala: 17");
        }
        return net$shrine$qep$metrics$ResearcherMetrics$$QUERIES_COMMAND;
    }

    private String RESULTS_COMMAND() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ResearcherMetrics.scala: 18");
        }
        return RESULTS_COMMAND;
    }

    private String RESEARCHERS_COMMAND() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ResearcherMetrics.scala: 19");
        }
        return RESEARCHERS_COMMAND;
    }

    public File net$shrine$qep$metrics$ResearcherMetrics$$DEFAULT_OUT_FILE() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ResearcherMetrics.scala: 21");
        }
        return net$shrine$qep$metrics$ResearcherMetrics$$DEFAULT_OUT_FILE;
    }

    private OParser<BoxedUnit, ResearcherMetrics.CommandLine> parser() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ResearcherMetrics.scala: 30");
        }
        return parser;
    }

    public void doCommand(String[] args) {
        Some some;
        ResearcherMetrics.CommandLine commandLine;
        Option option = OParser$.MODULE$.parse(this.parser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ResearcherMetrics.CommandLine(ResearcherMetrics$CommandLine$.MODULE$.apply$default$1(), ResearcherMetrics$CommandLine$.MODULE$.apply$default$2(), ResearcherMetrics$CommandLine$.MODULE$.apply$default$3(), ResearcherMetrics$CommandLine$.MODULE$.apply$default$4(), ResearcherMetrics$CommandLine$.MODULE$.apply$default$5()));
        if (option instanceof Some && (commandLine = (ResearcherMetrics.CommandLine)(some = (Some)option).value()) != null) {
            String string;
            ResearcherMetrics.CommandLine commandLine2 = commandLine;
            File file = commandLine2.out();
            File file2 = this.net$shrine$qep$metrics$ResearcherMetrics$$DEFAULT_OUT_FILE();
            File outFile = !(file != null ? !((Object)file).equals(file2) : file2 != null) ? new File(new StringBuilder(5).append(commandLine2.command()).append(".").append(DateStamp$.MODULE$.now()).append(".csv").toString()) : commandLine2.out();
            long startDate = commandLine2.startDate().getTimeInMillis();
            long endDate = commandLine2.endDate().getTimeInMillis();
            String passwordConfigPath = "shrine.queryEntryPoint.audit.database.dataSourceConfig.credentials.password";
            if (ConfigSource$.MODULE$.config().hasPath(passwordConfigPath)) {
                string = ConfigSource$.MODULE$.config().getString(passwordConfigPath);
            } else {
                Predef$.MODULE$.print((Object)"database password>");
                Console stdIn = System.console();
                string = new String(stdIn.readPassword());
            }
            SealedObject databasePassword = SealerRevealer$.MODULE$.seal(string);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)ConfigSource$.MODULE$.configForBlock(passwordConfigPath, (Object)SealerRevealer$.MODULE$.reveal(databasePassword), "password", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String string = commandLine2.command();
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                String string2 = string;
                String string3 = MODULE$.net$shrine$qep$metrics$ResearcherMetrics$$QUERIES_COMMAND();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    QueryCsv$.MODULE$.writeQueryCsv(outFile, startDate, endDate, commandLine2.researcher());
                } else {
                    String string4 = string;
                    String string5 = MODULE$.RESULTS_COMMAND();
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        ResultCsv$.MODULE$.writeResultsCsv(outFile, startDate, endDate, commandLine2.researcher());
                    } else {
                        String string6 = string;
                        String string7 = MODULE$.RESEARCHERS_COMMAND();
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            ResearcherCsv$.MODULE$.writeResearcherCsv(outFile, startDate, endDate, commandLine2.researcher());
                        } else {
                            throw new MatchError((Object)string);
                        }
                    }
                }
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public void main(String[] args) {
        try {
            try {
                this.doCommand(args);
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(2);
            }
        }
        finally {
            ExecutionContexts$.MODULE$.shutdown();
            System.exit(0);
        }
    }

    private ResearcherMetrics$() {
    }
}

