/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.messagequeueclient;

import cats.effect.IO;
import cats.effect.IO$;
import ch.qos.logback.classic.Logger;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.LazyIO$;
import net.shrine.http4s.client.Http4sHttpClient;
import net.shrine.http4s.client.Http4sHttpClient$;
import net.shrine.log.Loggable;
import net.shrine.messagequeueclient.CouldNotInterpretHTTPResponseProblem$;
import net.shrine.messagequeueclient.MessageQueueWebClient;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskButOKToRetryException;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskButOKToRetryException$;
import net.shrine.messagequeueservice.MessageAsJson;
import net.shrine.messagequeueservice.MessageAsJson$;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.messagequeueservice.Queue$;
import net.shrine.messagequeueservice.ShrineMessageRequests$;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.version.MomQueueName;
import org.http4s.Request;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class MessageQueueWebClient$
implements MessageQueueService,
Loggable {
    public static final MessageQueueWebClient$ MODULE$ = new MessageQueueWebClient$();
    private static final String configPath;
    private static final Config webClientConfig;
    private static final Duration net$shrine$messagequeueclient$MessageQueueWebClient$$receiveWaitTime;
    private static final Uri momBaseUri;
    private static final Http4sHttpClient http4sHttpClient;
    private static final Map<MomQueueName, IO<MessageQueueWebClient.ClientQueue>> queueNamesToQueues;
    private static final BoxedUnit net$shrine$messagequeueclient$MessageQueueWebClient$$unit;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile int bitmap$init$0;
    private static volatile boolean bitmap$0;

    static {
        MessageQueueService.$init$(MODULE$);
        Loggable.$init$((Loggable)MODULE$);
        MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "Using MessageQueueWebClient");
        configPath = "shrine.hub.messagequeue.blockingq";
        bitmap$init$0 |= 1;
        webClientConfig = ConfigSource$.MODULE$.config().getConfig(MODULE$.configPath());
        bitmap$init$0 |= 2;
        net$shrine$messagequeueclient$MessageQueueWebClient$$receiveWaitTime = (Duration)package$.MODULE$.ConfigExtensions(MODULE$.webClientConfig()).get("receiveWaitTime", (Function1 & Serializable)x$1 -> Duration$.MODULE$.apply(x$1));
        bitmap$init$0 |= 4;
        package.ConfigExtensions qual$1 = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config());
        String x$12 = "shrine.shrineHubBaseUrl";
        String x$2 = "shrine.hub.messagequeue.blockingq.serverUrlPath";
        Function1 & Serializable x$3 = (Function1 & Serializable)s -> Uri$.MODULE$.unsafeFromString(s);
        Option x$4 = qual$1.buildURI$default$4();
        momBaseUri = (Uri)qual$1.buildURI("shrine.shrineHubBaseUrl", "shrine.hub.messagequeue.blockingq.serverUrlPath", (Function1)x$3, x$4);
        bitmap$init$0 |= 8;
        http4sHttpClient = Http4sHttpClient$.MODULE$.apply(ConfigSource$.MODULE$.config().getConfig("shrine.hub.messagequeue.httpClient"), Http4sHttpClient$.MODULE$.apply$default$2(), Http4sHttpClient$.MODULE$.apply$default$3());
        bitmap$init$0 |= 0x10;
        queueNamesToQueues = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        bitmap$init$0 |= 0x20;
        net$shrine$messagequeueclient$MessageQueueWebClient$$unit = BoxedUnit.UNIT;
        bitmap$init$0 |= 0x40;
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    @Override
    public IO<BoxedUnit> deleteQueueIfExistsIO(String queueName) {
        return MessageQueueService.deleteQueueIfExistsIO$(this, queueName);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        MessageQueueWebClient$ messageQueueWebClient$ = this;
        synchronized (messageQueueWebClient$) {
            if (!bitmap$0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = true;
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if (!bitmap$0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public String configPath() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 33");
        }
        return configPath;
    }

    public Config webClientConfig() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 35");
        }
        return webClientConfig;
    }

    public Duration net$shrine$messagequeueclient$MessageQueueWebClient$$receiveWaitTime() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 37");
        }
        return net$shrine$messagequeueclient$MessageQueueWebClient$$receiveWaitTime;
    }

    public Uri momBaseUri() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 39");
        }
        return momBaseUri;
    }

    private Http4sHttpClient http4sHttpClient() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 41");
        }
        return http4sHttpClient;
    }

    public Status net$shrine$messagequeueclient$MessageQueueWebClient$$filterErrorStatus(Uri uri, Status status, String bodyString) {
        if (status.isSuccess()) {
            return status;
        }
        throw new CouldNotCompleteMomTaskButOKToRetryException(uri, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
    }

    public <A> IO<A> net$shrine$messagequeueclient$MessageQueueWebClient$$momFetchAndDecodeIO(Request<IO> request, Function2<Status, String, IO<A>> toA) {
        return this.http4sHttpClient().webFetchAndDecodeIO(request, toA).handleErrorWith((Function1 & Serializable)x0$1 -> {
            Option option;
            Throwable throwable = x0$1;
            if (throwable instanceof CouldNotCompleteMomTaskButOKToRetryException) {
                CouldNotCompleteMomTaskButOKToRetryException couldNotCompleteMomTaskButOKToRetryException = (CouldNotCompleteMomTaskButOKToRetryException)throwable;
                throw couldNotCompleteMomTaskButOKToRetryException;
            }
            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable x = (Throwable)option.get();
                throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Throwable>)new Some((Object)x));
            }
            throw throwable;
        });
    }

    public IO<String> ping() {
        Request<IO> request = ShrineMessageRequests$.MODULE$.pingRequest(this.momBaseUri());
        return this.net$shrine$messagequeueclient$MessageQueueWebClient$$momFetchAndDecodeIO(request, (Function2 & Serializable)(status, bodyString) -> {
            MODULE$.net$shrine$messagequeueclient$MessageQueueWebClient$$filterErrorStatus(request.uri(), (Status)status, (String)bodyString);
            Status.ResponseClass responseClass = status.responseClass();
            Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
            if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                return IO$.MODULE$.apply((Function0 & Serializable)() -> bodyString);
            }
            MODULE$.error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(163).append("Try to ").append(request).append(" , HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ").append(status).append("\n             |Body: ").append((String)bodyString).toString())));
            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
        });
    }

    public IO<MessageQueueWebClient.ClientQueue> createQueueIfAbsentIO(String queueName) {
        Request<IO> request = ShrineMessageRequests$.MODULE$.createQueueRequest(this.momBaseUri(), queueName);
        return this.net$shrine$messagequeueclient$MessageQueueWebClient$$momFetchAndDecodeIO(request, (Function2 & Serializable)(status, bodyString) -> {
            MODULE$.net$shrine$messagequeueclient$MessageQueueWebClient$$filterErrorStatus(request.uri(), (Status)status, (String)bodyString);
            Status.ResponseClass responseClass = status.responseClass();
            Status.ResponseClass responseClass2 = Status$.MODULE$.Created().responseClass();
            if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    MessageQueueWebClient.ClientQueue clientQueue;
                    try {
                        clientQueue = new MessageQueueWebClient.ClientQueue(Queue$.MODULE$.fromJson((String)bodyString).name());
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable x = (Throwable)option.get();
                            CouldNotInterpretHTTPResponseProblem$.MODULE$.apply(x, "create a Queue", queueName, (String)bodyString);
                            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), (Option<Throwable>)new Some((Object)x));
                        }
                        throw throwable;
                    }
                    return clientQueue;
                }).map((Function1 & Serializable)queue -> {
                    MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append(queue).append(" created.").toString());
                    return queue;
                });
            }
            MODULE$.error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(176).append("Try to create a queue, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ").append(status).append("\n             |Body: ").append((String)bodyString).toString())));
            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
        });
    }

    @Override
    public IO<BoxedUnit> addReceiverPermissionToQueueIO(String queueName, String receiverId) {
        return IO$.MODULE$.unit();
    }

    @Override
    public IO<BoxedUnit> addSenderPermissionToQueueIO(String queueName, String senderId) {
        return IO$.MODULE$.unit();
    }

    @Override
    public IO<BoxedUnit> removePermissionFromQueueIO(String queueName, String receiverId) {
        return IO$.MODULE$.unit();
    }

    private Map<MomQueueName, IO<MessageQueueWebClient.ClientQueue>> queueNamesToQueues() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 146");
        }
        return queueNamesToQueues;
    }

    public IO<MessageQueueWebClient.ClientQueue> getQueueIO(String queueName) {
        return (IO)this.queueNamesToQueues().getOrElseUpdate((Object)new MomQueueName(queueName), (Function0 & Serializable)() -> LazyIO$.MODULE$.apply(new StringBuilder(12).append("getQueueIO(").append(new MomQueueName(queueName)).append(")").toString(), MODULE$.networkGetQueueIO(queueName)));
    }

    private IO<MessageQueueWebClient.ClientQueue> networkGetQueueIO(String queueName) {
        Request<IO> request = ShrineMessageRequests$.MODULE$.getQueueRequest(this.momBaseUri(), queueName);
        return this.net$shrine$messagequeueclient$MessageQueueWebClient$$momFetchAndDecodeIO(request, (Function2 & Serializable)(status, bodyString) -> {
            MODULE$.net$shrine$messagequeueclient$MessageQueueWebClient$$filterErrorStatus(request.uri(), (Status)status, (String)bodyString);
            Status.ResponseClass responseClass = status.responseClass();
            Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
            if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    MessageQueueWebClient.ClientQueue clientQueue;
                    try {
                        clientQueue = new MessageQueueWebClient.ClientQueue(Queue$.MODULE$.fromJson((String)bodyString).name());
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable x = (Throwable)option.get();
                            CouldNotInterpretHTTPResponseProblem$.MODULE$.apply(x, "get a Queue", queueName, (String)bodyString);
                            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), (Option<Throwable>)new Some((Object)x));
                        }
                        throw throwable;
                    }
                    return clientQueue;
                });
            }
            MODULE$.error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(173).append("Try to get a queue, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ").append(status).append("\n             |Body: ").append((String)bodyString).toString())));
            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
        });
    }

    public void net$shrine$messagequeueclient$MessageQueueWebClient$$unit() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 180");
        }
    }

    @Override
    public IO<BoxedUnit> deleteQueueIO(String queueName) {
        Request<IO> request = ShrineMessageRequests$.MODULE$.deleteQueueRequest(this.momBaseUri(), queueName);
        return this.net$shrine$messagequeueclient$MessageQueueWebClient$$momFetchAndDecodeIO(request, (Function2 & Serializable)(status, bodyString) -> {
            MODULE$.net$shrine$messagequeueclient$MessageQueueWebClient$$filterErrorStatus(request.uri(), (Status)status, (String)bodyString);
            Status.ResponseClass responseClass = status.responseClass();
            Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
            if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.net$shrine$messagequeueclient$MessageQueueWebClient$$unit());
            }
            MODULE$.error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(176).append("Try to delete a queue, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ").append(status).append("\n             |Body: ").append((String)bodyString).toString())));
            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
        });
    }

    public IO<Seq<MessageQueueWebClient.ClientQueue>> queuesIO() {
        Request<IO> request = ShrineMessageRequests$.MODULE$.getQueuesRequest(this.momBaseUri());
        return this.net$shrine$messagequeueclient$MessageQueueWebClient$$momFetchAndDecodeIO(request, (Function2 & Serializable)(status, bodyString) -> {
            MODULE$.net$shrine$messagequeueclient$MessageQueueWebClient$$filterErrorStatus(request.uri(), (Status)status, (String)bodyString);
            Status.ResponseClass responseClass = status.responseClass();
            Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
            if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    Seq seq;
                    try {
                        seq = (Seq)Queue$.MODULE$.seqFromJson((String)bodyString).map((Function1 & Serializable)q -> new MessageQueueWebClient.ClientQueue(q.name()));
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable x = (Throwable)option.get();
                            CouldNotInterpretHTTPResponseProblem$.MODULE$.apply(x, "getQueues", (String)bodyString);
                            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), (Option<Throwable>)new Some((Object)x));
                        }
                        throw throwable;
                    }
                    return seq;
                });
            }
            MODULE$.error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(176).append("Try to get all queues, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ").append(status).append("\n             |Body: ").append((String)bodyString).toString())));
            throw new CouldNotCompleteMomTaskButOKToRetryException(request.uri(), (Option<Status>)new Some(status), (Option<String>)new Some(bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
        });
    }

    public Option<MessageAsJson> net$shrine$messagequeueclient$MessageQueueWebClient$$messageOptionFromResponse(Status status, String bodyString, Uri uri) {
        if (status.code() == Status$.MODULE$.NoContent().code()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("No message received from ").append(uri).append(", HTTP Response ").append(status).append(" ").append(bodyString).toString());
            return None$.MODULE$;
        }
        if (status.code() == Status$.MODULE$.Ok().code()) {
            Some some;
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Non-empty Message received from ").append(uri).toString());
            try {
                some = new Some(MessageAsJson$.MODULE$.tryRead(bodyString).get());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable x = (Throwable)option.get();
                    CouldNotInterpretHTTPResponseProblem$.MODULE$.apply(x, new StringBuilder(22).append("create a Message with ").append(uri.toString()).toString(), bodyString);
                    throw x;
                }
                throw throwable;
            }
            return some;
        }
        throw new CouldNotCompleteMomTaskButOKToRetryException(uri, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
    }

    private MessageQueueWebClient$() {
    }
}

