/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;

public class ListMFADevicesIterable
implements SdkIterable<ListMfaDevicesResponse> {
    private final IamClient client;
    private final ListMfaDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMFADevicesIterable(IamClient client, ListMfaDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMfaDevicesResponseFetcher();
    }

    public Iterator<ListMfaDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MFADevice> mfaDevices() {
        Function<ListMfaDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.mfaDevices() != null) {
                return response.mfaDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMfaDevicesResponseFetcher
    implements SyncPageFetcher<ListMfaDevicesResponse> {
        private ListMfaDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListMfaDevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListMfaDevicesResponse nextPage(ListMfaDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListMFADevicesIterable.this.client.listMFADevices(ListMFADevicesIterable.this.firstRequest);
            }
            return ListMFADevicesIterable.this.client.listMFADevices((ListMfaDevicesRequest)((Object)ListMFADevicesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

