/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.authentication.http4s;

import cats.Applicative;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import net.shrine.authentication.http4s.SSOAuthentication;
import net.shrine.authentication.http4s.SSOAuthentication$RemoteUserNotFoundIssue$;
import net.shrine.authentication.pm.User;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.log.Log$;
import net.shrine.protocol.i2b2.Credential$;
import org.http4s.ContextRequest;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.server.package;
import org.typelevel.ci.CIString$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.util.Either;

public final class SSOAuthentication$ {
    public static final SSOAuthentication$ MODULE$ = new SSOAuthentication$();
    private static volatile boolean bitmap$init$0;

    private IO<User> initializeUser(String username) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            String domain = (String)package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getOption("shrine.webclient.domain", (Function1 & Serializable)x$12 -> (Function1 & Serializable)x$1 -> x$12.getString(x$1)).getOrElse((Function0 & Serializable)() -> ConfigSource$.MODULE$.config().getString("shrine.i2b2Domain"));
            Duration sessionTimeout = (Duration)package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).get("shrine.webclient.sessionTimeout", (Function1 & Serializable)x$2 -> Duration$.MODULE$.apply(x$2));
            return new User(username, username, domain, Credential$.MODULE$.safe(), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, Set<String>>)Predef$.MODULE$.Map().empty(), (Option<String>)new Some((Object)Long.toString(sessionTimeout.toMillis())));
        });
    }

    private Kleisli<IO, Request<IO>, Either<SSOAuthentication.SSOIssue, User>> authUser() {
        return new Kleisli((Function1 & Serializable)request -> {
            String remoteUserIdentifier = "REMOTE_USER";
            Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(29).append("Getting ").append(remoteUserIdentifier).append(" from request headers").toString());
            Option header = Headers$.MODULE$.get$extension(request.headers(), CIString$.MODULE$.apply(remoteUserIdentifier)).map((Function1 & Serializable)x$3 -> (Header.Raw)x$3.head());
            return (IO)header.map((Function1 & Serializable)h -> {
                Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(28).append("Got ").append(remoteUserIdentifier).append(" = ").append(h.value()).append(" from request headers").toString());
                return MODULE$.initializeUser(h.value()).map((Function1 & Serializable)x$4 -> scala.package$.MODULE$.Right().apply(x$4));
            }).getOrElse((Function0 & Serializable)() -> {
                Log$.MODULE$.error((Function0 & Serializable)() -> new StringBuilder(37).append(remoteUserIdentifier).append(" was not found in the request headers").toString());
                return IO$.MODULE$.apply((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)SSOAuthentication$RemoteUserNotFoundIssue$.MODULE$));
            });
        });
    }

    private Kleisli<?, ContextRequest<IO, SSOAuthentication.SSOIssue>, Response<IO>> onAuthFailure() {
        return new Kleisli((Function1 & Serializable)req -> {
            Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(34).append("Responded with status ").append(Status$.MODULE$.Unauthorized()).append(" to request ").append(req.req()).toString());
            return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)Response$.MODULE$.apply(Status$.MODULE$.Unauthorized(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)IO$.MODULE$.asyncForIO());
        });
    }

    public Function1<Kleisli<?, ContextRequest<IO, User>, Response<IO>>, Kleisli<?, Request<IO>, Response<IO>>> authMiddleware() {
        return package.AuthMiddleware$.MODULE$.apply(this.authUser(), this.onAuthFailure(), (Monad)IO$.MODULE$.asyncForIO());
    }

    private SSOAuthentication$() {
    }
}

