/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;

public class ListAttachedUserPoliciesIterable
implements SdkIterable<ListAttachedUserPoliciesResponse> {
    private final IamClient client;
    private final ListAttachedUserPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedUserPoliciesIterable(IamClient client, ListAttachedUserPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttachedUserPoliciesResponseFetcher();
    }

    public Iterator<ListAttachedUserPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedUserPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachedUserPoliciesResponseFetcher
    implements SyncPageFetcher<ListAttachedUserPoliciesResponse> {
        private ListAttachedUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedUserPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedUserPoliciesResponse nextPage(ListAttachedUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedUserPoliciesIterable.this.client.listAttachedUserPolicies(ListAttachedUserPoliciesIterable.this.firstRequest);
            }
            return ListAttachedUserPoliciesIterable.this.client.listAttachedUserPolicies((ListAttachedUserPoliciesRequest)((Object)ListAttachedUserPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

