create table "QUERY_SENT" (
    "SHRINE_NODE_ID" VARCHAR2(256) NOT NULL,
    "USER_NAME" VARCHAR2(256) NOT NULL,
    "NETWORK_QUERY_ID" NUMBER NOT NULL,
    "QUERY_NAME" VARCHAR2(256) NOT NULL,
    "TIME_QUERY_SENT" NUMBER NOT NULL
);

create table "PREVIOUS_QUERY" (
    "NETWORK_ID" NUMBER(19) NOT NULL,
    "USER_NAME" VARCHAR(256) NOT NULL,
    "DOMAIN" VARCHAR(256) NOT NULL,
    "QUERY_NAME" VARCHAR(256) NOT NULL,
    "QUERY_NOTES" VARCHAR(256),
    "QUERY_FAVED" CHAR NOT NULL check ("QUERY_FAVED" in ('1', '0')),
    "DATE_CREATED" NUMBER(19) NOT NULL,
    "DELETED" CHAR NOT NULL check ("DELETED" in ('1', '0')),
    "CHANGE_DATE" NUMBER(19) NOT NULL,
    "STATUS" VARCHAR2(256) NOT NULL,
    "QUERY_JSON" CLOB NOT NULL
);

create table "QUERY_RESULT" (
    "RESULT_ID" NUMBER(19) NOT NULL,
    "NETWORK_QUERY_ID" NUMBER(19) NOT NULL,
    "INSTANCE_ID" NUMBER(19) NOT NULL,
    "ADAPTER_NODE" VARCHAR(256) NOT NULL,
    "RESULT_TYPE" VARCHAR(256),
    "SIZE" NUMBER(19) NOT NULL,
    "START_DATE" NUMBER(19),
    "END_DATE" NUMBER(19),
    "STATUS" VARCHAR(256) NOT NULL,
    "STATUS_MESSAGE" CLOB,
    "CHANGE_DATE" NUMBER(19) NOT NULL
);

create table "QUERY_BREAKDOWN_RESULT" (
    "NETWORK_QUERY_ID" NUMBER(19) NOT NULL,
    "ADAPTER_NODE" VARCHAR(256) NOT NULL,
    "RESULT_ID" NUMBER(19) NOT NULL,
    "RESULT_TYPE" VARCHAR(256) NOT NULL,
    "DATA_KEY" VARCHAR2(2000) NULL,
    "VALUE" NUMBER(19) NOT NULL,
    "CHANGE_DATE" NUMBER(19) NOT NULL
);

create table "QUERY_RESULT_PROBLEM_DIGEST" (
    "NETWORK_QUERY_ID" NUMBER(19) NOT NULL,
    "ADAPTER_NODE" VARCHAR(256) NOT NULL,
    "CODEC" VARCHAR(256) NOT NULL,
    "STAMP" VARCHAR(256) NOT NULL,
    "SUMMARY" CLOB NOT NULL,
    "DESCRIPTION" CLOB NOT NULL,
    "DETAILS" CLOB NOT NULL,
    "CHANGE_DATE" NUMBER(19) NOT NULL
);

create table "RESULTS_OBSERVED" (
    "NETWORK_QUERY_ID" NUMBER(19) NOT NULL,
    "CHECKSUM" NUMBER(19) NOT NULL,
    "OBSERVED_TIME" NUMBER(19) NOT NULL
);
create table "QUERY_PROBLEM_DIGEST" (
    "NETWORK_QUERY_ID" NUMBER(19) NOT NULL,
    "CODEC" VARCHAR(256) NOT NULL,
    "STAMP" VARCHAR(256) NOT NULL,
    "SUMMARY" CLOB NOT NULL,
    "DESCRIPTION" CLOB NOT NULL,
    "DETAILS" CLOB NOT NULL,
    "CHANGE_DATE" NUMBER(19) NOT NULL
);

create index "queryResultsChangeDateIndex" on "QUERY_RESULT" ("CHANGE_DATE");
create index "queryResultsNetworkIdIndex" on "QUERY_RESULT" ("NETWORK_QUERY_ID");
create index "queryResultsAdapterNodeIndex" on "QUERY_RESULT" ("ADAPTER_NODE");
create index "queryResultsResultIdIndex" on "QUERY_RESULT" ("RESULT_ID");
create index "queryResultsStatusIndex" on "QUERY_RESULT" ("STATUS");

create index "queryBreakdownChangeDateIndex" on "QUERY_BREAKDOWN_RESULT" ("CHANGE_DATE");
create index "queryBreakdownQueryIdIndex" on "QUERY_BREAKDOWN_RESULT" ("NETWORK_QUERY_ID");
create index "queryBreakdownResultIdIndex" on "QUERY_BREAKDOWN_RESULT" ("RESULT_ID");

create index "previousQueriesQueryFavedIndex" on "PREVIOUS_QUERY" ("QUERY_FAVED");
create index "previousQueriesUserNameIndex" on "PREVIOUS_QUERY" ("USER_NAME");
create index "previousQueriesDomainIndex" on "PREVIOUS_QUERY" ("DOMAIN");
create index "previousQueriesChangeDateIndex" on "PREVIOUS_QUERY" ("CHANGE_DATE");
create index "previousQueriesDeletedIndex" on "PREVIOUS_QUERY" ("DELETED");
create index "previousQueriesNetworkIdIndex" on "PREVIOUS_QUERY" ("NETWORK_ID");
create index "previousQueriesDCreatedIndex" on "PREVIOUS_QUERY" ("DATE_CREATED");

create index "problemsNetworkIdIndex" on "QUERY_RESULT_PROBLEM_DIGEST" ("NETWORK_QUERY_ID");
create index "problemsAdapterNodeIndex" on "QUERY_RESULT_PROBLEM_DIGEST" ("ADAPTER_NODE");
create index "problemsChangeDateIndex" on "QUERY_RESULT_PROBLEM_DIGEST" ("CHANGE_DATE");

create index "resultsObservedQueryIdIndex" on "RESULTS_OBSERVED" ("NETWORK_QUERY_ID");
create index "resultsObservedChecksumIndex" on "RESULTS_OBSERVED" ("CHECKSUM");

create index "queryProblemsNetworkIdIndex" on "QUERY_PROBLEM_DIGEST" ("NETWORK_QUERY_ID");
