use qepAuditDB;

create table `TABLE_VERSIONS` (
  `NAME` VARCHAR(256) NOT NULL PRIMARY KEY,
  `VERSION` INT NOT NULL
);

create table `RESULTS` (
  `ID` BIGINT NOT NULL,
  `PROTOCOL_VERSION` INT NOT NULL,
  `ITEM_VERSION` INT NOT NULL,
  `CREATE_DATE` BIGINT NOT NULL,
  `CHANGE_DATE` BIGINT NOT NULL,
  `JSON` TEXT NOT NULL,
  `QUERY_ID` BIGINT NOT NULL,
  `NODE_ID` BIGINT NOT NULL,
  `STATUS` TEXT NOT NULL
);

create index RESULTS_ID_INDEX on RESULTS (ID);
create index RESULTS_ITEM_VERSION_INDEX on RESULTS (ITEM_VERSION);
create index RESULTS_CREATE_DATE_INDEX on RESULTS (CREATE_DATE);
create index RESULTS_CHANGE_DATE_INDEX on RESULTS (CHANGE_DATE);
create index RESULTS_QUERY_ID_INDEX on RESULTS (QUERY_ID);
create index RESULTS_NODE_ID_INDEX on RESULTS (NODE_ID);

create table `QUERIES` (
`ID` BIGINT NOT NULL,
`PROTOCOL_VERSION` INT NOT NULL,
`ITEM_VERSION` INT NOT NULL,
`CREATE_DATE` BIGINT NOT NULL,
`CHANGE_DATE` BIGINT NOT NULL,
`JSON` TEXT NOT NULL,
`RESEARCHER_ID` BIGINT NOT NULL,
`STATUS` TEXT NOT NULL
);

create index QUERIES_ID_INDEX on QUERIES (ID);
create index QUERIES_ITEM_VERSION_INDEX on QUERIES (ITEM_VERSION);
create index QUERIES_CREATE_DATE_INDEX on QUERIES (CREATE_DATE);
create index QUERIES_CHANGE_DATE_INDEX on QUERIES (CHANGE_DATE);
create index QUERIES_RESEARCHER_ID_INDEX on QUERIES (RESEARCHER_ID);

create table `NODES` (
`ID` BIGINT NOT NULL,
`PROTOCOL_VERSION` INT NOT NULL,
`ITEM_VERSION` INT NOT NULL,
`CREATE_DATE` BIGINT NOT NULL,
`CHANGE_DATE` BIGINT NOT NULL,
`JSON` TEXT NOT NULL,
`KEY` TEXT NOT NULL
);

create table `NODE_SYSTEM_SPECS` (
`ID` BIGINT NOT NULL,
`PROTOCOL_VERSION` INT NOT NULL,
`ITEM_VERSION` INT NOT NULL,
`CREATE_DATE` BIGINT NOT NULL,
`CHANGE_DATE` BIGINT NOT NULL,
`JSON` TEXT NOT NULL,
`KEY` TEXT NOT NULL
);

create index NODES_ID_INDEX on NODES (ID);
create index NODES_ITEM_VERSION_INDEX on NODES (ITEM_VERSION);
create index NODES_CREATE_DATE_INDEX on NODES (CREATE_DATE);
create index NODES_CHANGE_DATE_INDEX on NODES (CHANGE_DATE);
-- todo can this be indexed in mysql? Do we have to move away from the text type? create index NODES_KEY_INDEX on NODES (KEY);

create table `NETWORKS` (
`ID` BIGINT NOT NULL,
`PROTOCOL_VERSION` INT NOT NULL,
`ITEM_VERSION` INT NOT NULL,
`CREATE_DATE` BIGINT NOT NULL,
`CHANGE_DATE` BIGINT NOT NULL,
`JSON` TEXT NOT NULL
);

create index NETWORKS_ID_INDEX on NETWORKS (ID);
create index NETWORKS_ITEM_VERSION_INDEX on NETWORKS (ITEM_VERSION);
create index NETWORKS_CREATE_DATE_INDEX on NETWORKS (CREATE_DATE);
create index NETWORKS_CHANGE_DATE_INDEX on NETWORKS (CHANGE_DATE);

create table `RESEARCHERS` (
`ID` BIGINT NOT NULL,
`PROTOCOL_VERSION` INT NOT NULL,
`ITEM_VERSION` INT NOT NULL,
`CREATE_DATE` BIGINT NOT NULL,
`CHANGE_DATE` BIGINT NOT NULL,
`JSON` TEXT NOT NULL
);

create index RESEARCHERS_ID_INDEX on RESEARCHERS (ID);
create index RESEARCHERS_ITEM_VERSION_INDEX on RESEARCHERS (ITEM_VERSION);
create index RESEARCHERS_CREATE_DATE_INDEX on RESEARCHERS (CREATE_DATE);
create index RESEARCHERS_CHANGE_DATE_INDEX on RESEARCHERS (CHANGE_DATE);