/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.sameas4j;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Equivalence
implements Iterable<URI> {
    private final Set<URI> duplicates = new HashSet<URI>();
    private final URI uri;

    protected Equivalence(URI uri) {
        this.uri = uri;
    }

    protected Equivalence(URL url) throws URISyntaxException {
        this.uri = url.toURI();
    }

    public URI getUri() {
        return this.uri;
    }

    public int getAmount() {
        return this.duplicates.size();
    }

    @Override
    public Iterator<URI> iterator() {
        return this.duplicates.iterator();
    }

    protected void addDuplicate(URI uri) {
        this.duplicates.add(uri);
    }

    public String toString() {
        return String.format("Equivalence { uri: %s, amount: %s, duplicates: %s }", this.uri, this.getAmount(), this.duplicates);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.uri.equals(((Equivalence)object).getUri());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

