/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.sameas4j;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nnsoft.sameas4j.Equivalence;
import org.nnsoft.sameas4j.EquivalenceDeserializer;
import org.nnsoft.sameas4j.EquivalenceList;
import org.nnsoft.sameas4j.EquivalenceListDeserializer;
import org.nnsoft.sameas4j.SameAsService;
import org.nnsoft.sameas4j.SameAsServiceException;
import org.nnsoft.sameas4j.cache.Cache;
import org.nnsoft.sameas4j.cache.CacheKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SameAsServiceImpl
implements SameAsService {
    private static final String SERVICE_URL = "http://sameas.org/json?uri=%s";
    private static final String SERVICE_KEYWORD = "http://sameas.org/json?q=%s";
    private final GsonBuilder gsonBuilder = new GsonBuilder();
    private final Lock lock = new ReentrantLock();
    private Cache cache;

    public SameAsServiceImpl() {
        this.gsonBuilder.registerTypeAdapter(Equivalence.class, (Object)new EquivalenceDeserializer());
        this.gsonBuilder.registerTypeAdapter(EquivalenceList.class, (Object)new EquivalenceListDeserializer());
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Equivalence getDuplicates(URI uri) throws SameAsServiceException {
        return this.invokeURL(String.format(SERVICE_URL, uri), Equivalence.class);
    }

    @Override
    public EquivalenceList getDuplicates(String keyword) throws SameAsServiceException {
        return this.invokeURL(String.format(SERVICE_KEYWORD, keyword), EquivalenceList.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T invokeURL(String toBeInvoked, Class<T> returnType) throws SameAsServiceException {
        URL url;
        try {
            url = new URL(toBeInvoked);
        }
        catch (MalformedURLException e) {
            throw new SameAsServiceException("An error occurred while building the URL '" + toBeInvoked + "'");
        }
        URLConnection connection = null;
        Reader reader = null;
        if (this.cache != null) {
            this.lock.lock();
        }
        try {
            CacheKey cacheKey;
            T cached;
            connection = url.openConnection();
            long lastModified = connection.getLastModified();
            if (this.cache != null && (cached = this.cache.get(cacheKey = new CacheKey(toBeInvoked, lastModified), returnType)) != null) {
                T t = cached;
                return t;
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).connect();
            }
            reader = new InputStreamReader(connection.getInputStream());
            Gson gson = this.gsonBuilder.create();
            Object response = gson.fromJson(reader, returnType);
            if (this.cache != null) {
                CacheKey cacheKey2 = new CacheKey(toBeInvoked, lastModified);
                this.cache.put(cacheKey2, response);
            }
            Object object = response;
            return (T)object;
        }
        catch (IOException e) {
            throw new SameAsServiceException(String.format("An error occurred while invoking the URL '%s': %s", toBeInvoked, e.getMessage()));
        }
        catch (JsonParseException e) {
            throw new SameAsServiceException("An error occurred while parsing the JSON response", (Exception)((Object)e));
        }
        finally {
            if (this.cache != null) {
                this.lock.unlock();
            }
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

