/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.surefire.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.junit4.JUnit4TestSet;
import org.apache.maven.surefire.junit4.JUnit4TestSetReporter;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4Provider
implements SurefireProvider {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private final ReporterFactory reporterFactory;
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final List<RunListener> customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private TestsToRun testsToRun;

    public JUnit4Provider(ProviderParameters booterParameters) {
        this.reporterFactory = booterParameters.getReporterFactory();
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.customRunListeners = this.createCustomListeners(booterParameters.getProviderProperties().getProperty("listener"));
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        this.upgradeCheck();
        JUnit4TestSetReporter jUnit4TestSetReporter = new JUnit4TestSetReporter(null, null);
        RunNotifier runNotifer = this.getRunNotifer(jUnit4TestSetReporter, this.customRunListeners);
        for (Class clazz : this.testsToRun.getLocatedClasses()) {
            ReporterManager reporter = (ReporterManager)this.reporterFactory.createReporter();
            jUnit4TestSetReporter.setTestSet(clazz);
            jUnit4TestSetReporter.setReportMgr(reporter);
            this.executeTestSet(clazz, reporter, this.testClassLoader, runNotifer);
        }
        this.closeRunNotifer(jUnit4TestSetReporter, this.customRunListeners);
        return this.reporterFactory.close();
    }

    private RunNotifier getRunNotifer(RunListener main, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.addListener(main);
        for (RunListener listener : others) {
            fNotifier.addListener(listener);
        }
        return fNotifier;
    }

    private void closeRunNotifer(RunListener main, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.removeListener(main);
        for (RunListener listener : others) {
            fNotifier.removeListener(listener);
        }
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    private void executeTestSet(Class clazz, ReporterManager reporter, ClassLoader classLoader, RunNotifier listeners) throws ReporterException, TestSetFailedException {
        String rawString = bundle.getString("testSetStarting");
        DefaultReportEntry report = new DefaultReportEntry(this.getClass().getName(), clazz.getName(), rawString);
        reporter.testSetStarting((ReportEntry)report);
        JUnit4TestSet.execute(clazz, listeners);
        rawString = bundle.getString("testSetCompletedNormally");
        report = new DefaultReportEntry(this.getClass().getName(), clazz.getName(), rawString);
        reporter.testSetCompleted((ReportEntry)report);
        reporter.reset();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, (ScannerFilter)this.jUnit4TestChecker);
    }

    private void upgradeCheck() throws TestSetFailedException {
        if (this.isJunit4UpgradeCheck() && ((DefaultDirectoryScanner)this.directoryScanner).getClassesSkippedByValidation().size() > 0) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : ((DefaultDirectoryScanner)this.directoryScanner).getClassesSkippedByValidation()) {
                reason.append("   ");
                reason.append(testClass.getCanonicalName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    private boolean isJunit4UpgradeCheck() {
        String property = System.getProperty("surefire.junit4.upgradecheck");
        return property != null;
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    private List<RunListener> createCustomListeners(String listenerProperty) {
        LinkedList<RunListener> result = new LinkedList<RunListener>();
        if (listenerProperty == null) {
            return result;
        }
        for (String thisListenerName : listenerProperty.split(",")) {
            RunListener customRunListener = (RunListener)ReflectionUtils.instantiate((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)thisListenerName);
            result.add(customRunListener);
        }
        return result;
    }
}

