/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.cargo.ant.ConfigurationElement;
import org.codehaus.cargo.ant.PropertySet;
import org.codehaus.cargo.ant.ZipURLInstallerElement;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.util.log.AntLogger;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;

public class CargoTask
extends Task {
    private static final String ACTION_START = "start";
    private static final String ACTION_STOP = "stop";
    private String action;
    private String id;
    private Reference refid;
    private String containerId;
    private ContainerType containerType = ContainerType.INSTALLED;
    private Map systemProperties = new HashMap();
    private Path extraClasspath;
    private Path sharedClasspath;
    private String output;
    private File log;
    private LogLevel logLevel;
    private boolean append;
    private String home;
    private long timeout;
    private ZipURLInstallerElement zipURLInstallerElement;
    private ConfigurationElement configurationElement;
    private ContainerFactory factory = new DefaultContainerFactory();
    private Class containerClass;
    private Container container;
    private Logger logger;
    private boolean wait = true;

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean getWait() {
        return this.wait;
    }

    public final void setClass(Class containerClass) {
        this.containerClass = containerClass;
    }

    protected final Class getContainerClass() {
        return this.containerClass;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setType(ContainerType type) {
        this.containerType = type;
    }

    public void setHint(String hint) {
        throw new BuildException("The \"hint\" attribute has been removed. You should use the \"type\" attribute instead.");
    }

    public final void setHome(String home) {
        this.home = home;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setRefId(Reference refid) {
        this.refid = refid;
    }

    public final ZipURLInstallerElement createZipURLInstaller() {
        if (this.getZipURLInstaller() == null) {
            this.zipURLInstallerElement = new ZipURLInstallerElement();
        }
        return this.zipURLInstallerElement;
    }

    public final ConfigurationElement createConfiguration() {
        if (this.getConfiguration() == null) {
            this.configurationElement = new ConfigurationElement();
        }
        return this.configurationElement;
    }

    public final void setOutput(String output) {
        this.output = output;
    }

    public final void setLog(File log) {
        this.log = log;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.toLevel((String)logLevel);
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Path createExtraClasspath() {
        if (this.getExtraClasspath() == null) {
            this.extraClasspath = new Path(this.getProject());
        }
        return this.extraClasspath.createPath();
    }

    public Path createSharedClasspath() {
        if (this.getSharedClasspath() == null) {
            this.sharedClasspath = new Path(this.getProject());
        }
        return this.sharedClasspath.createPath();
    }

    public void addSysproperty(Environment.Variable property) {
        this.getSystemProperties().put(property.getKey(), property.getValue());
    }

    public void addConfiguredSyspropertyset(PropertySet propertySet) {
        ResourceBundle bundle = propertySet.readProperties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Environment.Variable var = new Environment.Variable();
            var.setKey(key);
            var.setValue(bundle.getString(key));
            this.addSysproperty(var);
        }
    }

    public void addConfiguredSysproperty(Environment.Variable property) {
        this.addSysproperty(property);
    }

    private void createCargoLogger() {
        this.logger = this.getLog() != null ? new FileLogger(this.getLog(), false) : new AntLogger(this.getProject());
        if (this.getLogLevel() != null) {
            this.logger.setLevel(this.getLogLevel());
        }
    }

    public void execute() {
        this.container = this.makeContainer();
        this.verify();
        this.setupLogger();
        if (this.getContainer().getType().isLocal()) {
            this.setupOutput();
            this.setupTimeout();
            if (this.getContainer().getType() == ContainerType.INSTALLED) {
                this.setupHome();
                this.setupExtraClasspath();
                this.setupSharedClasspath();
                this.setupSystemProperties();
            }
        }
        if (this.getId() != null) {
            this.getProject().addReference(this.getId(), (Object)this.getContainer());
        }
        this.executeActions();
    }

    protected void executeActions() {
        if (this.getAction() != null) {
            if (!this.getContainer().getType().isLocal()) {
                throw new BuildException("Only local containers can execute actions");
            }
            if (this.getAction().equalsIgnoreCase(ACTION_START)) {
                ((LocalContainer)this.getContainer()).start();
                if (this.getWait()) {
                    this.log("Press Ctrl-C to stop the container...");
                    ContainerUtils.waitTillContainerIsStopped((Container)this.getContainer());
                }
            } else if (this.getAction().equalsIgnoreCase(ACTION_STOP)) {
                ((LocalContainer)this.getContainer()).stop();
            }
        }
    }

    protected void setupLogger() {
        this.getContainer().setLogger(this.getLogger());
        if (this.getContainer().getType().isLocal()) {
            ((LocalContainer)this.getContainer()).getConfiguration().setLogger(this.getLogger());
        } else {
            ((RemoteContainer)this.getContainer()).getConfiguration().setLogger(this.getLogger());
        }
    }

    protected void setupOutput() {
        if (this.getOutput() != null) {
            ((LocalContainer)this.getContainer()).setOutput(this.getOutput());
        }
        if (this.isAppend()) {
            ((LocalContainer)this.getContainer()).setAppend(true);
        }
    }

    protected void setupTimeout() {
        if (this.getTimeout() != 0L && this.getTimeout() != ((LocalContainer)this.getContainer()).getTimeout()) {
            ((LocalContainer)this.getContainer()).setTimeout(this.getTimeout());
        }
    }

    protected void setupHome() {
        if (this.getHome() != null) {
            ((InstalledLocalContainer)this.getContainer()).setHome(this.getHome());
        } else if (this.getZipURLInstaller() != null) {
            ZipURLInstaller installer = this.getZipURLInstaller().createInstaller();
            installer.setLogger(this.getContainer().getLogger());
            installer.install();
            ((InstalledLocalContainer)this.getContainer()).setHome(installer.getHome());
        }
    }

    protected void setupExtraClasspath() {
        if (this.getExtraClasspath() != null) {
            ((InstalledLocalContainer)this.getContainer()).setExtraClasspath(this.getExtraClasspath().list());
        }
    }

    protected void setupSharedClasspath() {
        if (this.getSharedClasspath() != null) {
            ((InstalledLocalContainer)this.getContainer()).setSharedClasspath(this.getSharedClasspath().list());
        }
    }

    protected void setupSystemProperties() {
        if (!this.getSystemProperties().isEmpty()) {
            ((InstalledLocalContainer)this.getContainer()).setSystemProperties(this.getSystemProperties());
        }
    }

    protected final Map getSystemProperties() {
        return this.systemProperties;
    }

    protected final ZipURLInstallerElement getZipURLInstaller() {
        return this.zipURLInstallerElement;
    }

    protected final ConfigurationElement getConfiguration() {
        return this.configurationElement;
    }

    protected final Path getExtraClasspath() {
        return this.extraClasspath;
    }

    protected final Path getSharedClasspath() {
        return this.sharedClasspath;
    }

    protected final long getTimeout() {
        return this.timeout;
    }

    protected final String getOutput() {
        return this.output;
    }

    protected final File getLog() {
        return this.log;
    }

    protected LogLevel getLogLevel() {
        return this.logLevel;
    }

    protected final String getHome() {
        return this.home;
    }

    protected final boolean isAppend() {
        return this.append;
    }

    protected final String getAction() {
        return this.action;
    }

    protected Container makeContainer() {
        Container container;
        if (this.getRefid() != null) {
            Object o = this.getContainerReference();
            if (!(o instanceof Container)) {
                throw new BuildException("The [refid] attribute must point to a container reference, it is pointing to a [" + o.getClass().getName() + "] object");
            }
            container = (Container)o;
            this.logger = container.getLogger();
        } else {
            if (this.getConfiguration() == null) {
                throw new BuildException("Missing mandatory [configuration] element.");
            }
            if (this.getContainerClass() != null) {
                this.factory.registerContainer(this.containerId, this.containerType, this.getContainerClass());
            }
            container = this.factory.createContainer(this.containerId, this.containerType, this.getConfiguration().createConfiguration(this.containerId, this.containerType));
            this.createCargoLogger();
        }
        return container;
    }

    private Object getContainerReference() {
        Object o;
        try {
            o = this.getRefid().getReferencedObject(this.getProject());
        }
        catch (BuildException e) {
            throw new BuildException("The [" + this.getRefid().getRefId() + "] reference does not " + "exist. You must first define a Cargo container reference.", (Throwable)e);
        }
        return o;
    }

    protected String getContainerId() {
        return this.containerId;
    }

    protected String getId() {
        return this.id;
    }

    protected Reference getRefid() {
        return this.refid;
    }

    private void verify() {
        if (this.getId() != null && this.getRefid() != null) {
            throw new BuildException("You must use either [id] or [refid] but not both");
        }
        if (this.getContainerId() == null && this.getRefid() == null) {
            throw new BuildException("You must specify a [containerId] attribute or use a [refid] attribute");
        }
        if (this.getId() == null && this.getAction() == null) {
            throw new BuildException("You must specify an [action] attribute with values [start] or [stop]");
        }
        if (this.getAction() != null && !this.getAction().equalsIgnoreCase(ACTION_START) && !this.getAction().equalsIgnoreCase(ACTION_STOP)) {
            throw new BuildException("Valid actions are: [start] and [stop]");
        }
        if (this.getHome() == null && this.getZipURLInstaller() == null) {
            boolean doFail = false;
            if (this.getRefid() == null) {
                doFail = true;
            } else if (this.getContainer().getType() == ContainerType.INSTALLED && ((InstalledLocalContainer)this.getContainer()).getHome() == null) {
                doFail = true;
            }
            if (doFail) {
                throw new BuildException("You must specify either a [home] attribute pointing to the location where the " + this.getContainer().getName() + " is installed, or a nested [zipurlinstaller] element");
            }
        }
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.factory = containerFactory;
    }

    protected Container getContainer() {
        return this.container;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

