/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.ant.DeployableElement;
import org.codehaus.cargo.ant.Property;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configfile;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;

public class ConfigurationElement {
    private ConfigurationType type = ConfigurationType.STANDALONE;
    private String home;
    private List properties = new ArrayList();
    private Class configurationClass;
    private List deployables = new ArrayList();
    private List configfiles = new ArrayList();

    public final void setClass(Class configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected final Class getConfigurationClass() {
        return this.configurationClass;
    }

    public void addConfiguredDeployable(DeployableElement deployableElement) {
        this.deployables.add(deployableElement);
    }

    protected final List getDeployables() {
        return this.deployables;
    }

    public void addConfiguredConfigfile(Configfile configfileElement) {
        this.configfiles.add(configfileElement);
    }

    protected final List getConfigfiles() {
        return this.configfiles;
    }

    protected final List getProperties() {
        return this.properties;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    public final void setType(String typeAsString) {
        this.type = ConfigurationType.toType((String)typeAsString);
    }

    public final void setHome(String home) {
        this.home = home;
    }

    public final ConfigurationType getType() {
        return this.type;
    }

    public final String getHome() {
        return this.home;
    }

    public Configuration createConfiguration(String containerId, ContainerType containerType) {
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getConfigurationClass() != null) {
            factory.registerConfiguration(containerId, containerType, this.getType(), this.getConfigurationClass());
        }
        Configuration configuration = this.getHome() == null ? factory.createConfiguration(containerId, containerType, this.getType()) : factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        Iterator itProperties = this.getProperties().iterator();
        while (itProperties.hasNext()) {
            Property property = (Property)itProperties.next();
            configuration.setProperty(property.getName(), property.getValue());
        }
        if (configuration instanceof LocalConfiguration) {
            this.addStaticDeployables(containerId, (LocalConfiguration)configuration);
        }
        if (configuration instanceof StandaloneLocalConfiguration && this.getConfigfiles() != null) {
            for (int i = 0; i < this.getConfigfiles().size(); ++i) {
                Configfile configfile = (Configfile)this.getConfigfiles().get(i);
                ((StandaloneLocalConfiguration)configuration).setFileProperty(configfile.getFile(), configfile.getToFile(), configfile.getToDir());
            }
        }
        return configuration;
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration) {
        Iterator deps = this.getDeployables().iterator();
        while (deps.hasNext()) {
            DeployableElement deployableElement = (DeployableElement)deps.next();
            configuration.addDeployable(deployableElement.createDeployable(containerId));
        }
    }
}

