/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten.cifriendly;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.MavenBuildTimestamp;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.codehaus.mojo.flatten.cifriendly.CiInterpolator;
import org.codehaus.mojo.flatten.cifriendly.CiInterpolatorImpl;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.util.ValueSourceUtils;

@Named
@Singleton
public class CiModelInterpolator
implements CiInterpolator {
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("pom.", "project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    private static final Map<Class<?>, InterpolateObjectAction.CacheItem> CACHED_ENTRIES;
    private final Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;
    private final PathTranslator pathTranslator;
    private final UrlNormalizer urlNormalizer;

    @Inject
    public CiModelInterpolator(PathTranslator pathTranslator, UrlNormalizer urlNormalizer) {
        this.pathTranslator = pathTranslator;
        this.urlNormalizer = urlNormalizer;
        this.interpolator = this.createInterpolator();
        this.recursionInterceptor = new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);
    }

    @Override
    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        this.interpolateObject(model, model, projectDir, config, problems);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interpolateObject(Object obj, Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        try {
            List<ValueSource> valueSources = this.createValueSources(model, projectDir, config, problems);
            List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
            new InterpolateObjectAction(obj, valueSources, postProcessors, this, problems).run();
        }
        finally {
            this.getInterpolator().clearAnswers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String interpolateInternal(String src, List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, ModelProblemCollector problems) {
        if (!(src == null || src.contains("${revision}") || src.contains("${sha1}") || src.contains("${changelist}"))) {
            return src;
        }
        String result = src;
        CiModelInterpolator ciModelInterpolator = this;
        synchronized (ciModelInterpolator) {
            for (ValueSource valueSource : valueSources) {
                this.getInterpolator().addValueSource(valueSource);
            }
            for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
                this.getInterpolator().addPostProcessor(interpolationPostProcessor);
            }
            try {
                try {
                    result = this.getInterpolator().interpolate(result, this.getRecursionInterceptor());
                }
                catch (InterpolationException e) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(e.getMessage()).setException((Exception)((Object)e)));
                }
                this.getInterpolator().clearFeedback();
            }
            finally {
                for (ValueSource valueSource : valueSources) {
                    this.getInterpolator().removeValuesSource(valueSource);
                }
                for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
                    this.getInterpolator().removePostProcessor(interpolationPostProcessor);
                }
            }
        }
        return result;
    }

    protected Interpolator createInterpolator() {
        CiInterpolatorImpl interpolator = new CiInterpolatorImpl();
        interpolator.setCacheAnswers(true);
        return interpolator;
    }

    protected List<ValueSource> createValueSources(Model model, final File projectDir, final ModelBuildingRequest config, ModelProblemCollector problems) {
        Properties modelProperties = model.getProperties();
        Object modelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, (Object)model, false);
        if (config.getValidationLevel() >= 20) {
            modelValueSource1 = new ProblemDetectingValueSource((ValueSource)modelValueSource1, "pom.", "project.", problems);
        }
        Object modelValueSource2 = new ObjectBasedValueSource((Object)model);
        if (config.getValidationLevel() >= 20) {
            modelValueSource2 = new ProblemDetectingValueSource((ValueSource)modelValueSource2, "", "project.", problems);
        }
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return projectDir.getAbsolutePath();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, true);
            valueSources.add((ValueSource)basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("baseUri".equals(expression)) {
                        return projectDir.getAbsoluteFile().toURI().toString();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, false);
            valueSources.add((ValueSource)baseUriValueSource);
            valueSources.add((ValueSource)new BuildTimestampValueSource(config.getBuildStartTime(), modelProperties));
        }
        valueSources.add((ValueSource)modelValueSource1);
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getUserProperties()));
        valueSources.add((ValueSource)new MapBasedValueSource((Map)modelProperties));
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getSystemProperties()));
        valueSources.add((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return config.getSystemProperties().getProperty("env." + expression);
            }
        });
        valueSources.add((ValueSource)modelValueSource2);
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(Model model, File projectDir, ModelBuildingRequest config) {
        ArrayList<Object> processors = new ArrayList<Object>(2);
        if (projectDir != null) {
            processors.add(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        processors.add(new UrlNormalizingPostProcessor(this.urlNormalizer));
        return processors;
    }

    protected RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    protected void setRecursionInterceptor(RecursionInterceptor recursionInterceptor) {
        this.recursionInterceptor = recursionInterceptor;
    }

    protected final Interpolator getInterpolator() {
        return this.interpolator;
    }

    static {
        CACHED_ENTRIES = new ConcurrentHashMap(80, 0.75f, 2);
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }

    private static final class InterpolateObjectAction
    implements Runnable {
        private final LinkedList<Object> interpolationTargets;
        private final CiModelInterpolator modelInterpolator;
        private final List<? extends ValueSource> valueSources;
        private final List<? extends InterpolationPostProcessor> postProcessors;
        private final ModelProblemCollector problems;

        InterpolateObjectAction(Object target, List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, CiModelInterpolator modelInterpolator, ModelProblemCollector problems) {
            this.valueSources = valueSources;
            this.postProcessors = postProcessors;
            this.interpolationTargets = new LinkedList();
            this.interpolationTargets.add(target);
            this.modelInterpolator = modelInterpolator;
            this.problems = problems;
        }

        @Override
        public void run() {
            while (!this.interpolationTargets.isEmpty()) {
                Object obj = this.interpolationTargets.removeFirst();
                this.traverseObjectWithParents(obj.getClass(), obj);
            }
        }

        private String interpolate(String value) {
            return this.modelInterpolator.interpolateInternal(value, this.valueSources, this.postProcessors, this.problems);
        }

        private void traverseObjectWithParents(Class<?> cls, Object target) {
            if (cls == null) {
                return;
            }
            CacheItem cacheEntry = this.getCacheEntry(cls);
            if (cacheEntry.isArray()) {
                InterpolateObjectAction.evaluateArray(target, this);
            } else if (cacheEntry.isQualifiedForInterpolation) {
                cacheEntry.interpolate(target, this);
                this.traverseObjectWithParents(cls.getSuperclass(), target);
            }
        }

        private CacheItem getCacheEntry(Class<?> cls) {
            CacheItem cacheItem = (CacheItem)CACHED_ENTRIES.get(cls);
            if (cacheItem == null) {
                cacheItem = new CacheItem(cls);
                CACHED_ENTRIES.put(cls, cacheItem);
            }
            return cacheItem;
        }

        private static void evaluateArray(Object target, InterpolateObjectAction ctx) {
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(target, i);
                if (value == null) continue;
                if (String.class == value.getClass()) {
                    String interpolated = ctx.interpolate((String)value);
                    if (interpolated.equals(value)) continue;
                    Array.set(target, i, interpolated);
                    continue;
                }
                ctx.interpolationTargets.add(value);
            }
        }

        private static class CacheItem {
            private final boolean isArray;
            private final boolean isQualifiedForInterpolation;
            private final CacheField[] fields;

            private boolean isQualifiedForInterpolation(Class<?> cls) {
                return !cls.getName().startsWith("java");
            }

            private boolean isQualifiedForInterpolation(Field field, Class<?> fieldType) {
                if (Map.class.equals(fieldType) && "locations".equals(field.getName())) {
                    return false;
                }
                if (fieldType.isPrimitive()) {
                    return false;
                }
                return !"parent".equals(field.getName());
            }

            CacheItem(Class clazz) {
                this.isQualifiedForInterpolation = this.isQualifiedForInterpolation(clazz);
                this.isArray = clazz.isArray();
                ArrayList<CacheField> fields = new ArrayList<CacheField>();
                for (Field currentField : clazz.getDeclaredFields()) {
                    Class<?> type = currentField.getType();
                    if (!this.isQualifiedForInterpolation(currentField, type)) continue;
                    if (String.class == type) {
                        if (Modifier.isFinal(currentField.getModifiers())) continue;
                        fields.add(new StringField(currentField));
                        continue;
                    }
                    if (List.class.isAssignableFrom(type)) {
                        fields.add(new ListField(currentField));
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(type)) {
                        throw new RuntimeException("We dont interpolate into collections, use a list instead");
                    }
                    if (Map.class.isAssignableFrom(type)) {
                        fields.add(new MapField(currentField));
                        continue;
                    }
                    fields.add(new ObjectField(currentField));
                }
                this.fields = fields.toArray(new CacheField[0]);
            }

            public void interpolate(Object target, InterpolateObjectAction interpolateObjectAction) {
                for (CacheField field : this.fields) {
                    field.interpolate(target, interpolateObjectAction);
                }
            }

            public boolean isArray() {
                return this.isArray;
            }
        }

        static final class ObjectField
        extends CacheField {
            private final boolean isArray;

            ObjectField(Field field) {
                super(field);
                this.isArray = field.getType().isArray();
            }

            @Override
            void doInterpolate(Object target, InterpolateObjectAction ctx) throws IllegalAccessException {
                Object value = this.field.get(target);
                if (value != null) {
                    if (this.isArray) {
                        InterpolateObjectAction.evaluateArray(value, ctx);
                    } else {
                        ctx.interpolationTargets.add(value);
                    }
                }
            }
        }

        static final class MapField
        extends CacheField {
            MapField(Field field) {
                super(field);
            }

            @Override
            void doInterpolate(Object target, InterpolateObjectAction ctx) throws IllegalAccessException {
                Map m = (Map)this.field.get(target);
                if (m == null || m.isEmpty()) {
                    return;
                }
                for (Map.Entry entry : m.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    if (String.class == value.getClass()) {
                        String interpolated = ctx.interpolate((String)value);
                        if (interpolated.equals(value)) continue;
                        try {
                            entry.setValue(interpolated);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {}
                        continue;
                    }
                    if (value.getClass().isArray()) {
                        InterpolateObjectAction.evaluateArray(value, ctx);
                        continue;
                    }
                    ctx.interpolationTargets.add(value);
                }
            }
        }

        static final class ListField
        extends CacheField {
            ListField(Field field) {
                super(field);
            }

            @Override
            void doInterpolate(Object target, InterpolateObjectAction ctx) throws IllegalAccessException {
                List c = (List)this.field.get(target);
                if (c == null) {
                    return;
                }
                int size = c.size();
                for (int i = 0; i < size; ++i) {
                    Object value = c.get(i);
                    if (value == null) continue;
                    if (String.class == value.getClass()) {
                        String interpolated = ctx.interpolate((String)value);
                        if (interpolated.equals(value)) continue;
                        try {
                            c.set(i, interpolated);
                            continue;
                        }
                        catch (UnsupportedOperationException e) {
                            return;
                        }
                    }
                    if (value.getClass().isArray()) {
                        InterpolateObjectAction.evaluateArray(value, ctx);
                        continue;
                    }
                    ctx.interpolationTargets.add(value);
                }
            }
        }

        static final class StringField
        extends CacheField {
            StringField(Field field) {
                super(field);
            }

            @Override
            void doInterpolate(Object target, InterpolateObjectAction ctx) throws IllegalAccessException {
                String value = (String)this.field.get(target);
                if (value == null) {
                    return;
                }
                String interpolated = ctx.interpolate(value);
                if (!interpolated.equals(value)) {
                    this.field.set(target, interpolated);
                }
            }
        }

        static abstract class CacheField {
            protected final Field field;

            CacheField(Field field) {
                this.field = field;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void interpolate(Object target, InterpolateObjectAction interpolateObjectAction) {
                Field field = this.field;
                synchronized (field) {
                    boolean isAccessible = this.field.isAccessible();
                    this.field.setAccessible(true);
                    try {
                        this.doInterpolate(target, interpolateObjectAction);
                    }
                    catch (IllegalArgumentException e) {
                        interpolateObjectAction.problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate field3: " + this.field + " on class: " + this.field.getType().getName()).setException((Exception)e));
                    }
                    catch (IllegalAccessException e) {
                        interpolateObjectAction.problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate field4: " + this.field + " on class: " + this.field.getType().getName()).setException((Exception)e));
                    }
                    finally {
                        this.field.setAccessible(isAccessible);
                    }
                }
            }

            abstract void doInterpolate(Object var1, InterpolateObjectAction var2) throws IllegalAccessException;
        }
    }

    static class ProblemDetectingValueSource
    implements ValueSource {
        private final ValueSource valueSource;
        private final String bannedPrefix;
        private final String newPrefix;
        private final ModelProblemCollector problems;

        ProblemDetectingValueSource(ValueSource valueSource, String bannedPrefix, String newPrefix, ModelProblemCollector problems) {
            this.valueSource = valueSource;
            this.bannedPrefix = bannedPrefix;
            this.newPrefix = newPrefix;
            this.problems = problems;
        }

        public Object getValue(String expression) {
            Object value = this.valueSource.getValue(expression);
            if (value != null && expression.startsWith(this.bannedPrefix)) {
                String msg = "The expression ${" + expression + "} is deprecated.";
                if (this.newPrefix != null && this.newPrefix.length() > 0) {
                    msg = msg + " Please use ${" + this.newPrefix + expression.substring(this.bannedPrefix.length()) + "} instead.";
                }
                this.problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage(msg));
            }
            return value;
        }

        public List getFeedback() {
            return this.valueSource.getFeedback();
        }

        public void clearFeedback() {
            this.valueSource.clearFeedback();
        }
    }

    static class BuildTimestampValueSource
    extends AbstractValueSource {
        private final MavenBuildTimestamp mavenBuildTimestamp;

        BuildTimestampValueSource(Date startTime, Properties properties) {
            super(false);
            this.mavenBuildTimestamp = new MavenBuildTimestamp(startTime, properties);
        }

        public Object getValue(String expression) {
            if ("build.timestamp".equals(expression) || "maven.build.timestamp".equals(expression)) {
                return this.mavenBuildTimestamp.formattedTimestamp();
            }
            return null;
        }
    }

    static class PathTranslatingPostProcessor
    implements InterpolationPostProcessor {
        private final Collection<String> unprefixedPathKeys;
        private final File projectDir;
        private final PathTranslator pathTranslator;
        private final List<String> expressionPrefixes;

        PathTranslatingPostProcessor(List<String> expressionPrefixes, Collection<String> unprefixedPathKeys, File projectDir, PathTranslator pathTranslator) {
            this.expressionPrefixes = expressionPrefixes;
            this.unprefixedPathKeys = unprefixedPathKeys;
            this.projectDir = projectDir;
            this.pathTranslator = pathTranslator;
        }

        public Object execute(String expression, Object value) {
            if (value != null && this.unprefixedPathKeys.contains(expression = ValueSourceUtils.trimPrefix((String)expression, this.expressionPrefixes, (boolean)true))) {
                return this.pathTranslator.alignToBaseDirectory(String.valueOf(value), this.projectDir);
            }
            return null;
        }
    }

    static class UrlNormalizingPostProcessor
    implements InterpolationPostProcessor {
        private UrlNormalizer normalizer;

        UrlNormalizingPostProcessor(UrlNormalizer normalizer) {
            this.normalizer = normalizer;
        }

        public Object execute(String expression, Object value) {
            HashSet<String> expressions = new HashSet<String>();
            expressions.add("project.url");
            expressions.add("project.scm.url");
            expressions.add("project.scm.connection");
            expressions.add("project.scm.developerConnection");
            expressions.add("project.distributionManagement.site.url");
            if (value != null && expressions.contains(expression)) {
                return this.normalizer.normalize(value.toString());
            }
            return null;
        }
    }
}

