/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;

public class ArtifactVersions
extends AbstractVersionDetails
implements Comparable<ArtifactVersions> {
    private final Artifact artifact;
    private final SortedSet<ArtifactVersion> versions;

    public ArtifactVersions(Artifact artifact, List<ArtifactVersion> versions) {
        this.artifact = artifact;
        this.versions = new TreeSet<ArtifactVersion>();
        this.versions.addAll(versions);
        this.setCurrentVersion(artifact.getVersion());
        this.setCurrentVersionRange(artifact.getVersionRange());
    }

    public ArtifactVersions(ArtifactVersions other) {
        this.artifact = other.artifact;
        this.versions = other.versions;
        this.setCurrentVersion(other.getCurrentVersion());
        this.setCurrentVersionRange(other.getCurrentVersionRange());
    }

    @Override
    public int compareTo(ArtifactVersions that) {
        return this == that ? 0 : Comparator.nullsLast(Comparator.comparing(ArtifactVersions::getGroupId).thenComparing(ArtifactVersions::getArtifactId).thenComparing(ArtifactVersions::getVersion)).compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactVersions)) {
            return false;
        }
        ArtifactVersions that = (ArtifactVersions)o;
        return new EqualsBuilder().append((Object)this.getArtifact().getGroupId(), (Object)that.getGroupId()).append((Object)this.getArtifact().getArtifactId(), (Object)that.getArtifact().getArtifactId()).append((Object)this.getArtifact().getVersion(), (Object)that.getArtifact().getVersion()).append((Object)this.getArtifact().getScope(), (Object)that.getArtifact().getScope()).append((Object[])this.getVersions(true), (Object[])that.getVersions(true)).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.getArtifact(), Arrays.hashCode(this.getVersions(true)));
    }

    public static boolean isVersionInRange(ArtifactVersion version, VersionRange range) {
        if (!range.containsVersion(version)) {
            return false;
        }
        for (Restriction r : range.getRestrictions()) {
            String s;
            if (!r.containsVersion(version)) continue;
            if (!r.isLowerBoundInclusive() && r.getLowerBound() != null && (s = r.getLowerBound().toString()).endsWith("-!") && version.toString().startsWith(s.substring(0, s.length() - 2))) {
                return false;
            }
            if (r.isUpperBoundInclusive() || r.getUpperBound() == null || !(s = r.getUpperBound().toString()).endsWith("-!") || !version.toString().startsWith(s.substring(0, s.length() - 2))) continue;
            return false;
        }
        return true;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getGroupId() {
        return this.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.getArtifact().getArtifactId();
    }

    public String getVersion() {
        return this.getArtifact().getVersion();
    }

    @Override
    public ArtifactVersion[] getVersions(boolean includeSnapshots) {
        return includeSnapshots ? this.versions.toArray(new ArtifactVersion[0]) : (ArtifactVersion[])this.versions.stream().filter(v -> !ArtifactUtils.isSnapshot((String)v.toString())).toArray(ArtifactVersion[]::new);
    }

    public boolean isEmpty(boolean includeSnapshots) {
        return includeSnapshots ? this.versions.isEmpty() : this.versions.stream().map(Object::toString).allMatch(ArtifactUtils::isSnapshot);
    }

    public String toString() {
        return "ArtifactVersions{artifact=" + this.artifact + ", versions=" + this.versions + '}';
    }
}

