/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIResource;
import org.eaglei.model.EIURI;

public class EIInstance
extends EIResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    EIClass instanceClass;
    Map<EIEntity, Set<EIURI>> objectProperties = new HashMap<EIEntity, Set<EIURI>>();
    Map<EIEntity, Set<String>> datatypeProperties = new HashMap<EIEntity, Set<String>>();
    Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIURI>>();
    Map<EIEntity, Set<String>> nonOntologyLiteralProperties = new HashMap<EIEntity, Set<String>>();

    private EIInstance() {
    }

    public EIInstance(EIClass instanceClass, EIEntity entity) {
        super(entity);
        assert (instanceClass != null);
        this.instanceClass = instanceClass;
    }

    public void addObjectPropertyToInstance(EIEntity property, EIURI resource) {
        Set<EIURI> pValues = this.objectProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIURI>();
            this.objectProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public void addDatattypePropertyToInstance(EIEntity property, String literal) {
        Set<String> pValues = this.datatypeProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.datatypeProperties.put(property, pValues);
        }
        pValues.add(literal);
    }

    public void addNonOntologyResourceProperty(EIEntity property, EIURI resource) {
        Set<EIURI> pValues = this.nonOntologyResourceProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIURI>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public void addNonOntologyLiteralProperty(EIEntity property, String literal) {
        Set<String> pValues = this.nonOntologyLiteralProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.nonOntologyLiteralProperties.put(property, pValues);
        }
        pValues.add(literal);
    }

    public void setObjectProperties(Map<EIEntity, Set<EIURI>> objectProperties) {
        this.objectProperties = objectProperties;
    }

    public void setDatatypeProperties(Map<EIEntity, Set<String>> datatypeProperties) {
        this.datatypeProperties = datatypeProperties;
    }

    public Map<EIEntity, Set<EIURI>> getObjectProperties() {
        return this.objectProperties;
    }

    public Map<EIEntity, Set<String>> getDatatypeProperties() {
        return this.datatypeProperties;
    }

    public EIURI getInstanceURI() {
        return this.getEntity().getURI();
    }

    public String getInstanceLabel() {
        return this.getEntity().getLabel();
    }

    public EIClass getInstanceClass() {
        return this.instanceClass;
    }

    @Override
    public String toString() {
        return this.instanceClass.toString() + " : " + this.getEntity().toString();
    }

    public Map<EIEntity, Set<EIURI>> getNonOntologyResourceProperties() {
        return this.nonOntologyResourceProperties;
    }

    public void setNonOntologyResourceProperties(Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties) {
        this.nonOntologyResourceProperties = nonOntologyResourceProperties;
    }

    public Map<EIEntity, Set<String>> getNonOntologyLiteralProperties() {
        return this.nonOntologyLiteralProperties;
    }

    public void setNonOntologyLiteralProperties(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        this.nonOntologyLiteralProperties = nonOntologyLiteralProperties;
    }

    public void setEIEntity(EIEntity entity) {
        this.setEntity(entity);
    }
}

