/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.OntModel;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.jena.EagleIOntDocumentManager;

public class EagleIOntDocumentManagerTest
extends TestCase {
    private static final Log logger = LogFactory.getLog(EagleIOntDocumentManagerTest.class);

    public void test() {
        try {
            EagleIOntDocumentManager.INSTANCE.getOntDocumentManager();
            logger.info((Object)"Initialized EagleIOntDocumentManger");
        }
        catch (Throwable t) {
            EagleIOntDocumentManagerTest.fail((String)("Error initializing EagleIOntDocumentManager: " + t.getLocalizedMessage()));
        }
        Iterator docs = EagleIOntDocumentManager.INSTANCE.getOntDocumentManager().listDocuments();
        EagleIOntDocumentManagerTest.assertNotNull((String)"EagleIOntDocumentManager returned a null list of documents", (Object)docs);
        EagleIOntDocumentManagerTest.assertTrue((String)"EagleIOntDocumentManager returned an empty list of documents", (boolean)docs.hasNext());
        while (docs.hasNext()) {
            logger.info((Object)("Document: " + (String)docs.next()));
        }
        try {
            OntModel model = EagleIOntDocumentManager.INSTANCE.getOntModel("http://eagle-i.org/ont/app/1.0/");
            if (model == null) {
                EagleIOntDocumentManagerTest.fail((String)"Error loading http://eagle-i.org/ont/app/1.0/");
            } else {
                List classList = model.listClasses().toList();
                logger.info((Object)("Number of classes in http://eagle-i.org/ont/app/1.0/: " + classList.size()));
            }
        }
        catch (Throwable t) {
            EagleIOntDocumentManagerTest.fail((String)("Error loading http://eagle-i.org/ont/app/1.0/: " + t.getLocalizedMessage()));
        }
    }
}

