/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class JenaEIOntModelTest
extends TestCase {
    private static final Log logger = LogFactory.getLog(JenaEIOntModel.class);
    private static final String PIG_URI = "http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10141";

    public void testGetPreferredLabel() {
        EIURI uri = EIURI.create((String)PIG_URI);
        String prefLabel = JenaEIOntModel.INSTANCE.getPreferredLabel(uri);
        logger.info((Object)("Preferred label for http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10141:" + prefLabel));
        JenaEIOntModelTest.assertTrue((prefLabel != null && !prefLabel.isEmpty() ? 1 : 0) != 0);
    }

    public void testGetPreferredLabelNoValue() {
        String uriString = "http://www.geneontology.org/formats/oboInOwl#DbXref";
        EIURI uri = EIURI.create((String)uriString);
        String prefLabel = JenaEIOntModel.INSTANCE.getPreferredLabel(uri);
        logger.info((Object)("Preferred label for " + uriString + ":" + prefLabel));
        JenaEIOntModelTest.assertTrue((prefLabel == null ? 1 : 0) != 0);
    }

    public void testGetLabels() {
        EIURI uri = EIURI.create((String)PIG_URI);
        List labels = JenaEIOntModel.INSTANCE.getLabels(uri);
        JenaEIOntModelTest.assertTrue((labels != null ? 1 : 0) != 0);
        JenaEIOntModelTest.assertTrue((labels.size() == 2 ? 1 : 0) != 0);
        for (String label : labels) {
            logger.info((Object)("Label for http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10141:" + label));
        }
    }
}

