/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.AcceptanceCheckVisitor;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.model.jena.NonResourceVisitor;

public class OntologyAcceptanceCheck
extends TestCase {
    private static final Log logger = LogFactory.getLog(OntologyAcceptanceCheck.class);

    public void testDataModelTraversal() {
        JenaEIOntModel model = JenaEIOntModel.INSTANCE;
        ArrayList<Object> visitors = new ArrayList<Object>();
        AcceptanceCheckVisitor log = new AcceptanceCheckVisitor((EIOntModel)model);
        visitors.add(log);
        NonResourceVisitor nonres = new NonResourceVisitor(model);
        visitors.add(nonres);
        model.traverseDataModel(visitors);
        String errorMsg = nonres.traversalComplete();
        if (errorMsg != null) {
            OntologyAcceptanceCheck.fail((String)errorMsg);
        } else {
            logger.info((Object)"No errors in non-resource class list generation.");
        }
        errorMsg = log.traversalComplete();
        if (errorMsg != null) {
            OntologyAcceptanceCheck.fail((String)errorMsg);
        } else {
            logger.info((Object)"No errors in the owl acceptance test.");
        }
    }
}

