package org.eaglei.datatools.jena;

import java.util.List;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class RDFUtil {

	public static Resource getResourceOfTypeWIthLabel(Model rdfModel, RDFNode objectNode,String label) throws NullPointerException {

		
		List<Resource> rList = rdfModel.listResourcesWithProperty(RDF.type,
				objectNode).toList();
		for (Resource r : rList) {
			if (r.hasLiteral(RDFS.label, label)) {
				return r;
			}
		}

		return null;

	}
}