/**
 * 
 */
package org.eaglei.datatools;

import java.io.Serializable;

import java.util.List;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

/**
 * When user logs in the this object will be created with all the need user
 * Information filled
 * 
 * @author Sravan Cheriyala
 * 
 */
public class User implements Serializable {

	/**
	 * 
	 */
	private static final long	serialVersionUID	= 1L;

	private String				userName;

	private EIURI				userURI;
	private Session				session;
	private List<Workspace>		workspaces;
	private List<EIURI>			WFSStateList;

	public User(final String userName, final EIURI userURI, final List<EIURI> WFSStateList){
		this.userName = userName;
		this.userURI = userURI;
		this.WFSStateList = WFSStateList;
	}

	public User(final String userName, final EIURI userURI, final List<EIURI> WFSStateList, List<Workspace> workspaces) {
		this.userName = userName;
		this.userURI = userURI;
		this.WFSStateList = WFSStateList;
		this.workspaces = workspaces;
	}

	public User(final String userName, final EIURI userURI, final List<EIURI> WFSStateList, List<Workspace> workspaces, final Session session)  {
		this.userName = userName;
		this.userURI = userURI;
		this.WFSStateList = WFSStateList;
		this.workspaces = workspaces;
		this.session = session;
	}

	private User() {
		// For GWT
	}

	public String getUserName() {
		return userName;
	}

	public EIURI getUserURI() {
		return userURI;
	}

	public List<Workspace> getWorkspaces() {
		return workspaces;
	}

	public List<EIURI> getWFSStateList() {
		return WFSStateList;
	}

	public Session getSession() {
		return session;
	}

}
