package org.eaglei.datatools.provider;

import java.io.IOException;

import org.eaglei.datatools.config.DatatoolsConfiguration;



/**
 * Interface for RepositoryProvider factory classes.
 */
public interface RepositoryProviderFactory {
    
    /**
     * Creates a new RepositoryProvider.
     *
     * @param config Repository configuration.
     * 
     * @return RepositoryProvider.
     * 
     * @throws IOException Thrown if an error is encountered creating the provider. 
     */
    public RepositoryProvider createRepositoryProvider(DatatoolsConfiguration config) throws IOException;
    
}
