package org.eaglei.datatools.provider;

import java.util.List;
import java.util.Map;

import org.eaglei.datatools.User;
import org.eaglei.datatools.Workspace;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

public interface RepositoryProvider {

	/*
	 * CRUD
	 */
	
	public static final EIEntity				DEFAULT_WORKSPACE_ENTITY			= EIEntity.create("http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace", "Default Workspace of resource descriptions");

	public List<EIURI> getNewInstanceID(Session session, int count) throws Exception;

	public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws Exception;

	public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws Exception;

	public EIInstance getInstance(Session session, EIURI instanceID) throws Exception;

	public String updateInstance(Session session, EIInstance instance, String token) throws Exception;;

	public void createInstance(Session session, EIInstance instance,EIEntity workspaceEntity) throws Exception;;

	public EIInstance deepCopy(Session session, EIURI originalUri) throws Exception;

	public void deleteInstance(Session session, EIURI instanceUri) throws Exception;;

	/*
	 * Bulk upload
	 */

	//TODO I don't think any client is using this anymore; double check
	//@Deprecated
	// Bulk upload is discouraged because metadata is not appropriately created
	//public void uploadInstances(Session session, String rdf) throws Exception;

	/*
	 * login/logout
	 */

	public User login(String user, String password) throws Exception;

	public void logout(Session session) throws Exception;

	public User whoami(Session session) throws Exception;

	public boolean isOnline();

	public List<Workspace> getWorkspaces(Session session) throws Exception;

	/*
	 * fake workflow
	 */
	public String[] getWFStates(Session session) throws Exception;

	public String promote(Session session, EIURI uri, EIURI newState) throws Exception; // or is it String[]?

	public String claim(Session session, EIURI uri, String claimant) throws Exception; // or is it String[]? Queries

	/*
	 * Query Should favor EIQuery over the specific methods
	 */
	public List<EIInstanceMinimal> EIQuery(Session session, String sparql) throws Exception;

	public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab) throws Exception;

	public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) throws Exception;

	public List<EIInstanceMinimal> referencedByQuery(Session session, EIURI resourceUri, boolean strictOwnerFilter) throws Exception;

	public Map<EIEntity, String> retrieveLabels(Session session, List<EIEntity> entities) throws Exception;

	public Map<EIURI, String> retrieveUriLabels(Session session, List<EIURI> uris) throws Exception;

	public String retrieveLabel(Session session, EIURI uri) throws Exception;

	/*
	 * free-form SPARQL query to this provider
	 */
	public String query(Session session, String sparql) throws Exception;

}