/**
 * The eagle-i consortium
 * Harvard University
 * Jul 1, 2010
 */
package org.eaglei.datatools.jena;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public class SPARQLConstants {
	public static final String SUBJECT_VARIABLE = "r_subject";
	public static final String LABEL_VARIABLE = "r_label";
	public static final String TYPE_VARIABLE = "r_type";
	public static final String TYPE_LABEL_VARIABLE = "r_typeLabel";
	public static final String STATE_VARIABLE = "r_state";
	public static final String STATE_LABEL_VARIABLE = "r_stateLabel";
	public static final String OWNER_VARIABLE = "r_owner";
	public static final String OWNER_NAME_VARIABLE = "r_ownerLabel";
	public static final String CREATION_DATE_VARIABLE = "r_created";
	public static final String MODIFIED_DATE_VARIABLE = "r_last_modified"; // TODO: right?
	public static final String LAB_VARIABLE = "r_lab";
	public static final String LAB_NAME_VARIABLE = "r_labName";

	public static final List<String> resultSetVariables = new ArrayList<String>() {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		{
			add( SUBJECT_VARIABLE );
			add( LABEL_VARIABLE );
			add( TYPE_VARIABLE );
			add( STATE_VARIABLE );
			add( OWNER_VARIABLE );
			add( OWNER_NAME_VARIABLE );
			add( CREATION_DATE_VARIABLE );
			add( MODIFIED_DATE_VARIABLE );
			add( LAB_VARIABLE );
			add( LAB_NAME_VARIABLE );
		}

	};

}
