/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceMinimalFactory;
import org.eaglei.datatools.jena.ProviderUtils;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.jena.XmlStringPart;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;

public final class RESTRepositoryProvider
implements RepositoryProvider {
    protected static final String READ_VIEW = "user";
    private static final String FORMAT_VALUE = "application/xml";
    private static final String RDF_FORMAT = "RDF/XML";
    private static final Log log = LogFactory.getLog(RESTRepositoryProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static String DEFAULT_REPOSITORY = "";
    public static final String LABEL_QUERY_FAILED = "could not retrieve label";
    private static final String WORKFLOW_TRANSITION_SUBJECT = "subject";
    private static final String WORKFLOW_TRANSITION_LABEL = "label";
    private static final String WORKFLOW_TRANSITION_FROM = "initial";
    private static final String WORKFLOW_TRANSITION_FROM_LABEL = "initialLabel";
    private static final String WORKFLOW_TRANSITION_TO = "final";
    private static final String WORKFLOW_TRANSITION_TO_LABEL = "finalLabel";
    private static final String WORKFLOW_TRANSITION_DESCRIPTION = "description";
    private static final String WORKFLOW_TRANSITION_WORKSPACE = "workspace";
    private static final String WORKFLOW_TRANSITION_WORKSPACELABEL = "workspaceLabel";
    private static final String WORKFLOW_TRANSITION_ALLOWED = "allowed";
    private static String WITDRAWN_WORKSPACE_URI = "http://eagle-i.org/ont/repo/1.0/NG_Withdrawn";
    private static String SANDBOX_WORKSPACE_URI = "http://eagle-i.org/ont/repo/1.0/NG_Sandbox";
    private final Map<String, HttpClient> clientMap = new HashMap<String, HttpClient>();
    private final Map<String, Map<EIURI, EIEntity>> repoUsersMap = new HashMap<String, Map<EIURI, EIEntity>>();
    private final JenaEIInstanceFactory instanceFactory;

    public RESTRepositoryProvider(DatatoolsConfiguration config, JenaEIInstanceFactory instanceFactory) throws IOException {
        if (config != null) {
            DEFAULT_REPOSITORY = config.getDatatoolsRepositoryURL();
        }
        this.instanceFactory = instanceFactory;
    }

    private HttpClient createHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private HttpClient getHttpClient(Session session) {
        if (!Session.isValid((Session)session)) {
            return null;
        }
        if (this.clientMap.get(session.getSessionId()) == null) {
            return null;
        }
        return this.clientMap.get(session.getSessionId());
    }

    protected void setWriteParameters(PostMethod method, String id) {
        method.setParameter("uri", id);
        method.setParameter("format", FORMAT_VALUE);
        method.setRequestHeader("charset", "UTF-8");
    }

    protected void setReadParameters(PostMethod method) {
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("view", READ_VIEW);
        method.setParameter("noinferred", "true");
        method.setRequestHeader("charset", "UTF-8");
    }

    @Override
    public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws Exception {
        log.info((Object)("the instance label is   " + instance.getInstanceLabel().toString()));
        ProviderUtils.validateSession(session);
        if (instance == null || instance.getInstanceURI() == null) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return;
        }
        String instanceUri = instance.getInstanceURI().toString();
        String instanceAsString = this.instanceFactory.serialize(instance, RDF_FORMAT);
        this.createInstance(session, instanceAsString, instanceUri, workspaceEntity);
    }

    public void createInstance(Session session, String rdfString, String instanceUri, EIEntity workspaceEntity) throws Exception {
        ProviderUtils.validateSession(session);
        if (rdfString == null) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return;
        }
        PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
        StringPart idPart = new StringPart("uri", instanceUri, "utf-8");
        StringPart workspacePart = null;
        if (workspaceEntity != null && !workspaceEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            log.info((Object)("creating instance in workspace " + workspaceEntity.getURI().toString()));
            workspacePart = new StringPart(WORKFLOW_TRANSITION_WORKSPACE, workspaceEntity.getURI().toString(), "UTF-8");
        } else {
            log.info((Object)"creating instance in default workspace");
            workspacePart = new StringPart(WORKFLOW_TRANSITION_WORKSPACE, DEFAULT_WORKSPACE_ENTITY.getURI().toString(), "utf-8");
        }
        if (isDebugEnabled) {
            log.debug((Object)"creating the action part");
        }
        StringPart actionPart = new StringPart("action", "create");
        XmlStringPart insertPart = new XmlStringPart("insert", rdfString, "UTF-8");
        if (isDebugEnabled) {
            log.debug((Object)("the transfer encoding of insertpart  is " + insertPart.getTransferEncoding()));
            log.debug((Object)("the charset of insertpart  is " + insertPart.getCharSet()));
            log.debug((Object)("the content type of insertpart  is " + insertPart.getContentType()));
        }
        log.info((Object)"making parts array from the created parts to send it a multipart request");
        Part[] parts = new Part[]{workspacePart, actionPart, insertPart, idPart};
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to create instance at " + instanceUri));
        }
        ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    private String encodeToUTF8(String rdfString) throws UnsupportedEncodingException {
        return new String(rdfString.getBytes("UTF-8"));
    }

    @Override
    public EIInstance deepCopy(Session session, EIURI originalUri) throws Exception {
        ProviderUtils.validateSession(session);
        EIInstance original = this.getInstance(session, originalUri);
        if (isDebugEnabled) {
            log.debug((Object)"got original instance");
        }
        return this.duplicateInstance(session, original);
    }

    public EIInstance duplicateInstance(Session session, EIInstance original) throws Exception {
        EIInstance duplicate = this.getEmptyEIInstance(session, original.getInstanceType().getURI());
        for (EIEntity property : original.getDatatypeProperties().keySet()) {
            for (String value : original.getDatatypeProperty(property)) {
                duplicate.addDatattypeProperty(property, value);
            }
        }
        for (EIEntity property : original.getObjectProperties().keySet()) {
            for (String value : original.getObjectProperty(property)) {
                duplicate.addObjectProperty(property, (EIEntity)value);
            }
        }
        for (EIEntity property : original.getNonOntologyLiteralProperties().keySet()) {
            for (String value : original.getNonOntologyLiteralProperty(property)) {
                duplicate.addNonOntologyLiteralProperty(property, value);
            }
        }
        for (EIEntity property : original.getNonOntologyResourceProperties().keySet()) {
            for (String value : original.getNonOntologyResourceProperty(property)) {
                duplicate.addNonOntologyResourceProperty(property, (EIEntity)value);
            }
        }
        if (isDebugEnabled) {
            log.debug((Object)"finished making new copy");
        }
        return duplicate;
    }

    @Override
    public void deleteInstance(Session session, EIURI instanceUri) throws Exception {
        ProviderUtils.validateSession(session);
        if (instanceUri == null || instanceUri.toString() == null || instanceUri.toString().length() == 0) {
            return;
        }
        String token = this.getToken(session, instanceUri.toString());
        PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
        this.setWriteParameters(method, instanceUri.toString());
        method.setParameter("action", "update");
        method.setParameter("token", token);
        method.setParameter("delete", this.createDeleteStatement(instanceUri));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to delete instance at " + instanceUri.toString()));
        }
        ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    @Override
    public String updateInstance(Session session, EIInstance instance, String token) throws Exception {
        ProviderUtils.validateSession(session);
        if (instance == null || instance.getInstanceURI() == null || instance.getInstanceURI().toString() == null || instance.getInstanceURI().toString().length() == 0) {
            log.warn((Object)"Trying to update instance with null instance or null instance URI");
            return null;
        }
        instance.setReadOnlyLiteralProperties(new HashMap());
        String instanceAsString = this.instanceFactory.serialize(instance, RDF_FORMAT);
        String instanceUri = instance.getInstanceURI().toString();
        return this.updateInstance(session, instanceAsString, instanceUri, token);
    }

    public String updateInstance(Session session, String rdfString, String instanceUri, String token) throws Exception {
        ProviderUtils.validateSession(session);
        StringPart idPart = new StringPart("uri", instanceUri, "UTF-8");
        if (rdfString == null || rdfString.length() == 0) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return null;
        }
        if (token == null) {
            return this.updateAndGetToken(session, rdfString, instanceUri);
        }
        PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
        StringPart actionPart = new StringPart("action", "update");
        XmlStringPart insertPart = new XmlStringPart("insert", rdfString, "UTF-8");
        XmlStringPart deletePart = new XmlStringPart("delete", this.createDeleteStatement(instanceUri), "UTF-8");
        StringPart tokenPart = new StringPart("token", token);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to update instance at " + instanceUri));
        }
        log.info((Object)"making parts array from the created parts to send it a multipart request");
        Part[] parts = new Part[]{idPart, actionPart, insertPart, deletePart, tokenPart};
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
        return ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    private String createDeleteStatement(EIURI instanceUri) {
        return this.createDeleteStatement(instanceUri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDeleteStatement(String instanceUri) {
        String s = null;
        String wildcard = "<" + instanceUri + "> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .";
        log.info((Object)"Trying to create a wildcard graph to delete all the statements");
        Model m = ModelFactory.createDefaultModel();
        StringReader st = new StringReader(wildcard);
        m.read((Reader)st, null, "N-TRIPLE");
        StringWriter sw = new StringWriter();
        try {
            m.write((Writer)sw, RDF_FORMAT);
            s = sw.toString();
            sw.flush();
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("createDelete statement: " + e));
            }
        }
        return s;
    }

    private String getToken(Session session, String instanceUri) throws Exception {
        return this.updateAndGetToken(session, null, instanceUri);
    }

    private String updateAndGetToken(Session session, String rdfString, String instanceUri) throws Exception {
        ArrayList<StringPart> partsList = new ArrayList<StringPart>();
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
        StringPart idPart = new StringPart("uri", instanceUri, "UTF-8");
        partsList.add(idPart);
        StringPart actionPart = new StringPart("action", "gettoken", "UTF-8");
        partsList.add(actionPart);
        if (rdfString != null && rdfString.length() > 0) {
            XmlStringPart insertPart = new XmlStringPart("insert", rdfString, "UTF-8");
            partsList.add(insertPart);
        }
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(partsList.toArray(new Part[partsList.size()]), method.getParams()));
        String resp = ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
        return this.parseResponseToken(resp);
    }

    private String parseResponseToken(String resp) {
        ResultSet results = ResultSetFactory.fromXML((String)resp);
        QuerySolution soln = results.nextSolution();
        Resource r = soln.getResource("token");
        String tokenid = r.getURI();
        log.info((Object)("Retrieved new token " + tokenid));
        return tokenid;
    }

    @Override
    public EIInstance getInstance(Session session, EIURI instanceID) throws Exception {
        ProviderUtils.validateSession(session);
        if (instanceID == null || instanceID.toString() == null) {
            log.warn((Object)"Trying to get instance for null EIURI");
            return null;
        }
        PostMethod method = new PostMethod(RestCommands.GetInstance.getURL());
        this.setReadParameters(method);
        method.setParameter("uri", instanceID.toString());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceID.toString()));
        }
        String responseBody = ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
        return this.instanceFactory.create(instanceID, responseBody, RDF_FORMAT);
    }

    @Override
    public List<EIURI> getNewInstanceID(Session session, int count) throws Exception {
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.GetNewInstanceIDs.getURL());
        method.setParameter("accept", "application/sparql-results+xml");
        method.setParameter("count", Integer.toString(count));
        log.info((Object)("getting " + count + " instance IDs"));
        String responseBody = ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
        ResultSet results = ResultSetFactory.fromXML((String)responseBody);
        ArrayList<EIURI> instances = new ArrayList<EIURI>(count);
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            Resource r = soln.getResource("new");
            String id = r.getURI();
            instances.add(EIURI.create((String)id));
            log.info((Object)("Created new instance id: " + id));
        }
        if (isDebugEnabled) {
            log.debug((Object)("Created " + instances.size() + " ids"));
        }
        return instances;
    }

    private User getUserInformation(Session session, HttpClient client) throws Exception {
        String sessionId;
        if (client == null) {
            log.error((Object)"http Client is null");
            return null;
        }
        GetMethod method = new GetMethod(RestCommands.WhoAmI.getURL());
        String responseBody = ProviderUtils.getHttpResponse(client, (HttpMethod)method);
        if (responseBody == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        ResultSet results = ResultSetFactory.fromXML((String)responseBody);
        if (results == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        QuerySolution soln = results.nextSolution();
        Literal username = soln.getLiteral("username");
        Resource userURI = soln.getResource("uri");
        if (username == null || userURI == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        log.info((Object)("Authenticated user: " + username.getString() + " " + userURI.getURI()));
        if (!Session.isValid((Session)session)) {
            sessionId = UUID.randomUUID().toString();
            this.clientMap.put(sessionId, client);
        } else {
            sessionId = session.getSessionId();
        }
        log.info((Object)("session ID: " + sessionId + "; new session? " + (Session.isValid((Session)session) ? "yes" : "no")));
        Session newSession = new Session(sessionId, "", username.getString(), userURI.getURI());
        List<Object> states = new ArrayList();
        try {
            states = this.listWorkFlowTransitions(newSession, null);
            log.info((Object)("has number of wfsStates " + states.size()));
        }
        catch (Exception e) {
            log.warn((Object)"failed to get fake workflow states");
        }
        List<Workspace> workspaceList = Collections.emptyList();
        User user = new User(username.getString(), EIURI.create((String)userURI.getURI()), states, workspaceList, newSession);
        return user;
    }

    @Override
    public List<Workspace> getWorkspaces(Session session) throws Exception {
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.Listgraphs.getURL());
        method.setParameter("format", FORMAT_VALUE);
        log.info((Object)("executing " + RestCommands.Listgraphs.getURL() + " api call"));
        String responseBody = ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
        log.info((Object)(RestCommands.Listgraphs.getURL() + " api call has returned ,parsing the results"));
        ArrayList<Workspace> workspaceList = new ArrayList<Workspace>();
        ResultSet resultSet = ResultSetFactory.fromXML((String)responseBody);
        while (resultSet.hasNext()) {
            QuerySolution solution = resultSet.next();
            String workspaceName = solution.getLiteral("namedGraphLabel").getString();
            String workspaceURI = solution.getResource("namedGraphURI").getURI();
            if (workspaceURI.equals(WITDRAWN_WORKSPACE_URI) || workspaceURI.equals(SANDBOX_WORKSPACE_URI)) continue;
            String typeURI = solution.getResource("typeURI").getURI();
            boolean canUserAdd = solution.getLiteral("add").getBoolean();
            boolean canUserDelete = solution.getLiteral("remove").getBoolean();
            Workspace workspace = new Workspace(workspaceName, EIURI.create((String)workspaceURI), EIURI.create((String)typeURI), canUserAdd, canUserDelete);
            workspaceList.add(workspace);
        }
        return workspaceList;
    }

    @Override
    public User login(String userName, String password) throws Exception {
        User user;
        HttpClient client = this.createHttpClient(userName, password);
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        if (isDebugEnabled) {
            log.debug((Object)("Trying to login at " + RestCommands.WhoAmI.getURL() + " with username " + userName));
        }
        if ((user = this.getUserInformation(null, client)) == null || user.getUserURI() == null) {
            log.error((Object)("Could not authenticate user: " + userName));
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        return user;
    }

    @Override
    public void logout(Session session) throws Exception {
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.Logout.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to logout at " + RestCommands.Logout.getURL()));
        }
        try {
            ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
            this.clientMap.remove(session.getSessionId());
            this.repoUsersMap.remove(session.getSessionId());
        }
        catch (Exception e) {
            this.clientMap.remove(session.getSessionId());
            this.repoUsersMap.remove(session.getSessionId());
            throw e;
        }
    }

    @Override
    public User whoami(Session session) throws Exception {
        User sessionToResponse;
        if (!Session.isValid((Session)session)) {
            log.info((Object)"Using null session.  Could not whoami user");
            return null;
        }
        HttpClient client = this.getHttpClient(session);
        if (client == null) {
            log.info((Object)"Using stale session.  Could not whoami user");
            return null;
        }
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        if (isDebugEnabled) {
            log.debug((Object)("Trying to whoami at " + RestCommands.WhoAmI.getURL()));
        }
        if ((sessionToResponse = this.getUserInformation(session, client)).getUserName() == null) {
            log.info((Object)"Could not whoami user: http status:");
            return null;
        }
        return sessionToResponse;
    }

    @Override
    public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        ProviderUtils.validateSession(session);
        return this.instanceFactory.createEmpty(classUri, instanceEntity);
    }

    @Override
    public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws Exception {
        ProviderUtils.validateSession(session);
        List<EIURI> ids = this.getNewInstanceID(session, 1);
        if (isDebugEnabled) {
            log.debug((Object)("New instance ID is: " + ids.get(0)));
        }
        EIInstance instance = this.instanceFactory.createEmpty(classUri, EIEntity.create((EIURI)ids.get(0), (String)""));
        if (isDebugEnabled) {
            log.debug((Object)("got new instance of class " + classUri + "; null class ? " + (instance.getClass() == null ? "yes" : "no")));
            log.debug((Object)("New instance is: " + instance));
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnline() {
        int status = 0;
        boolean online = false;
        GetMethod method = new GetMethod(RestCommands.Online.getURL());
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to see if Repository is available: " + RestCommands.Online.getURL()));
        }
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200 || status == 401) {
                online = true;
                if (isDebugEnabled) {
                    log.debug((Object)("Repository is available: " + RestCommands.Online.getURL() + " is available with status: " + status));
                }
            } else if (isDebugEnabled) {
                log.debug((Object)("Repository is unavailable: " + RestCommands.Online.getURL() + " is available with status: " + status));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem checking online status of repository: " + RestCommands.Online.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        return online;
    }

    private synchronized String postQuery(Session session, String q) throws Exception {
        return this.postQuery(session, q, READ_VIEW);
    }

    private synchronized String postQuery(Session session, String q, String view) throws Exception {
        ProviderUtils.validateSession(session);
        if (q == null) {
            log.warn((Object)"Null query!");
            return null;
        }
        PostMethod method = new PostMethod(RestCommands.Query.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to query: " + RestCommands.Query.getURL()));
        }
        this.setReadParameters(method);
        method.setParameter("view", view);
        method.setParameter("query", this.encodeToUTF8(q));
        return ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    @Override
    public String query(Session session, String sparql) throws Exception {
        ProviderUtils.validateSession(session);
        return this.postQuery(session, sparql);
    }

    @Override
    public List<EIInstanceMinimal> EIQuery(Session session, String sparql) throws Exception {
        ProviderUtils.validateSession(session);
        if (isDebugEnabled) {
            log.debug((Object)("Sparql: " + sparql));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)this.postQuery(session, sparql));
        return EIInstanceMinimalFactory.getInstance().create(resultSet);
    }

    @Override
    @Deprecated
    public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab) throws Exception {
        return this.getFilterQuery(session, classUri, state, lab, false);
    }

    @Override
    @Deprecated
    public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) throws Exception {
        ProviderUtils.validateSession(session);
        return this.EIQuery(session, SPARQLQueryUtil.getInstance().getFilterQuery(session.getUserURI(), classUri, state, lab, strictOwnerFilter));
    }

    @Override
    @Deprecated
    public List<EIInstanceMinimal> referencedByQuery(Session session, EIURI resourceUri, boolean strictOwnerFilter) throws Exception {
        ProviderUtils.validateSession(session);
        return this.EIQuery(session, SPARQLQueryUtil.getInstance().getReferencedByQuery(session.getUserURI(), resourceUri, strictOwnerFilter));
    }

    @Deprecated
    public void uploadInstances(Session session, String rdf) throws Exception {
        ProviderUtils.validateSession(session);
        if (rdf == null) {
            log.warn((Object)"Trying to upload null rdf");
            return;
        }
        PostMethod method = new PostMethod(RestCommands.Upload.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("name", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("type", "published");
        method.setParameter("action", "add");
        method.setParameter("content", this.encodeToUTF8(rdf));
        ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    @Deprecated
    public String fakeWorkflowClaim(Session session, EIURI uri, String claimant) throws Exception {
        ProviderUtils.validateSession(session);
        if (uri == null || claimant == null) {
            log.warn((Object)("null claim parameter, returning null: " + (uri == null ? "uri" : (claimant == null ? "claimant" : "huh?"))));
            return null;
        }
        PostMethod method = new PostMethod(RestCommands.FakeWorkflow.getURL());
        method.setParameter("uri", uri.toString());
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("claim", claimant);
        log.info((Object)("Trying to claim " + uri + " for " + claimant));
        return ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    @Deprecated
    public String fakeWorkflowPromote(Session session, EIURI uri, EIURI newState) throws Exception {
        ProviderUtils.validateSession(session);
        if (uri == null) {
            log.warn((Object)"Trying to promote a null URI");
            return null;
        }
        PostMethod method = new PostMethod(RestCommands.FakeWorkflow.getURL());
        method.setParameter("uri", uri.toString());
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("promote", newState.toString());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to promote " + uri + " to state " + newState));
        }
        return ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
    }

    @Deprecated
    public List<EIURI> fakeWorkflowGetWFStatesList(Session session) throws Exception {
        ProviderUtils.validateSession(session);
        String q = SPARQLQueryUtil.getInstance().getWFStatesQuery(session.getUserURI());
        if (isDebugEnabled) {
            log.debug((Object)("get wf states query: " + q));
        }
        String result = this.postQuery(session, q, "all");
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        ArrayList<EIURI> states = new ArrayList<EIURI>();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("r_state")) continue;
            states.add(EIURI.create((String)qs.getResource("r_state").getURI()));
        }
        return states;
    }

    @Deprecated
    public String[] fakeWorkflowGetWFStates(Session session) throws Exception {
        List<EIURI> states = this.fakeWorkflowGetWFStatesList(session);
        return states.toArray(new String[states.size()]);
    }

    @Override
    public String retrieveLabel(Session session, EIURI uri) throws Exception {
        ProviderUtils.validateSession(session);
        String q = SPARQLQueryUtil.getInstance().getRetrieveLabelQuery(uri);
        if (isDebugEnabled) {
            log.debug((Object)("retrieve label query: " + q));
        }
        String result = this.postQuery(session, q, READ_VIEW);
        if (isDebugEnabled) {
            log.debug((Object)("result " + result));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        ArrayList<String> labels = new ArrayList<String>();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("r_label")) continue;
            labels.add(qs.getLiteral("r_label").getString());
        }
        return labels.isEmpty() ? "" : (String)labels.get(0);
    }

    @Override
    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws Exception {
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.ListResources.getURL());
        EIURI state = queryRequest.getWFState();
        if (state != null && !state.equals((Object)EIURI.NULL_EIURI)) {
            method.setParameter("state", state.toString());
        } else {
            method.setParameter("state", "all");
        }
        StringBuilder sparql = new StringBuilder();
        EIURI classUri = queryRequest.getType();
        if (classUri != null && !classUri.equals((Object)EIURI.NULL_EIURI)) {
            method.setParameter("type", classUri.toString());
        } else {
            sparql.append(SPARQLQueryUtil.getInstance().allTypesPattern(true));
        }
        EIURI lab = queryRequest.getLab();
        if (lab != null && !lab.equals((Object)EIURI.NULL_EIURI)) {
            sparql.append(SPARQLQueryUtil.getInstance().labRestrictionPattern(lab));
        } else {
            sparql.append(SPARQLQueryUtil.getInstance().labRestrictionPattern(EIURI.NULL_EIURI));
        }
        this.commonListResourcesMethodSetup(EIURI.create((String)session.getUserURI()), queryRequest, orderBy, strictOwnerFilter, sparql, method);
        ResultSet resultSet = ResultSetFactory.fromXML((String)ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method));
        List<EIInstanceMinimal> results = EIInstanceMinimalFactory.getInstance().create(resultSet);
        if (isDebugEnabled) {
            log.debug((Object)("number of resources retrieved: " + results.size()));
        }
        return results;
    }

    @Override
    public List<EIInstanceMinimal> listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws Exception {
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.ListResources.getURL());
        method.setParameter("state", "all");
        StringBuilder sparql = new StringBuilder();
        sparql.append(SPARQLQueryUtil.getInstance().allTypesPattern(false));
        sparql.append(SPARQLQueryUtil.getInstance().labRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(SPARQLQueryUtil.getInstance().referencedByPattern(resourceUri));
        this.commonListResourcesMethodSetup(EIURI.create((String)session.getUserURI()), queryRequest, orderBy, strictOwnerFilter, sparql, method);
        ResultSet resultSet = ResultSetFactory.fromXML((String)ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method));
        List<EIInstanceMinimal> results = EIInstanceMinimalFactory.getInstance().create(resultSet);
        return results;
    }

    private void commonListResourcesMethodSetup(EIURI user, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, StringBuilder sparql, PostMethod method) throws UnsupportedEncodingException {
        method.setParameter("detail", "full");
        method.setParameter("format", FORMAT_VALUE);
        if (strictOwnerFilter) {
            method.setParameter("owner", "self");
            method.setParameter("unclaimed", "false");
        } else {
            method.setParameter("owner", "all");
            method.setParameter("unclaimed", "true");
        }
        sparql.append(SPARQLQueryUtil.getInstance().modifiedDatePattern());
        if (orderBy == SortByProperties.status || orderBy == SortByProperties.type) {
            sparql.append(SPARQLQueryUtil.getInstance().additionalLabelsPattern());
        }
        sparql.append(" filter(!regex(str(?").append("r_created").append("), \"http://www.w3.org/2001/XMLSchema#dateTime\"))");
        sparql.append(" filter(bound(?").append("r_label").append("))");
        if (isDebugEnabled) {
            log.debug((Object)("Sparql pattern sent to workflow/resources is: " + sparql.toString()));
        }
        method.setParameter("addPattern", this.encodeToUTF8(sparql.toString()));
        method.setParameter("addResults", "?r_lab ?r_labName ?r_last_modified");
        StringBuilder modifiers = new StringBuilder();
        modifiers.append(" ORDER BY <http://eagle-i.org/ont/repo/1.0/upperCaseStr>(?").append(orderBy.getVariable()).append(") ");
        if (queryRequest.isPaginated() && queryRequest.getMaxResults() > 0 && queryRequest.getStartIndex() >= 0) {
            modifiers.append("LIMIT ").append(String.valueOf(queryRequest.getMaxResults())).append(" OFFSET ").append(String.valueOf(queryRequest.getStartIndex()));
        }
        method.setParameter("addModifiers", modifiers.toString());
        if (isDebugEnabled) {
            log.debug((Object)("modifiers sent to workflow/resources are: " + modifiers.toString()));
        }
    }

    @Override
    public EIInstance getInstanceWithWorkflowState(Session session, EIURI instanceUri) throws Exception {
        return null;
    }

    @Override
    public List<WorkFlowTransition> listWorkFlowTransitions(Session session, EIEntity workspaceEntity) throws Exception {
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.ListTransitions.getURL());
        method.setParameter("format", FORMAT_VALUE);
        if (workspaceEntity != null && !workspaceEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            method.setParameter("URI", workspaceEntity.getURI().toString());
        }
        log.info((Object)("executing " + RestCommands.ListTransitions.getURL() + " api call"));
        String responseBody = ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
        if (responseBody == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        log.info((Object)"parsing response to make list of workflow transitions");
        ResultSet resultSet = ResultSetFactory.fromXML((String)responseBody);
        ArrayList<WorkFlowTransition> transitionList = new ArrayList<WorkFlowTransition>();
        while (resultSet.hasNext()) {
            boolean allowed;
            QuerySolution solution = resultSet.next();
            if (!solution.contains(WORKFLOW_TRANSITION_ALLOWED) || !(allowed = solution.getLiteral(WORKFLOW_TRANSITION_ALLOWED).getBoolean())) continue;
            EIEntity transitionEntity = this.getEntityFromSolution(solution, WORKFLOW_TRANSITION_SUBJECT, WORKFLOW_TRANSITION_LABEL);
            EIEntity fromStateEntity = this.getEntityFromSolution(solution, WORKFLOW_TRANSITION_FROM, WORKFLOW_TRANSITION_FROM_LABEL);
            EIEntity toStateEntity = this.getEntityFromSolution(solution, WORKFLOW_TRANSITION_TO, WORKFLOW_TRANSITION_TO_LABEL);
            WorkFlowTransition workFlowTransition = new WorkFlowTransition(transitionEntity, fromStateEntity, toStateEntity, allowed);
            transitionList.add(workFlowTransition);
        }
        log.info((Object)(transitionList.size() + " transitions were returned"));
        return transitionList;
    }

    private EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create((String)solution.getResource(uriVariable).getURI());
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create((EIURI)uri, (String)label);
        }
        return EIEntity.NULL_ENTITY;
    }

    @Override
    public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws Exception {
        HashMap<EIURI, String> uriToModifiedDate = new HashMap<EIURI, String>();
        for (EIURI uri : uris) {
            String date = this.getModifiedDate(session, uri);
            if (isDebugEnabled) {
                log.debug((Object)date);
            }
            uriToModifiedDate.put(uri, date);
        }
        return uriToModifiedDate;
    }

    private String getModifiedDate(Session session, EIURI uri) throws Exception {
        String query = SPARQLQueryUtil.getInstance().getModifiedDateQuery(uri);
        String result = this.postQuery(session, query, READ_VIEW);
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        String modifiedDate = "";
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("r_last_modified")) continue;
            modifiedDate = qs.getLiteral("r_last_modified").getString();
        }
        return modifiedDate;
    }

    @Override
    public List<EIURI> claim(Session session, List<EIURI> uris) throws Exception {
        ArrayList<EIURI> successes = new ArrayList<EIURI>();
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.Claim.getURL());
        for (EIURI uri : uris) {
            method.setParameter("uri", uri.toString());
            try {
                ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
                successes.add(uri);
            }
            catch (EIDataToolsProviderException e) {
                log.warn((Object)("could not claim " + uri));
            }
        }
        return successes;
    }

    @Override
    public List<EIURI> release(Session session, List<EIURI> uris) throws Exception {
        log.info((Object)("releasing " + uris.size() + " uris"));
        ArrayList<EIURI> successes = new ArrayList<EIURI>();
        ProviderUtils.validateSession(session);
        PostMethod method = new PostMethod(RestCommands.Release.getURL());
        for (EIURI uri : uris) {
            method.setParameter("uri", uri.toString());
            try {
                ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
                successes.add(uri);
            }
            catch (EIDataToolsProviderException e) {
                log.warn((Object)("could not release " + uri));
            }
        }
        return successes;
    }

    @Override
    public List<EIURI> transition(Session session, List<EIURI> uris, EIEntity transitionEntity) throws Exception {
        ArrayList<EIURI> successes = new ArrayList<EIURI>();
        ProviderUtils.validateSession(session);
        for (EIURI uri : uris) {
            PostMethod method = new PostMethod(RestCommands.Transition.getURL());
            method.setParameter("uri", uri.toString());
            method.setParameter("transition", transitionEntity.getURI().toString());
            try {
                ProviderUtils.getHttpResponse(this.getHttpClient(session), (HttpMethod)method);
                log.info((Object)("transitioned " + uri + " using " + transitionEntity.getLabel()));
                successes.add(uri);
            }
            catch (EIDataToolsProviderException e) {
                log.warn((Object)("could not transition " + uri));
            }
        }
        return successes;
    }

    static enum LoginFields {
        USERNAME(0),
        SESSION(1),
        USER_URI(2),
        ERROR_MESSAGE(3),
        WF_STATE(3);

        private final int value;

        private LoginFields(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum RestCommands {
        GetNewInstanceIDs("repository/new"),
        WhoAmI("repository/whoami"),
        Logout("repository/logout/"),
        GetInstance("i"),
        UpdateInstance("repository/update"),
        Query("repository/sparql"),
        Online(""),
        Upload("repository/graph"),
        FakeWorkflow("repository/fakeworkflow"),
        Listgraphs("repository/listGraphs"),
        Claim("repository/workflow/claim"),
        Release("repository/workflow/release"),
        Transition("repository/workflow/push"),
        ListTransitions("repository/workflow/transitions"),
        ListResources("repository/workflow/resources");

        private final String key;

        private RestCommands(String propKey) {
            this.key = propKey;
        }

        public String getURL() {
            return DEFAULT_REPOSITORY + this.key;
        }
    }
}

