/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.io.IOException;
import java.util.List;

import org.apache.commons.httpclient.HttpException;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.search.provider.AuthSearchRequest;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface WorkFlowProvider {

	/**
	 * Returns the list of WorkFlowTransion objects
	 * 
	 * @see WorkFlowTransition
	 * 
	 *      It Uses the Repository API call <code>/repository/workflow/transitions</code>,please see Workflow design notes at <a
	 *      href="https://sites.google.com/a/eagle-i.org/workspace/build-team-workspace/data-repository-workspace/workflow-design-notes">Workflow Design Notes</a>
	 * 
	 * @param session
	 * @param workspaceEntity
	 *            restrict results to transitions applying to given workspace . if passed null defaults to list from all workspaces
	 * @return List<WorkFlowTransition>
	 * @throws EIDataToolsProviderException
	 * @throws Exception 
	 * @throws HttpException
	 * @throws IOException
	 */
	public List<WorkFlowTransition> listWorkFlowTransitions(Session session, EIEntity workspaceEntity) throws  Exception; /*--API CALL:/repository/workflow/transitions--*/

	// public Map<EIInstanceMinimal,List<WorkFlowTransition>> getAllowedTransistionsOfInstance(Session session,EIInstanceMinimal instance); //or is it List<WorkFlowTransistion>?

	//public List<EIInstanceMinimal> listResources(Session session, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) throws Exception; /*--API CALL:/repository/workflow/resources--*/

	//public List<EIInstanceMinimal> listReferencingResources(Session session, EIURI resourceUri, boolean strictOwnerFilter) throws Exception; /*--API CALL:/repository/workflow/resources--*/

	public List<EIInstanceMinimal> listResources(final Session session, final AuthSearchRequest queryRequest, final SortByProperties orderBy, final boolean strictOwnerFilter, final boolean stubsOnly) throws Exception; 

	public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws Exception; /*--API CALL:/repository/workflow/resources--*/

	public List<EIInstanceMinimal> listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws Exception; /*--API CALL:/repository/workflow/resources--*/

	public List<EIURI> transition(Session session, List<EIURI> uris, EIEntity transitionEntity) throws Exception; // /*--API CALL:/repository/workflow/push -*/

	public List<EIURI> claim(Session session, List<EIURI> uris) throws Exception; // Queries /*--API CALL:/repository/workflow/claim -*/

	public List<EIURI> release(Session session, List<EIURI> uris) throws Exception;// Queries /*--API CALL:/repository/workflow/release -*/

}
