/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.SPARQLConstants;
import org.eaglei.model.EIURI;

public class SPARQLQueryUtil {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);
    private static SPARQLQueryUtil instance;

    private SPARQLQueryUtil() {
    }

    public static SPARQLQueryUtil getInstance() {
        if (instance == null) {
            instance = new SPARQLQueryUtil();
        }
        return instance;
    }

    public String getEIResourcesByLabelQuery(EIURI rootURI, String label) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.selectClause("resource"));
        sparql.append("?resource a <").append(rootURI.toString()).append("> . ");
        sparql.append("?resource <http://www.w3.org/2000/01/rdf-schema#label> ?o ");
        sparql.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
        return sparql.toString();
    }

    public String getRetrieveLabelQuery(EIURI uri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.selectClause("r_label"));
        sparql.append("<").append(uri.toString()).append("> <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label");
        sparql.append("}");
        return sparql.toString();
    }

    @Deprecated
    public String getReferencedByQuery(String user, EIURI resourceUri, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append(this.selectClause(SPARQLConstants.resultSetVariables));
        sparql.append(this.commonPattern());
        sparql.append(this.typePattern());
        sparql.append(this.referencedByPattern(resourceUri));
        sparql.append(this.typeRestrictionPattern(EIURI.NULL_EIURI, false));
        sparql.append(this.stateRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(this.labRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(this.ownerRestrictionPattern(EIURI.create((String)user), strictOwnerFilter));
        sparql.append(this.orderByLabelClosingClause());
        return sparql.toString();
    }

    public String referencedByPattern(EIURI resourceUri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?").append("r_subject").append(" ?anyPredicate <").append(resourceUri.toString()).append("> . ");
        return sparql.toString();
    }

    public String getResourcesForObjectPropertyValuesQuery(EIURI classUri, EIURI lab, EIURI state, boolean onlyLab) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.selectClause(Arrays.asList("r_subject", "r_label", "r_type", "r_typeLabel", "r_lab", "r_labName")));
        sparql.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql.append(this.typePattern());
        sparql.append(this.typeRestrictionPattern(classUri, false));
        if (onlyLab) {
            sparql.append(this.labRestrictionPattern(lab));
        } else {
            sparql.append(this.labRestrictionPattern(EIURI.NULL_EIURI));
        }
        sparql.append(this.stateRestrictionPattern(state));
        sparql.append(this.orderByLabelClosingClause());
        return sparql.toString();
    }

    @Deprecated
    public String getFilterQuery(String user, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append(this.selectClause(SPARQLConstants.resultSetVariables));
        sparql.append(this.commonPattern());
        sparql.append(this.typePattern());
        sparql.append(this.typeRestrictionPattern(classUri, true));
        sparql.append(this.stateRestrictionPattern(state));
        sparql.append(this.labRestrictionPattern(lab));
        sparql.append(this.ownerRestrictionPattern(EIURI.create((String)user), strictOwnerFilter));
        sparql.append(this.orderByLabelClosingClause());
        return sparql.toString();
    }

    @Deprecated
    private String namespaces() {
        StringBuilder namespaces = new StringBuilder();
        namespaces.append("PREFIX dcterms: <").append("http://purl.org/dc/terms/").append("> ");
        namespaces.append("PREFIX rdf: <").append("http://www.w3.org/1999/02/22-rdf-syntax-ns#").append("> ");
        namespaces.append("PREFIX rdfs: <").append("http://www.w3.org/2000/01/rdf-schema#").append("> ");
        namespaces.append("PREFIX repo: <").append("http://eagle-i.org/ont/repo/1.0/").append("> ");
        return namespaces.toString();
    }

    public String selectClause(List<String> resultVariables) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT DISTINCT ");
        for (String variable : resultVariables) {
            sparql.append("?").append(variable).append(" ");
        }
        sparql.append("WHERE { ");
        return sparql.toString();
    }

    public String selectClause(String resultVariable) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT DISTINCT ").append("?").append(resultVariable).append(" ").append("WHERE { ");
        return sparql.toString();
    }

    @Deprecated
    private String commonPattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql.append("?").append("r_subject").append(" dcterms:created ?").append("r_created").append(" . ");
        return sparql.toString();
    }

    private String typePattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("graph ?g{?").append("r_subject").append(" a ?").append("r_type").append("}");
        sparql.append("filter(?g != <").append("http://eagle-i.org/ont/repo/1.0/").append("NG_Inferred>) . ");
        return sparql.toString();
    }

    public String allTypesPattern(boolean excludeSomeTypes) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?").append("r_subject").append(" a ?rt . ");
        sparql.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> ");
        if (excludeSomeTypes) {
            sparql.append("filter(?rt != <").append("http://purl.obolibrary.org/obo/OBI_0000245").append("> && ?rt != <").append("http://xmlns.com/foaf/0.1/Person").append(">) .");
        }
        return sparql.toString();
    }

    public String includeOwnerLabelPattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("OPTIONAL{?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append(" . ");
        sparql.append("?").append("r_owner").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_ownerLabel").append("} . ");
        return sparql.toString();
    }

    public String getAllPossibleOwnersQuery() {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.selectClause(Arrays.asList("r_owner", "r_ownerLabel")));
        sparql.append("?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append(" . ");
        sparql.append("?").append("r_owner").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_ownerLabel").append("}");
        return sparql.toString();
    }

    public String ownerRestrictionPattern(EIURI user, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        if (strictOwnerFilter) {
            sparql.append("?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append(" . ");
            sparql.append("FILTER(?").append("r_owner").append("= <");
        } else {
            sparql.append("OPTIONAL {?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append("} . ");
            sparql.append("FILTER(!bound(?").append("r_owner").append(") || ?").append("r_owner").append(" = <");
        }
        sparql.append(user.toString());
        sparql.append(">) . ");
        return sparql.toString();
    }

    private String typeRestrictionPattern(EIURI classUri, boolean excludeSomeTypes) {
        StringBuilder sparql = new StringBuilder();
        if (!this.isNull(classUri)) {
            sparql.append("?").append("r_subject").append(" a <").append(classUri.toString()).append("> .");
        } else {
            sparql.append(this.allTypesPattern(excludeSomeTypes));
        }
        return sparql.toString();
    }

    private String stateRestrictionPattern(EIURI state) {
        StringBuilder sparql = new StringBuilder();
        if (!this.isNull(state)) {
            sparql.append("OPTIONAL {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/repo/1.0/").append("hasWorkflowState> <").append(state.toString()).append("> . ");
            sparql.append("?").append("r_subject").append(" <").append("http://eagle-i.org/ont/repo/1.0/").append("hasWorkflowState> ?").append("r_state");
            sparql.append("} . ");
        } else {
            sparql.append("OPTIONAL {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/repo/1.0/").append("hasWorkflowState> ?").append("r_state");
            sparql.append("} . ");
        }
        return sparql.toString();
    }

    public String labRestrictionPattern(EIURI lab) {
        StringBuilder sparql = new StringBuilder();
        if (!this.isNull(lab)) {
            sparql.append("?").append("r_subject").append(" ?labProperty ?").append("r_lab").append(" . ");
            sparql.append("?").append("r_lab").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_labName").append(" . ");
            sparql.append("?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . ");
            sparql.append("filter(?").append("r_lab").append(" = <").append(lab.toString()).append(">) . ");
        } else {
            sparql.append("OPTIONAL {?").append("r_subject").append(" ?labProperty ?").append("r_lab").append(" . ");
            sparql.append("?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . ");
            sparql.append("?").append("r_lab").append(" a <").append("http://purl.obolibrary.org/obo/ERO_0000001").append("> . ");
            sparql.append("?").append("r_lab").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_labName").append("} . ");
        }
        return sparql.toString();
    }

    public String getResourcesETLedFromFileQuery(String fileName) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX ").append("ei-dt").append(": <").append("http://eagle-i.org/ont/datatools/1.0/").append("> ");
        sparql.append(this.selectClause("resource"));
        sparql.append("?resource  ").append("ei-dt").append(":source_file  \"").append(fileName).append("\".}");
        return sparql.toString();
    }

    public String orderByLabelClosingClause() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("} order by <").append("http://eagle-i.org/ont/repo/1.0/").append("upperCaseStr>(?").append("r_label").append(")");
        return sparql.toString();
    }

    private boolean isNull(EIURI uri) {
        return uri == null || uri.equals((Object)EIURI.NULL_EIURI) || "".equals(uri.toString());
    }

    public String modifiedDatePattern() {
        return " OPTIONAL {?r_subject <http://purl.org/dc/terms/modified> ?r_last_modified} .";
    }

    public String getModifiedDateQuery(EIURI uri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.selectClause("r_last_modified"));
        sparql.append("<").append(uri).append(">  <http://purl.org/dc/terms/modified> ?").append("r_last_modified");
        sparql.append(" }");
        return sparql.toString();
    }

    public String additionalLabelsPattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("OPTIONAL {?").append("r_state").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_stateLabel").append("} . ");
        sparql.append("OPTIONAL {?").append("r_type").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_typeLabel").append("} . ");
        return sparql.toString();
    }

    public String getStubPattern(boolean isOptional) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("OPTIONAL {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/datatools/1.0/is_stub").append("> ");
        sparql.append("?r_is_stub");
        sparql.append(" } . ");
        if (!isOptional) {
            sparql.append(" {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/datatools/1.0/is_stub").append("> ");
            sparql.append("'True'} . ");
        }
        return sparql.toString();
    }

    public String getRetrieveStubsQuery(EIURI mainUri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.selectClause(Arrays.asList("r_subject", "r_label")));
        sparql.append("<").append(mainUri.toString()).append("> ?anyPredicate ?").append("r_subject").append(" . ");
        sparql.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql.append("?").append("r_subject").append(" <").append("http://eagle-i.org/ont/datatools/1.0/is_stub").append("> ").append("'True' . ");
        sparql.append("}");
        return sparql.toString();
    }
}

