/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OWLProfile
extends AbstractProfile {
    private static Object[][] s_supportsCheckData = new Object[][]{{AllDifferent.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {AnnotationProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            Iterator<Resource> i = ((OntModel)((Object)g)).getProfile().getAnnotationProperties();
            while (i.hasNext()) {
                if (!i.next().asNode().equals(n)) continue;
                return true;
            }
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {OntClass.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph eg) {
            Graph g = eg.asGraph();
            return this.hasType(n, eg, new Resource[]{OWL.Class, OWL.Restriction, RDFS.Class, RDFS.Datatype}) || n.equals(OWL.Thing.asNode()) || n.equals(OWL.Nothing.asNode()) || g.contains(Node.ANY, RDFS.domain.asNode(), n) || g.contains(Node.ANY, RDFS.range.asNode(), n) || g.contains(n, OWL.intersectionOf.asNode(), Node.ANY) || g.contains(n, OWL.unionOf.asNode(), Node.ANY) || g.contains(n, OWL.complementOf.asNode(), Node.ANY);
        }
    }}, {DatatypeProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {ObjectProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return this.hasType(n, g, new Resource[]{OWL.ObjectProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty});
        }
    }}, {FunctionalProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {InverseFunctionalProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode());
        }
    }}, {RDFList.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return n.equals(RDF.nil.asNode()) || g.asGraph().contains(n, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return this.hasType(n, g, new Resource[]{RDF.Property, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.AnnotationProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty, OWL.FunctionalProperty});
        }
    }}, {Ontology.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {Restriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {HasValueRestriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(g, n, OWL.hasValue) && OWLProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {AllValuesFromRestriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(g, n, OWL.allValuesFrom) && OWLProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {SomeValuesFromRestriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(g, n, OWL.someValuesFrom) && OWLProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {CardinalityRestriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(g, n, OWL.cardinality) && OWLProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {MinCardinalityRestriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(g, n, OWL.minCardinality) && OWLProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {MaxCardinalityRestriction.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(g, n, OWL.maxCardinality) && OWLProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {SymmetricProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {TransitiveProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {Individual.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return n instanceof Node_URI || n instanceof Node_Blank;
        }
    }}, {DataRange.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return n instanceof Node_Blank && g.asGraph().contains(n, RDF.type.asNode(), OWL.DataRange.asNode());
        }
    }}};
    private static HashMap<Class<?>, SupportsCheck> s_supportsChecks = new HashMap();

    @Override
    public String NAMESPACE() {
        return OWL.getURI();
    }

    @Override
    public Resource CLASS() {
        return OWL.Class;
    }

    @Override
    public Resource RESTRICTION() {
        return OWL.Restriction;
    }

    @Override
    public Resource THING() {
        return OWL.Thing;
    }

    @Override
    public Resource NOTHING() {
        return OWL.Nothing;
    }

    @Override
    public Resource PROPERTY() {
        return RDF.Property;
    }

    @Override
    public Resource OBJECT_PROPERTY() {
        return OWL.ObjectProperty;
    }

    @Override
    public Resource DATATYPE_PROPERTY() {
        return OWL.DatatypeProperty;
    }

    @Override
    public Resource TRANSITIVE_PROPERTY() {
        return OWL.TransitiveProperty;
    }

    @Override
    public Resource SYMMETRIC_PROPERTY() {
        return OWL.SymmetricProperty;
    }

    @Override
    public Resource FUNCTIONAL_PROPERTY() {
        return OWL.FunctionalProperty;
    }

    @Override
    public Resource INVERSE_FUNCTIONAL_PROPERTY() {
        return OWL.InverseFunctionalProperty;
    }

    @Override
    public Resource ALL_DIFFERENT() {
        return OWL.AllDifferent;
    }

    @Override
    public Resource ONTOLOGY() {
        return OWL.Ontology;
    }

    @Override
    public Resource DEPRECATED_CLASS() {
        return OWL.DeprecatedClass;
    }

    @Override
    public Resource DEPRECATED_PROPERTY() {
        return OWL.DeprecatedProperty;
    }

    @Override
    public Resource ANNOTATION_PROPERTY() {
        return OWL.AnnotationProperty;
    }

    @Override
    public Resource ONTOLOGY_PROPERTY() {
        return OWL.OntologyProperty;
    }

    @Override
    public Resource LIST() {
        return RDF.List;
    }

    @Override
    public Resource NIL() {
        return RDF.nil;
    }

    @Override
    public Resource DATARANGE() {
        return OWL.DataRange;
    }

    @Override
    public Property EQUIVALENT_PROPERTY() {
        return OWL.equivalentProperty;
    }

    @Override
    public Property EQUIVALENT_CLASS() {
        return OWL.equivalentClass;
    }

    @Override
    public Property DISJOINT_WITH() {
        return OWL.disjointWith;
    }

    @Override
    public Property SAME_INDIVIDUAL_AS() {
        return null;
    }

    @Override
    public Property SAME_AS() {
        return OWL.sameAs;
    }

    @Override
    public Property DIFFERENT_FROM() {
        return OWL.differentFrom;
    }

    @Override
    public Property DISTINCT_MEMBERS() {
        return OWL.distinctMembers;
    }

    @Override
    public Property UNION_OF() {
        return OWL.unionOf;
    }

    @Override
    public Property INTERSECTION_OF() {
        return OWL.intersectionOf;
    }

    @Override
    public Property COMPLEMENT_OF() {
        return OWL.complementOf;
    }

    @Override
    public Property ONE_OF() {
        return OWL.oneOf;
    }

    @Override
    public Property ON_PROPERTY() {
        return OWL.onProperty;
    }

    @Override
    public Property ALL_VALUES_FROM() {
        return OWL.allValuesFrom;
    }

    @Override
    public Property HAS_VALUE() {
        return OWL.hasValue;
    }

    @Override
    public Property SOME_VALUES_FROM() {
        return OWL.someValuesFrom;
    }

    @Override
    public Property MIN_CARDINALITY() {
        return OWL.minCardinality;
    }

    @Override
    public Property MAX_CARDINALITY() {
        return OWL.maxCardinality;
    }

    @Override
    public Property CARDINALITY() {
        return OWL.cardinality;
    }

    @Override
    public Property INVERSE_OF() {
        return OWL.inverseOf;
    }

    @Override
    public Property IMPORTS() {
        return OWL.imports;
    }

    @Override
    public Property PRIOR_VERSION() {
        return OWL.priorVersion;
    }

    @Override
    public Property BACKWARD_COMPATIBLE_WITH() {
        return OWL.backwardCompatibleWith;
    }

    @Override
    public Property INCOMPATIBLE_WITH() {
        return OWL.incompatibleWith;
    }

    @Override
    public Property SUB_PROPERTY_OF() {
        return RDFS.subPropertyOf;
    }

    @Override
    public Property SUB_CLASS_OF() {
        return RDFS.subClassOf;
    }

    @Override
    public Property DOMAIN() {
        return RDFS.domain;
    }

    @Override
    public Property RANGE() {
        return RDFS.range;
    }

    @Override
    public Property FIRST() {
        return RDF.first;
    }

    @Override
    public Property REST() {
        return RDF.rest;
    }

    @Override
    public Property MIN_CARDINALITY_Q() {
        return null;
    }

    @Override
    public Property MAX_CARDINALITY_Q() {
        return null;
    }

    @Override
    public Property CARDINALITY_Q() {
        return null;
    }

    @Override
    public Property HAS_CLASS_Q() {
        return null;
    }

    @Override
    public Property VERSION_INFO() {
        return OWL.versionInfo;
    }

    @Override
    public Property LABEL() {
        return RDFS.label;
    }

    @Override
    public Property COMMENT() {
        return RDFS.comment;
    }

    @Override
    public Property SEE_ALSO() {
        return RDFS.seeAlso;
    }

    @Override
    public Property IS_DEFINED_BY() {
        return RDFS.isDefinedBy;
    }

    @Override
    protected Resource[][] aliasTable() {
        return new Resource[0][];
    }

    @Override
    public Iterator<Resource> getAxiomTypes() {
        return Arrays.asList(OWL.AllDifferent).iterator();
    }

    @Override
    public Iterator<Resource> getAnnotationProperties() {
        return Arrays.asList(OWL.versionInfo, RDFS.label, RDFS.seeAlso, RDFS.comment, RDFS.isDefinedBy).iterator();
    }

    @Override
    public Iterator<Resource> getClassDescriptionTypes() {
        return Arrays.asList(OWL.Class, OWL.Restriction).iterator();
    }

    @Override
    public <T> boolean isSupported(Node n, EnhGraph g, Class<T> type) {
        if (g instanceof OntModel) {
            OntModel m = (OntModel)((Object)g);
            if (!m.strictMode()) {
                return true;
            }
            SupportsCheck check = this.getCheckTable().get(type);
            return check != null && check.doCheck(n, g);
        }
        return false;
    }

    @Override
    public String getLabel() {
        return "OWL Full";
    }

    public static boolean containsSome(EnhGraph g, Node n, Property p) {
        return AbstractProfile.containsSome(g, n, p);
    }

    protected Map<Class<?>, SupportsCheck> getCheckTable() {
        return s_supportsChecks;
    }

    static {
        for (int i = 0; i < s_supportsCheckData.length; ++i) {
            s_supportsChecks.put((Class)s_supportsCheckData[i][0], (SupportsCheck)s_supportsCheckData[i][1]);
        }
    }

    protected static class SupportsCheck {
        protected SupportsCheck() {
        }

        public boolean doCheck(Node n, EnhGraph g) {
            return true;
        }

        public Set<Node> allTypes(Node n, EnhGraph g) {
            HashSet<Node> types = new HashSet<Node>();
            ExtendedIterator<Triple> i = g.asGraph().find(n, RDF.type.asNode(), Node.ANY);
            while (i.hasNext()) {
                types.add(((Triple)i.next()).getObject());
            }
            return types;
        }

        public boolean intersect(Set<Node> nodes, Resource[] ref) {
            for (Resource r : ref) {
                if (!nodes.contains(r.asNode())) continue;
                return true;
            }
            return false;
        }

        public boolean hasType(Node n, EnhGraph g, Resource[] ref) {
            return this.intersect(this.allTypes(n, g), ref);
        }
    }
}

