/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.impl.LiteralLabelFactory;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelListenerAdapter;
import com.hp.hpl.jena.rdf.model.impl.ModelReifier;
import com.hp.hpl.jena.rdf.model.impl.NsIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelCom
extends EnhGraph
implements Model,
PrefixMapping,
Lock {
    private static final RDFReaderF readerFactory = new RDFReaderFImpl();
    private static final RDFWriterF writerFactory = new RDFWriterFImpl();
    private Lock modelLock = null;
    private static PrefixMapping defaultPrefixMapping = PrefixMapping.Factory.create();
    protected ModelReifier modelReifier = new ModelReifier(this);
    private Map1<Statement, Triple> mapAsTriple = new Map1<Statement, Triple>(){

        @Override
        public Triple map1(Statement s) {
            return s.asTriple();
        }
    };
    protected Map1<Triple, Statement> mapAsStatement = new Map1<Triple, Statement>(){

        @Override
        public Statement map1(Triple t) {
            return ModelCom.this.asStatement(t);
        }
    };

    public ModelCom(Graph base) {
        this(base, BuiltinPersonalities.model);
    }

    public ModelCom(Graph base, Personality<RDFNode> personality) {
        super(base, personality);
        this.withDefaultMappings(defaultPrefixMapping);
    }

    public static PrefixMapping getDefaultModelPrefixes() {
        return defaultPrefixMapping;
    }

    public static PrefixMapping setDefaultModelPrefixes(PrefixMapping pm) {
        PrefixMapping result = defaultPrefixMapping;
        defaultPrefixMapping = pm;
        return result;
    }

    @Override
    public QueryHandler queryHandler() {
        return this.getGraph().queryHandler();
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    protected static Model createWorkModel() {
        return ModelFactory.createDefaultModel();
    }

    @Override
    public RDFNode asRDFNode(Node n) {
        return n.isLiteral() ? this.getNodeAs(n, Literal.class) : this.getNodeAs(n, Resource.class);
    }

    @Override
    @Deprecated
    public Resource getResource(String uri, ResourceF f) {
        try {
            return f.createResource(this.getResource(uri));
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    @Override
    public Model addLiteral(Resource s, Property p, boolean o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, long o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, int o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, char o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, float o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, double o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model add(Resource s, Property p, String o) {
        return this.add(s, p, o, "", false);
    }

    @Override
    public Model add(Resource s, Property p, String o, boolean wellFormed) {
        this.add(s, p, this.literal(o, "", wellFormed));
        return this;
    }

    public Model add(Resource s, Property p, String o, String lang, boolean wellFormed) {
        this.add(s, p, this.literal(o, lang, wellFormed));
        return this;
    }

    @Override
    public Model add(Resource s, Property p, String lex, RDFDatatype datatype) {
        this.add(s, p, this.literal(lex, datatype));
        return this;
    }

    private Literal literal(String s, String lang, boolean wellFormed) {
        return new LiteralImpl(Node.createLiteral(s, lang, wellFormed), this);
    }

    private Literal literal(String lex, RDFDatatype datatype) {
        return new LiteralImpl(Node.createLiteral(lex, "", datatype), this);
    }

    @Override
    public Model add(Resource s, Property p, String o, String l) {
        return this.add(s, p, o, l, false);
    }

    @Override
    @Deprecated
    public Model addLiteral(Resource s, Property p, Object o) {
        return this.add(s, p, this.asObject(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, Literal o) {
        return this.add(s, p, o);
    }

    private RDFNode asObject(Object o) {
        return o instanceof RDFNode ? (RDFNode)o : this.createTypedLiteral(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model add(StmtIterator iter) {
        try {
            this.getBulkUpdateHandler().add(this.asTriples(iter));
        }
        finally {
            iter.close();
        }
        return this;
    }

    @Override
    public Model add(Model m) {
        return this.add(m, false);
    }

    @Override
    public Model add(Model m, boolean suppressReifications) {
        this.getBulkUpdateHandler().add(m.getGraph(), !suppressReifications);
        return this;
    }

    @Override
    public RDFReader getReader() {
        return readerFactory.getReader();
    }

    @Override
    public RDFReader getReader(String lang) {
        return readerFactory.getReader(lang);
    }

    @Override
    public String setReaderClassName(String lang, String className) {
        return readerFactory.setReaderClassName(lang, className);
    }

    @Override
    public Model read(String url) {
        readerFactory.getReader().read(this, url);
        return this;
    }

    @Override
    public Model read(Reader reader, String base) {
        readerFactory.getReader().read((Model)this, reader, base);
        return this;
    }

    @Override
    public Model read(InputStream reader, String base) {
        readerFactory.getReader().read((Model)this, reader, base);
        return this;
    }

    @Override
    public Model read(String url, String lang) {
        readerFactory.getReader(lang).read(this, url);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(String url, String base, String lang) {
        try {
            InputStream is = new URL(url).openStream();
            try {
                this.read(is, base, lang);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        return this;
    }

    @Override
    public Model read(Reader reader, String base, String lang) {
        readerFactory.getReader(lang).read((Model)this, reader, base);
        return this;
    }

    @Override
    public Model read(InputStream reader, String base, String lang) {
        readerFactory.getReader(lang).read((Model)this, reader, base);
        return this;
    }

    @Override
    public RDFWriter getWriter() {
        return writerFactory.getWriter();
    }

    @Override
    public RDFWriter getWriter(String lang) {
        return writerFactory.getWriter(lang);
    }

    @Override
    public String setWriterClassName(String lang, String className) {
        return writerFactory.setWriterClassName(lang, className);
    }

    @Override
    public Model write(Writer writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(Writer writer, String lang) {
        this.getWriter(lang).write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(Writer writer, String lang, String base) {
        this.getWriter(lang).write((Model)this, writer, base);
        return this;
    }

    @Override
    public Model write(OutputStream writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(OutputStream writer, String lang) {
        this.getWriter(lang).write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(OutputStream writer, String lang, String base) {
        this.getWriter(lang).write((Model)this, writer, base);
        return this;
    }

    @Override
    public Model remove(Statement s) {
        this.graph.delete(s.asTriple());
        return this;
    }

    @Override
    public Model remove(Resource s, Property p, RDFNode o) {
        this.graph.delete(Triple.create(s.asNode(), p.asNode(), o.asNode()));
        return this;
    }

    @Override
    public Model remove(StmtIterator iter) {
        this.getBulkUpdateHandler().delete(this.asTriples(iter));
        return this;
    }

    @Override
    public Model remove(Model m) {
        return this.remove(m, false);
    }

    @Override
    public Model remove(Model m, boolean suppressReifications) {
        this.getBulkUpdateHandler().delete(m.getGraph(), !suppressReifications);
        return this;
    }

    @Override
    public Model removeAll() {
        this.getGraph().getBulkUpdateHandler().removeAll();
        return this;
    }

    @Override
    public Model removeAll(Resource s, Property p, RDFNode o) {
        this.getGraph().getBulkUpdateHandler().remove(ModelCom.asNode(s), ModelCom.asNode(p), ModelCom.asNode(o));
        return this;
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, boolean o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, long o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, int o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, char o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, float o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, double o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean contains(Resource s, Property p, String o) {
        return this.contains(s, p, o, "");
    }

    @Override
    public boolean contains(Resource s, Property p, String o, String l) {
        return this.contains(s, p, this.literal(o, l, false));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, Object o) {
        return this.contains(s, p, this.asObject(o));
    }

    @Override
    public boolean containsAny(Model model) {
        return this.containsAnyThenClose(model.listStatements());
    }

    @Override
    public boolean containsAll(Model model) {
        return this.containsAllThenClose(model.listStatements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAnyThenClose(StmtIterator iter) {
        try {
            boolean bl = this.containsAny(iter);
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAllThenClose(StmtIterator iter) {
        try {
            boolean bl = this.containsAll(iter);
            return bl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean containsAny(StmtIterator iter) {
        while (iter.hasNext()) {
            if (!this.contains(iter.nextStatement())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(StmtIterator iter) {
        while (iter.hasNext()) {
            if (this.contains(iter.nextStatement())) continue;
            return false;
        }
        return true;
    }

    protected StmtIterator listStatements(Resource S, Property P, Node O) {
        return IteratorFactory.asStmtIterator(this.graph.find(ModelCom.asNode(S), ModelCom.asNode(P), O), this);
    }

    @Override
    public StmtIterator listStatements(Resource S, Property P, RDFNode O) {
        return this.listStatements(S, P, ModelCom.asNode(O));
    }

    @Override
    public StmtIterator listStatements(Resource S, Property P, String O) {
        return O == null ? this.listStatements(S, P, Node.ANY) : this.listStatements(S, P, Node.createLiteral(O));
    }

    @Override
    public StmtIterator listStatements(Resource S, Property P, String O, String L) {
        return O == null ? this.listStatements(S, P, Node.ANY) : this.listStatements(S, P, Node.createLiteral(O, L, false));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, boolean O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, long O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, char O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, float O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, double O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, boolean o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, char o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, long o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, float o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, double o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, Object o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p, RDFNode o) {
        return this.listResourcesWithProperty(p, o);
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p, String o) {
        return this.listSubjectsWithProperty(p, o, "");
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p, String o, String l) {
        return this.listResourcesWithProperty(p, this.literal(o, l, false));
    }

    @Override
    public Resource createResource(Resource type) {
        return this.createResource().addProperty(RDF.type, type);
    }

    @Override
    public Resource createResource(String uri, Resource type) {
        return this.getResource(uri).addProperty(RDF.type, type);
    }

    @Override
    @Deprecated
    public Resource createResource(ResourceF f) {
        return this.createResource(null, f);
    }

    @Override
    public Resource createResource(AnonId id) {
        return new ResourceImpl(id, this);
    }

    @Override
    @Deprecated
    public Resource createResource(String uri, ResourceF f) {
        return f.createResource(this.createResource(uri));
    }

    @Override
    public Literal createTypedLiteral(boolean v) {
        return this.createTypedLiteral(new Boolean(v));
    }

    @Override
    public Literal createTypedLiteral(int v) {
        return this.createTypedLiteral(new Integer(v));
    }

    @Override
    public Literal createTypedLiteral(long v) {
        return this.createTypedLiteral(new Long(v));
    }

    @Override
    public Literal createTypedLiteral(char v) {
        return this.createTypedLiteral(new Character(v));
    }

    @Override
    public Literal createTypedLiteral(float v) {
        return this.createTypedLiteral(new Float(v));
    }

    @Override
    public Literal createTypedLiteral(double v) {
        return this.createTypedLiteral(new Double(v));
    }

    @Override
    public Literal createTypedLiteral(String v) {
        LiteralLabel ll = LiteralLabelFactory.create(v);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(Calendar cal) {
        XSDDateTime value = new XSDDateTime(cal);
        LiteralLabel ll = LiteralLabelFactory.create(value, "", XSDDatatype.XSDdateTime);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return new LiteralImpl(Node.createLiteral(lex, "", dtype), this);
    }

    @Override
    public Literal createTypedLiteral(Object value, RDFDatatype dtype) {
        LiteralLabel ll = LiteralLabelFactory.create(value, "", dtype);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(String lex, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        LiteralLabel ll = LiteralLabelFactory.createLiteralLabel(lex, "", dt);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(Object value, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        LiteralLabel ll = LiteralLabelFactory.create(value, "", dt);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(Object value) {
        if (value instanceof Calendar) {
            return this.createTypedLiteral((Calendar)value);
        }
        LiteralLabel ll = LiteralLabelFactory.create(value);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    @Override
    public Literal createLiteral(String v) {
        return this.createLiteral(v, "");
    }

    @Override
    public Literal createLiteral(String v, String l) {
        return this.literal(v, l, false);
    }

    @Override
    public Literal createLiteral(String v, boolean wellFormed) {
        return this.literal(v, "", wellFormed);
    }

    public Literal createLiteral(String v, String l, boolean wellFormed) {
        return this.literal(v, l, wellFormed);
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, boolean o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, long o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, int o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, char o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, float o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, double o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, Object o) {
        return this.createStatement(r, p, this.asObject(o));
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o, boolean wellFormed) {
        return this.createStatement(r, p, o, "", wellFormed);
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o, String l) {
        return this.createStatement(r, p, o, l, false);
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o, String l, boolean wellFormed) {
        return this.createStatement(r, p, this.literal(o, l, wellFormed));
    }

    @Override
    public Bag createBag() {
        return this.createBag(null);
    }

    @Override
    public Alt createAlt() {
        return this.createAlt(null);
    }

    @Override
    public Seq createSeq() {
        return this.createSeq(null);
    }

    @Override
    public RDFList createList() {
        return this.getResource(RDF.nil.getURI()).as(RDFList.class);
    }

    @Override
    public RDFList createList(Iterator<? extends RDFNode> members) {
        RDFList list = this.createList();
        while (members != null && members.hasNext()) {
            list = list.with(members.next());
        }
        return list;
    }

    @Override
    public RDFList createList(RDFNode[] members) {
        return this.createList(Arrays.asList(members).iterator());
    }

    @Override
    public RDFNode getRDFNode(Node n) {
        return this.asRDFNode(n);
    }

    @Override
    public Resource getResource(String uri) {
        return IteratorFactory.asResource(ModelCom.makeURI(uri), this);
    }

    @Override
    public Property getProperty(String uri) {
        if (uri == null) {
            throw new InvalidPropertyURIException(null);
        }
        return IteratorFactory.asProperty(ModelCom.makeURI(uri), this);
    }

    @Override
    public Property getProperty(String nameSpace, String localName) {
        return this.getProperty(nameSpace + localName);
    }

    @Override
    public Seq getSeq(String uri) {
        return (Seq)IteratorFactory.asResource(ModelCom.makeURI(uri), Seq.class, this);
    }

    @Override
    public Seq getSeq(Resource r) {
        return r.as(Seq.class);
    }

    @Override
    public Bag getBag(String uri) {
        return (Bag)IteratorFactory.asResource(ModelCom.makeURI(uri), Bag.class, this);
    }

    @Override
    public Bag getBag(Resource r) {
        return r.as(Bag.class);
    }

    private static Node makeURI(String uri) {
        return uri == null ? Node.createAnon() : Node.createURI(uri);
    }

    @Override
    public Alt getAlt(String uri) {
        return (Alt)IteratorFactory.asResource(ModelCom.makeURI(uri), Alt.class, this);
    }

    @Override
    public Alt getAlt(Resource r) {
        return r.as(Alt.class);
    }

    @Override
    public long size() {
        return this.graph.size();
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    private void updateNamespace(Set<String> set, Iterator<Node> it) {
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isURI()) continue;
            String uri = node.getURI();
            String ns = uri.substring(0, Util.splitNamespace(uri));
            set.add(ns);
        }
    }

    private Iterator<Node> listPredicates() {
        return this.getGraph().queryHandler().predicatesFor(Node.ANY, Node.ANY);
    }

    private Iterator<Node> listTypes() {
        Set types = CollectionFactory.createHashedSet();
        ExtendedIterator<Triple> it = this.graph.find(null, RDF.type.asNode(), null);
        while (it.hasNext()) {
            types.add(((Triple)it.next()).getObject());
        }
        return types.iterator();
    }

    @Override
    public NsIterator listNameSpaces() {
        Set<String> nameSpaces = CollectionFactory.createHashedSet();
        this.updateNamespace(nameSpaces, this.listPredicates());
        this.updateNamespace(nameSpaces, this.listTypes());
        return new NsIteratorImpl(nameSpaces.iterator(), nameSpaces);
    }

    private PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getPrefixMapping().samePrefixMappingAs(other);
    }

    @Override
    public PrefixMapping lock() {
        this.getPrefixMapping().lock();
        return this;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.getPrefixMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.getPrefixMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping pm) {
        this.getPrefixMapping().setNsPrefixes(pm);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        this.getPrefixMapping().withDefaultMappings(other);
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.getPrefixMapping().getNsPrefixURI(prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.getPrefixMapping().getNsURIPrefix(uri);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.getPrefixMapping().getNsPrefixMap();
    }

    @Override
    public String expandPrefix(String prefixed) {
        return this.getPrefixMapping().expandPrefix(prefixed);
    }

    @Override
    public String qnameFor(String uri) {
        return this.getPrefixMapping().qnameFor(uri);
    }

    @Override
    public String shortForm(String uri) {
        return this.getPrefixMapping().shortForm(uri);
    }

    public static void addNamespaces(Model m, Map<String, Set<String>> ns) {
        Model pm = m;
        for (Map.Entry<String, Set<String>> e : ns.entrySet()) {
            String key = e.getKey();
            Set<String> values = e.getValue();
            Set niceValues = CollectionFactory.createHashedSet();
            for (String uri : values) {
                if (!PrefixMappingImpl.isNiceURI(uri)) continue;
                niceValues.add(uri);
            }
            if (niceValues.size() != 1) continue;
            pm.setNsPrefix(key, (String)niceValues.iterator().next());
        }
    }

    @Override
    public StmtIterator listStatements() {
        return IteratorFactory.asStmtIterator(GraphUtil.findAll(this.graph), this);
    }

    @Override
    public Model add(Statement s) {
        this.add(s.getSubject(), s.getPredicate(), s.getObject());
        return this;
    }

    @Override
    public Model add(Statement[] statements) {
        this.getBulkUpdateHandler().add(StatementImpl.asTriples(statements));
        return this;
    }

    protected BulkUpdateHandler getBulkUpdateHandler() {
        return this.getGraph().getBulkUpdateHandler();
    }

    @Override
    public Model add(List<Statement> statements) {
        this.getBulkUpdateHandler().add(this.asTriples(statements));
        return this;
    }

    private List<Triple> asTriples(List<Statement> statements) {
        ArrayList<Triple> L = new ArrayList<Triple>(statements.size());
        for (int i = 0; i < statements.size(); ++i) {
            L.add(statements.get(i).asTriple());
        }
        return L;
    }

    private Iterator<Triple> asTriples(StmtIterator it) {
        return it.mapWith(this.mapAsTriple);
    }

    @Override
    public Model remove(Statement[] statements) {
        this.getBulkUpdateHandler().delete(StatementImpl.asTriples(statements));
        return this;
    }

    @Override
    public Model remove(List<Statement> statements) {
        this.getBulkUpdateHandler().delete(this.asTriples(statements));
        return this;
    }

    @Override
    public Model add(Resource s, Property p, RDFNode o) {
        this.modelReifier.noteIfReified(s, p, o);
        this.graph.add(Triple.create(s.asNode(), p.asNode(), o.asNode()));
        return this;
    }

    @Override
    public ReificationStyle getReificationStyle() {
        return this.modelReifier.getReificationStyle();
    }

    @Override
    public RSIterator listReifiedStatements() {
        return this.modelReifier.listReifiedStatements();
    }

    @Override
    public RSIterator listReifiedStatements(Statement st) {
        return this.modelReifier.listReifiedStatements(st);
    }

    @Override
    public boolean isReified(Statement s) {
        return this.modelReifier.isReified(s);
    }

    @Override
    public Resource getAnyReifiedStatement(Statement s) {
        return this.modelReifier.getAnyReifiedStatement(s);
    }

    @Override
    public void removeAllReifications(Statement s) {
        this.modelReifier.removeAllReifications(s);
    }

    @Override
    public void removeReification(ReifiedStatement rs) {
        this.modelReifier.removeReification(rs);
    }

    @Override
    public ReifiedStatement createReifiedStatement(Statement s) {
        return this.modelReifier.createReifiedStatement(s);
    }

    @Override
    public ReifiedStatement createReifiedStatement(String uri, Statement s) {
        return this.modelReifier.createReifiedStatement(uri, s);
    }

    @Override
    public boolean contains(Statement s) {
        return this.graph.contains(s.asTriple());
    }

    @Override
    public boolean containsResource(RDFNode r) {
        return this.graph.queryHandler().containsNode(r.asNode());
    }

    @Override
    public boolean contains(Resource s, Property p) {
        return this.contains(s, p, (RDFNode)null);
    }

    @Override
    public boolean contains(Resource s, Property p, RDFNode o) {
        return this.graph.contains(ModelCom.asNode(s), ModelCom.asNode(p), ModelCom.asNode(o));
    }

    @Override
    public Statement getRequiredProperty(Resource s, Property p) {
        Statement st = this.getProperty(s, p);
        if (st == null) {
            throw new PropertyNotFoundException(p);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getProperty(Resource s, Property p) {
        StmtIterator iter = this.listStatements(s, p, (RDFNode)null);
        try {
            Statement statement = iter.hasNext() ? iter.nextStatement() : null;
            return statement;
        }
        finally {
            iter.close();
        }
    }

    public static Node asNode(RDFNode x) {
        return x == null ? Node.ANY : x.asNode();
    }

    private NodeIterator listObjectsFor(RDFNode s, RDFNode p) {
        ExtendedIterator<Node> xit = this.graph.queryHandler().objectsFor(ModelCom.asNode(s), ModelCom.asNode(p));
        return IteratorFactory.asRDFNodeIterator(xit, this);
    }

    private ResIterator listSubjectsFor(RDFNode p, RDFNode o) {
        ExtendedIterator<Node> xit = this.graph.queryHandler().subjectsFor(ModelCom.asNode(p), ModelCom.asNode(o));
        return IteratorFactory.asResIterator(xit, this);
    }

    @Override
    public ResIterator listSubjects() {
        return this.listSubjectsFor(null, null);
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p) {
        return this.listSubjectsFor(p, null);
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p) {
        return this.listResourcesWithProperty(p);
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, RDFNode o) {
        return this.listSubjectsFor(p, o);
    }

    @Override
    public NodeIterator listObjects() {
        return this.listObjectsFor(null, null);
    }

    @Override
    public NodeIterator listObjectsOfProperty(Property p) {
        return this.listObjectsFor(null, p);
    }

    @Override
    public NodeIterator listObjectsOfProperty(Resource s, Property p) {
        return this.listObjectsFor(s, p);
    }

    @Override
    public StmtIterator listStatements(Selector selector) {
        StmtIterator sts = IteratorFactory.asStmtIterator(this.findTriplesFrom(selector), this);
        return selector.isSimple() ? sts : new StmtIteratorImpl((Iterator<Statement>)sts.filterKeep(this.asFilter(selector)));
    }

    public Filter<Statement> asFilter(final Selector s) {
        return new Filter<Statement>(){

            @Override
            public boolean accept(Statement x) {
                return s.test(x);
            }
        };
    }

    public ExtendedIterator<Triple> findTriplesFrom(Selector s) {
        return this.graph.find(ModelCom.asNode(s.getSubject()), ModelCom.asNode(s.getPredicate()), ModelCom.asNode(s.getObject()));
    }

    @Override
    public boolean supportsTransactions() {
        return this.getTransactionHandler().transactionsSupported();
    }

    @Override
    public Model begin() {
        this.getTransactionHandler().begin();
        return this;
    }

    @Override
    public Model abort() {
        this.getTransactionHandler().abort();
        return this;
    }

    @Override
    public Model commit() {
        this.getTransactionHandler().commit();
        return this;
    }

    @Override
    public Object executeInTransaction(Command cmd) {
        return this.getTransactionHandler().executeInTransaction(cmd);
    }

    private TransactionHandler getTransactionHandler() {
        return this.getGraph().getTransactionHandler();
    }

    @Override
    public boolean independent() {
        return true;
    }

    @Override
    public Resource createResource() {
        return IteratorFactory.asResource(Node.createAnon(), this);
    }

    @Override
    public Resource createResource(String uri) {
        return this.getResource(uri);
    }

    @Override
    public Property createProperty(String uri) {
        return this.getProperty(uri);
    }

    @Override
    public Property createProperty(String nameSpace, String localName) {
        return this.getProperty(nameSpace, localName);
    }

    @Override
    public Statement createStatement(Resource r, Property p, RDFNode o) {
        return new StatementImpl(r, p, o, this);
    }

    @Override
    public Bag createBag(String uri) {
        return (Bag)this.getBag(uri).addProperty(RDF.type, RDF.Bag);
    }

    @Override
    public Alt createAlt(String uri) {
        return (Alt)this.getAlt(uri).addProperty(RDF.type, RDF.Alt);
    }

    @Override
    public Seq createSeq(String uri) {
        return (Seq)this.getSeq(uri).addProperty(RDF.type, RDF.Seq);
    }

    @Override
    public Statement asStatement(Triple t) {
        return StatementImpl.toStatement(t, this);
    }

    public Statement[] asStatements(Triple[] triples) {
        Statement[] result = new Statement[triples.length];
        for (int i = 0; i < triples.length; ++i) {
            result[i] = this.asStatement(triples[i]);
        }
        return result;
    }

    public List<Statement> asStatements(List<Triple> triples) {
        ArrayList<Statement> L = new ArrayList<Statement>(triples.size());
        for (int i = 0; i < triples.size(); ++i) {
            L.add(this.asStatement(triples.get(i)));
        }
        return L;
    }

    public Model asModel(Graph g) {
        return new ModelCom(g);
    }

    public StmtIterator asStatements(Iterator<Triple> it) {
        return new StmtIteratorImpl((Iterator<Statement>)new Map1Iterator<Triple, Statement>(this.mapAsStatement, it));
    }

    public StmtIterator listBySubject(Container cont) {
        return this.listStatements((Resource)cont, null, (RDFNode)null);
    }

    @Override
    public void close() {
        this.graph.close();
    }

    @Override
    public boolean isClosed() {
        return this.graph.isClosed();
    }

    @Override
    public boolean supportsSetOperations() {
        return true;
    }

    @Override
    public Model query(Selector selector) {
        return ModelCom.createWorkModel().add(this.listStatements(selector));
    }

    @Override
    public Model union(Model model) {
        return ModelCom.createWorkModel().add(this).add(model);
    }

    @Override
    public Model intersection(Model other) {
        return this.size() < other.size() ? ModelCom.intersect(this, other) : ModelCom.intersect(other, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model intersect(Model smaller, Model larger) {
        Model result = ModelCom.createWorkModel();
        StmtIterator it = smaller.listStatements();
        try {
            Model model = ModelCom.addCommon(result, it, larger);
            return model;
        }
        finally {
            it.close();
        }
    }

    protected static Model addCommon(Model result, StmtIterator it, Model other) {
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!other.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model difference(Model model) {
        Model resultModel = ModelCom.createWorkModel();
        StmtIterator iter = null;
        try {
            iter = this.listStatements();
            while (iter.hasNext()) {
                Statement stmt = iter.nextStatement();
                if (model.contains(stmt)) continue;
                resultModel.add(stmt);
            }
            Model model2 = resultModel;
            return model2;
        }
        finally {
            iter.close();
        }
    }

    public String toString() {
        return "<ModelCom  " + this.getGraph() + " | " + this.reifiedToString() + ">";
    }

    public String reifiedToString() {
        return this.statementsToString(this.getHiddenStatements().listStatements());
    }

    protected String statementsToString(StmtIterator it) {
        StringBuffer b = new StringBuffer();
        while (it.hasNext()) {
            b.append(" ").append(it.nextStatement());
        }
        return b.toString();
    }

    public Model getHiddenStatements() {
        return this.modelReifier.getHiddenStatements();
    }

    @Override
    public boolean isIsomorphicWith(Model m) {
        Graph L = ModelFactory.withHiddenStatements(this).getGraph();
        Graph R = ModelFactory.withHiddenStatements(m).getGraph();
        return L.isIsomorphicWith(R);
    }

    public synchronized Lock getModelLock() {
        if (this.modelLock == null) {
            this.modelLock = new LockMRSW();
        }
        return this.modelLock;
    }

    @Override
    public synchronized Lock getLock() {
        return this.getModelLock();
    }

    @Override
    public void enterCriticalSection(boolean requestReadLock) {
        this.getModelLock().enterCriticalSection(requestReadLock);
    }

    @Override
    public void leaveCriticalSection() {
        this.getModelLock().leaveCriticalSection();
    }

    @Override
    public Model register(ModelChangedListener listener) {
        this.getGraph().getEventManager().register(this.adapt(listener));
        return this;
    }

    @Override
    public Model unregister(ModelChangedListener listener) {
        this.getGraph().getEventManager().unregister(this.adapt(listener));
        return this;
    }

    public GraphListener adapt(ModelChangedListener L) {
        return new ModelListenerAdapter(this, L);
    }

    @Override
    public Model notifyEvent(Object e) {
        this.getGraph().getEventManager().notifyEvent(this.getGraph(), e);
        return this;
    }
}

