/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface QueryProvider {
	/*
	 * 
	 */
	public List<EIInstanceMinimal> EIQuery(Session session, String sparql) throws RepositoryProviderException;

	public List<EIInstanceMinimal> listResourcesForObjectPropertyValue(final Session session, final EIURI classUri, final EIURI provider, final EIURI state, final boolean onlyProvider) throws RepositoryProviderException;
		
	public String retrieveLabel(Session session, EIURI uri) throws RepositoryProviderException;

	/*
	 * free-form SPARQL query to this provider
	 */
	public String query(Session session, String sparql) throws RepositoryProviderException;
}
