/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DBBulkUpdateHandler
implements BulkUpdateHandler {
    private GraphRDB graph;
    private GraphEventManager manager;
    protected static int CHUNK_SIZE = 50;

    public DBBulkUpdateHandler(GraphRDB graph) {
        this.graph = graph;
        this.manager = graph.getEventManager();
    }

    @Override
    public void add(Triple[] triples) {
        this.add(Arrays.asList(triples), false);
        this.manager.notifyAddArray(this.graph, triples);
    }

    @Override
    public void add(List<Triple> triples) {
        this.add(triples, true);
    }

    protected void add(List<Triple> triples, boolean notify) {
        this.graph.add(triples);
        if (notify) {
            this.manager.notifyAddList(this.graph, triples);
        }
    }

    @Override
    public void add(Iterator<Triple> it) {
        if (this.manager.listening()) {
            List<Triple> L = IteratorCollection.iteratorToList(it);
            this.add(L, false);
            this.manager.notifyAddIterator((Graph)this.graph, L);
        } else {
            this.addIterator(it);
        }
    }

    protected void addIterator(Iterator<Triple> it) {
        ArrayList<Triple> list = new ArrayList<Triple>(CHUNK_SIZE);
        while (it.hasNext()) {
            while (it.hasNext() && list.size() < CHUNK_SIZE) {
                list.add(it.next());
            }
            this.graph.add(list);
            list.clear();
        }
    }

    @Override
    public void add(Graph g) {
        this.add(g, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Graph g, boolean withReifications) {
        ExtendedIterator<Triple> triplesToAdd = GraphUtil.findAll(g);
        try {
            this.addIterator(triplesToAdd);
        }
        finally {
            NiceIterator.close(triplesToAdd);
        }
        if (withReifications) {
            SimpleBulkUpdateHandler.addReifications(this.graph, g);
        }
        this.manager.notifyAddGraph(this.graph, g);
    }

    @Override
    public void delete(Triple[] triples) {
        this.delete(Arrays.asList(triples), false);
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    @Override
    public void delete(List<Triple> triples) {
        this.delete(triples, true);
    }

    protected void delete(List<Triple> triples, boolean notify) {
        this.graph.delete(triples);
        if (notify) {
            this.manager.notifyDeleteList(this.graph, triples);
        }
    }

    @Override
    public void delete(Iterator<Triple> it) {
        if (this.manager.listening()) {
            List<Triple> L = IteratorCollection.iteratorToList(it);
            this.delete(L, false);
            this.manager.notifyDeleteIterator((Graph)this.graph, L);
        } else {
            this.deleteIterator(it);
        }
    }

    protected void deleteIterator(Iterator<Triple> it) {
        ArrayList<Triple> list = new ArrayList<Triple>(CHUNK_SIZE);
        while (it.hasNext()) {
            while (it.hasNext() && list.size() < CHUNK_SIZE) {
                list.add(it.next());
            }
            this.graph.delete(list);
            list.clear();
        }
    }

    @Override
    public void delete(Graph g) {
        this.delete(g, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Graph g, boolean withReifications) {
        ExtendedIterator<Triple> triplesToDelete = GraphUtil.findAll(g);
        try {
            this.deleteIterator(triplesToDelete);
        }
        finally {
            NiceIterator.close(triplesToDelete);
        }
        if (withReifications) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, g);
        }
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    @Override
    public void removeAll() {
        this.graph.clear();
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        SimpleBulkUpdateHandler.removeAll(this.graph, s, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
    }
}

