/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.Free;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier_RDB;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Bound;
import com.hp.hpl.jena.graph.query.Element;
import com.hp.hpl.jena.graph.query.Fixed;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.shared.BrokenException;
import java.util.ArrayList;
import java.util.List;

public class DBPattern {
    final Triple pattern;
    final Element S;
    final Element P;
    final Element O;
    private int Scost;
    private int Pcost;
    private int Ocost;
    private boolean isBusy;
    private boolean isConnected;
    private boolean isStmt;
    private boolean isReif;
    private List<SpecializedGraph> sources;
    private char subsumed;
    static final int costMax = 100;
    static final int costMin = 1;
    int costCur;
    private boolean costInit = true;
    private int freeVarCnt = 0;
    private int fixedCost = 0;
    private int boundCost = 0;
    private int unboundCost = 4;

    public DBPattern(Triple pat, Mapping varMap) {
        this.pattern = pat;
        this.sources = new ArrayList<SpecializedGraph>();
        this.isBusy = false;
        this.isConnected = false;
        this.isReif = false;
        this.isStmt = false;
        this.S = this.nodeToElement(this.pattern.getSubject(), varMap);
        this.P = this.nodeToElement(this.pattern.getPredicate(), varMap);
        this.O = this.nodeToElement(this.pattern.getObject(), varMap);
        this.Scost = this.elementCost(this.S);
        this.Pcost = this.elementCost(this.P);
        this.Ocost = this.elementCost(this.O);
    }

    public void setBusy() {
        if (this.isBusy) {
            throw new BrokenException("a DBPattern can be made busy at most once");
        }
        this.isBusy = true;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private Element nodeToElement(Node X, Mapping map) {
        if (X.equals(Query.ANY)) {
            return Element.ANY;
        }
        if (X.isVariable()) {
            if (map.hasBound(X)) {
                return new Bound(map.indexOf(X));
            }
            ++this.freeVarCnt;
            return new Free(X);
        }
        return new Fixed(X);
    }

    public void sourceAdd(SpecializedGraph sg, char sub) {
        if (this.sources.isEmpty()) {
            this.subsumed = sub;
            if (sg instanceof SpecializedGraphReifier_RDB) {
                this.isReif = true;
            } else {
                this.isStmt = true;
            }
        } else {
            if (this.subsumed != sub) {
                throw new RDFRDBException("Specialized graphs incorrectly subsume pattern");
            }
            if (sg instanceof SpecializedGraphReifier_RDB) {
                this.isStmt = false;
            } else {
                this.isReif = false;
            }
        }
        this.sources.add(sg);
    }

    public boolean hasSource() {
        return this.sources.size() > 0;
    }

    public boolean isSingleSource() {
        return this.sources.size() == 1;
    }

    public SpecializedGraph singleSource() {
        return this.sources.get(0);
    }

    protected void addFreeVars(List<VarDesc> varList) {
        if (this.freeVarCnt > 0) {
            if (this.S instanceof Free) {
                this.addVar(varList, (Free)this.S);
            }
            if (this.P instanceof Free) {
                this.addVar(varList, (Free)this.P);
            }
            if (this.O instanceof Free) {
                this.addVar(varList, (Free)this.O);
            }
        }
    }

    private int findVar(List<VarDesc> varList, Node_Variable var) {
        for (int i = 0; i < varList.size(); ++i) {
            Node_Variable v = varList.get((int)i).var;
            if (!var.equals(v)) continue;
            return i;
        }
        return -1;
    }

    private void addVar(List<VarDesc> varList, Free var) {
        int i = this.findVar(varList, var.var());
        if (i < 0) {
            i = varList.size();
            VarDesc vx = var.isArg() ? new VarDesc(var.var(), var.getMapping(), i) : new VarDesc(var.var(), i);
            varList.add(vx);
        }
        var.setListing(i);
    }

    public boolean joinsWith(DBPattern other, List<VarDesc> varList, boolean onlyStmt, boolean onlyReif, boolean implicitJoin) {
        boolean includesSource = other.isSingleSource() && this.sources.contains(other.sources.get(0));
        boolean newSourceTest = this.sources.containsAll(other.sources);
        if (includesSource && (!(this.P instanceof Free) || onlyStmt && this.isStmt)) {
            return this.appearsIn(this.S, varList) || this.appearsIn(this.O, varList) || onlyStmt && this.isStmt && this.appearsIn(this.P, varList) || implicitJoin && this.shareFixedSubject(other);
        }
        return false;
    }

    private boolean shareFixedSubject(DBPattern other) {
        boolean originalDefinition = this.S instanceof Fixed && other.S instanceof Fixed && this.S.match(null, other.S.asNodeMatch(null));
        return originalDefinition;
    }

    private boolean appearsIn(Element e, List<VarDesc> varList) {
        return e instanceof Free && this.findVar(varList, ((Free)e).var()) >= 0;
    }

    public int cost(Mapping varMap) {
        if (this.costInit) {
            this.costInit = false;
            this.costCur = this.costCalc();
        } else if (this.freeVarCnt > 0 && this.anyBound(varMap)) {
            this.costCur = this.costCalc();
        }
        return this.costCur;
    }

    protected boolean isArgCheck(Free v, Mapping map) {
        int ix = map.lookUp(v.var());
        if (ix >= 0) {
            v.setIsArg(ix);
            this.isConnected = true;
            --this.freeVarCnt;
            return true;
        }
        return false;
    }

    protected boolean anyBound(Mapping map) {
        boolean res = false;
        if (this.S instanceof Free && this.isArgCheck((Free)this.S, map)) {
            this.Scost = this.elementCost(this.S);
            res = true;
        }
        if (this.P instanceof Free && this.isArgCheck((Free)this.P, map)) {
            this.Pcost = this.elementCost(this.P);
            res = true;
        }
        if (this.O instanceof Free && this.isArgCheck((Free)this.O, map)) {
            this.Ocost = this.elementCost(this.O);
            res = true;
        }
        return res;
    }

    private int elementCost(Element x) {
        if (x instanceof Fixed) {
            return this.fixedCost;
        }
        if (x instanceof Bound) {
            return this.boundCost;
        }
        if (x instanceof Free && ((Free)x).isArg()) {
            return this.boundCost;
        }
        return this.unboundCost;
    }

    private int costCalc() {
        return this.Scost + this.Pcost + this.Ocost;
    }
}

