/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.rmi.server.UID;
import java.util.Iterator;
import java.util.Set;

public class GraphRDBMaker
extends BaseGraphMaker {
    protected IDBConnection c;
    protected Set<String> created = CollectionFactory.createHashedSet();
    int reificationStyle;
    protected Graph defaultGraph = null;
    private Filter<String> filterDEFAULT = new Filter<String>(){

        @Override
        public boolean accept(String x) {
            return "DEFAULT".equals(x);
        }
    };

    public GraphRDBMaker(IDBConnection c, ReificationStyle style) {
        super(style);
        this.c = c;
        this.reificationStyle = GraphRDB.styleRDB(style);
    }

    @Override
    public Graph getGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = this.consGraph(null, !this.c.containsDefaultModel());
        }
        return this.defaultGraph;
    }

    @Override
    public Graph openGraph() {
        if (this.defaultGraph != null) {
            return this.defaultGraph;
        }
        if (this.c.containsDefaultModel()) {
            this.defaultGraph = this.consGraph(null, false);
            return this.defaultGraph;
        }
        throw new DoesNotExistException("no default graph in this GraphMaker");
    }

    @Override
    public Graph createGraph() {
        return this.createGraph(this.freshGraphName(), false);
    }

    public String freshGraphName() {
        return "anon_" + new UID().toString();
    }

    @Override
    public Graph createGraph(String name, boolean strict) {
        this.created.add(name);
        boolean fresh = strict || !this.hasGraph(name);
        return this.consGraph(name, fresh);
    }

    @Override
    public Graph openGraph(String name, boolean strict) {
        boolean fresh;
        boolean bl = fresh = !this.hasGraph(name) && !strict;
        if (fresh) {
            this.created.add(name);
        }
        return this.consGraph(name, fresh);
    }

    protected Graph consGraph(String name, boolean fresh) {
        Graph p = this.c.getDefaultModelProperties().getGraph();
        return new GraphRDB(this.c, name, fresh ? p : null, this.reificationStyle, fresh);
    }

    @Override
    public void removeGraph(String name) {
        GraphRDB toDelete = (GraphRDB)this.openGraph(name, true);
        toDelete.remove();
        toDelete.close();
        this.created.remove(name);
    }

    @Override
    public boolean hasGraph(String name) {
        return this.c.containsModel(name);
    }

    public void removeAll() {
        Iterator<String> it = CollectionFactory.createHashedSet(this.created).iterator();
        while (it.hasNext()) {
            this.removeGraph(it.next());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ExtendedIterator<String> listGraphs() {
        return this.c.getAllModelNames().filterDrop(this.filterDEFAULT);
    }
}

