/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eaglei.datatools.jena.FooRepositorySecurityProvider;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.security.Session;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;

public class DataManagmentProvider
extends AbstractRepositoryProvider {
    private final JenaEIInstanceFactory instanceFactory;
    private final FooRepositorySecurityProvider securityProvider;
    private final String[] graphString = new String[]{"http://eagle-i.org/ont/repo/1.0/NG_Published", "http://eagle-i.org/ont/repo/1.0/NG_Withdrawn", "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace"};

    public DataManagmentProvider(JenaEIInstanceFactory instanceFactory, SecurityProvider generalSecurityProvider) {
        this.instanceFactory = instanceFactory;
        this.securityProvider = new FooRepositorySecurityProvider(generalSecurityProvider);
    }

    public void replaceResource(Session session, String addNewObjectQuery, String deleteOldObjectQuery) throws RepositoryProviderException {
        for (String namedGraph : this.graphString) {
            String addTripleGraphContent = this.queryOnlyDataGraphsWithInferredFalse(session, addNewObjectQuery, namedGraph);
            this.addNewTripleToGraph(session, addTripleGraphContent, namedGraph);
            String removeTripleGraphContent = this.queryOnlyDataGraphsWithInferredFalse(session, deleteOldObjectQuery, namedGraph);
            this.deleteOldTripleFromGraph(session, removeTripleGraphContent, namedGraph);
        }
    }

    public void replaceResourceByRegex(Session session, String constructQryByRegex, String regex, String replaceRegex) throws RepositoryProviderException {
        for (String namedGraph : this.graphString) {
            String addTripleGraphContent = this.queryOnlyDataGraphsWithInferredFalse(session, constructQryByRegex, namedGraph);
            String regexReplacedGraph = this.doRegexOperationOnGraph(addTripleGraphContent, regex, replaceRegex);
            this.addNewTripleToGraph(session, regexReplacedGraph, namedGraph);
            String removeTripleGraphContent = this.queryOnlyDataGraphsWithInferredFalse(session, constructQryByRegex, namedGraph);
            this.deleteOldTripleFromGraph(session, removeTripleGraphContent, namedGraph);
        }
    }

    private String doRegexOperationOnGraph(String graphContent, String regex, String replaceRegex) {
        Pattern instancePattern = Pattern.compile(regex, 2);
        Matcher match = instancePattern.matcher(graphContent);
        String resultGraph = match.replaceAll(replaceRegex);
        return resultGraph;
    }

    public void deleteTriple(Session session, String deleteTripleQuery) throws RepositoryProviderException {
        for (String namedGraph : this.graphString) {
            String removeTripleGraphContent = this.queryOnlyDataGraphsWithInferredFalse(session, deleteTripleQuery, namedGraph);
            this.deleteOldTripleFromGraph(session, removeTripleGraphContent, namedGraph);
        }
    }

    private void addNewTripleToGraph(Session session, String graphContent, String namedGraph) throws RepositoryProviderException {
        log.info((Object)"in adding new triple To graph method ");
        PostMethod method = this.getGraphMetod(graphContent, namedGraph);
        method.setParameter("action", "add");
        ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
        log.info((Object)"added content to graph");
    }

    private void deleteOldTripleFromGraph(Session session, String graphContent, String namedGraph) throws RepositoryProviderException {
        log.info((Object)"deleting old triple from graph method ");
        PostMethod method = this.getGraphMetod(graphContent, namedGraph);
        method.setParameter("action", "delete");
        ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
        log.info((Object)"added content to graph");
    }

    private PostMethod getGraphMetod(String garphContent, String namedGraph) {
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Graph.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("name", namedGraph);
        method.setParameter("content", garphContent);
        return method;
    }

    public String queryOnlyDataGraphsWithInferredFalse(Session session, String query, String namedGraph) throws RepositoryProviderException {
        log.info((Object)"in addToGraph method ");
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Query.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("default-graph-uri", namedGraph);
        method.setParameter("query", query);
        method.setParameter("inferred", "false");
        log.info((Object)"added content to graph");
        return ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
    }
}

